package org.fulib.scenarios.ast.decl;

import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.type.Type;


public interface VarDecl extends Decl
{
	// =============== Static Methods ===============
	static VarDecl of(String name, Type type, Expr expr) { return new Impl(name, type, expr); }
	// =============== Properties ===============
	String getName();
	void setName(String name);
	Type getType();
	void setType(Type type);
	Expr getExpr();
	void setExpr(Expr expr);

	// =============== Methods ===============
	<P, R> R accept(VarDecl.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements VarDecl
	{
		// =============== Fields ===============
		private String name;
		private Type type;
		private Expr expr;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(String name, Type type, Expr expr)
		{
			this.name = name;
			this.type = type;
			this.expr = expr;
		}

		// =============== Properties ===============
		@Override public String getName() { return this.name; }
		@Override public void setName(String name) { this.name = name; }
		@Override public Type getType() { return this.type; }
		@Override public void setType(Type type) { this.type = type; }
		@Override public Expr getExpr() { return this.expr; }
		@Override public void setExpr(Expr expr) { this.expr = expr; }

		// =============== Methods ===============
		@Override public <P, R> R accept(VarDecl.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Decl.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(VarDecl varDecl, P par);
	}
}
