package org.fulib.scenarios.ast.expr;

import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.access.ExampleAccess;
import org.fulib.scenarios.ast.expr.access.ListAttributeAccess;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.call.CreationExpr;
import org.fulib.scenarios.ast.expr.collection.CollectionExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.conditional.AttributeCheckExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperatorExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.expr.primary.NumberLiteral;
import org.fulib.scenarios.ast.expr.primary.PrimaryExpr;
import org.fulib.scenarios.ast.expr.primary.StringLiteral;


public interface Expr extends Node
{
	// =============== Methods ===============
	<P, R> R accept(Expr.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	interface Visitor<P, R> extends PrimaryExpr.Visitor<P, R>, AttributeAccess.Visitor<P, R>, ListAttributeAccess.Visitor<P, R>, ExampleAccess.Visitor<P, R>, CreationExpr.Visitor<P, R>, CallExpr.Visitor<P, R>, ConditionalExpr.Visitor<P, R>, CollectionExpr.Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(Expr expr, P par);
	}
}
