package org.fulib.scenarios.ast.expr.access;

import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.expr.Expr;


public interface ListAttributeAccess extends Expr
{
	// =============== Static Methods ===============
	static ListAttributeAccess of(Name name, Expr receiver) { return new Impl(name, receiver); }
	// =============== Properties ===============
	Name getName();
	void setName(Name name);
	Expr getReceiver();
	void setReceiver(Expr receiver);

	// =============== Methods ===============
	<P, R> R accept(ListAttributeAccess.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements ListAttributeAccess
	{
		// =============== Fields ===============
		private Name name;
		private Expr receiver;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(Name name, Expr receiver)
		{
			this.name = name;
			this.receiver = receiver;
		}

		// =============== Properties ===============
		@Override public Name getName() { return this.name; }
		@Override public void setName(Name name) { this.name = name; }
		@Override public Expr getReceiver() { return this.receiver; }
		@Override public void setReceiver(Expr receiver) { this.receiver = receiver; }

		// =============== Methods ===============
		@Override public <P, R> R accept(ListAttributeAccess.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Expr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(ListAttributeAccess listAttributeAccess, P par);
	}
}
