package org.fulib.scenarios.ast.expr.primary;

import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.expr.Expr;


public interface NumberLiteral extends PrimaryExpr
{
	// =============== Static Methods ===============
	static NumberLiteral of(double value) { return new Impl(value); }
	// =============== Properties ===============
	double getValue();
	void setValue(double value);

	// =============== Methods ===============
	<P, R> R accept(NumberLiteral.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements NumberLiteral
	{
		// =============== Fields ===============
		private double value;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(double value)
		{
			this.value = value;
		}

		// =============== Properties ===============
		@Override public double getValue() { return this.value; }
		@Override public void setValue(double value) { this.value = value; }

		// =============== Methods ===============
		@Override public <P, R> R accept(NumberLiteral.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(PrimaryExpr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Expr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(NumberLiteral numberLiteral, P par);
	}
}
