package org.fulib.scenarios.ast.sentence;

import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.expr.Expr;


public interface ExprSentence extends Sentence
{
	// =============== Static Methods ===============
	static ExprSentence of(Expr expr) { return new Impl(expr); }
	// =============== Properties ===============
	Expr getExpr();
	void setExpr(Expr expr);

	// =============== Methods ===============
	<P, R> R accept(ExprSentence.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements ExprSentence
	{
		// =============== Fields ===============
		private Expr expr;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(Expr expr)
		{
			this.expr = expr;
		}

		// =============== Properties ===============
		@Override public Expr getExpr() { return this.expr; }
		@Override public void setExpr(Expr expr) { this.expr = expr; }

		// =============== Methods ===============
		@Override public <P, R> R accept(ExprSentence.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Sentence.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(ExprSentence exprSentence, P par);
	}
}
