package org.fulib.scenarios.ast.sentence;

import java.util.List;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.expr.Expr;


public interface HasSentence extends Sentence
{
	// =============== Static Methods ===============
	static HasSentence of(Expr object, List<NamedExpr> clauses) { return new Impl(object, clauses); }
	// =============== Properties ===============
	Expr getObject();
	void setObject(Expr object);
	List<NamedExpr> getClauses();
	void setClauses(List<NamedExpr> clauses);

	// =============== Methods ===============
	<P, R> R accept(HasSentence.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements HasSentence
	{
		// =============== Fields ===============
		private Expr object;
		private List<NamedExpr> clauses;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(Expr object, List<NamedExpr> clauses)
		{
			this.object = object;
			this.clauses = clauses;
		}

		// =============== Properties ===============
		@Override public Expr getObject() { return this.object; }
		@Override public void setObject(Expr object) { this.object = object; }
		@Override public List<NamedExpr> getClauses() { return this.clauses; }
		@Override public void setClauses(List<NamedExpr> clauses) { this.clauses = clauses; }

		// =============== Methods ===============
		@Override public <P, R> R accept(HasSentence.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Sentence.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(HasSentence hasSentence, P par);
	}
}
