package org.fulib.scenarios.ast.sentence;

import java.util.List;
import org.fulib.scenarios.ast.MultiDescriptor;
import org.fulib.scenarios.ast.Node;


public interface ThereSentence extends Sentence
{
	// =============== Static Methods ===============
	static ThereSentence of(List<MultiDescriptor> descriptors) { return new Impl(descriptors); }
	// =============== Properties ===============
	List<MultiDescriptor> getDescriptors();
	void setDescriptors(List<MultiDescriptor> descriptors);

	// =============== Methods ===============
	<P, R> R accept(ThereSentence.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements ThereSentence
	{
		// =============== Fields ===============
		private List<MultiDescriptor> descriptors;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(List<MultiDescriptor> descriptors)
		{
			this.descriptors = descriptors;
		}

		// =============== Properties ===============
		@Override public List<MultiDescriptor> getDescriptors() { return this.descriptors; }
		@Override public void setDescriptors(List<MultiDescriptor> descriptors) { this.descriptors = descriptors; }

		// =============== Methods ===============
		@Override public <P, R> R accept(ThereSentence.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Sentence.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(ThereSentence thereSentence, P par);
	}
}
