package org.fulib.scenarios.ast.type;

import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.decl.ClassDecl;


public interface ClassType extends Type
{
	// =============== Static Methods ===============
	static ClassType of(ClassDecl classDecl) { return new Impl(classDecl); }
	// =============== Properties ===============
	ClassDecl getClassDecl();
	void setClassDecl(ClassDecl classDecl);

	// =============== Methods ===============
	<P, R> R accept(ClassType.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements ClassType
	{
		// =============== Fields ===============
		private ClassDecl classDecl;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(ClassDecl classDecl)
		{
			this.classDecl = classDecl;
		}

		// =============== Properties ===============
		@Override public ClassDecl getClassDecl() { return this.classDecl; }
		@Override public void setClassDecl(ClassDecl classDecl) { this.classDecl = classDecl; }

		// =============== Methods ===============
		@Override public <P, R> R accept(ClassType.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Type.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(ClassType classType, P par);
	}
}
