package org.fulib.scenarios.ast.type;

import org.fulib.scenarios.ast.Node;


public interface UnresolvedType extends Type
{
	// =============== Static Methods ===============
	static UnresolvedType of(String name) { return new Impl(name); }
	// =============== Properties ===============
	String getName();
	void setName(String name);

	// =============== Methods ===============
	<P, R> R accept(UnresolvedType.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements UnresolvedType
	{
		// =============== Fields ===============
		private String name;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(String name)
		{
			this.name = name;
		}

		// =============== Properties ===============
		@Override public String getName() { return this.name; }
		@Override public void setName(String name) { this.name = name; }

		// =============== Methods ===============
		@Override public <P, R> R accept(UnresolvedType.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Type.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(UnresolvedType unresolvedType, P par);
	}
}
