/*
 * Decompiled with CFR 0.152.
 */
package org.fulib;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.fulib.StrUtil;
import org.fulib.classmodel.CodeFragment;
import org.fulib.classmodel.FileFragmentMap;
import org.fulib.util.Token;

public class Parser {
    public static final char EOF = '\u0000';
    public static final String VOID = "void";
    public static final String CLASS = "class";
    public static final String INTERFACE = "interface";
    public static final String ENUM = "enum";
    public static final char COMMENT_START = 'c';
    public static final String PACKAGE = "package";
    public static final char LONG_COMMENT_END = 'd';
    public static final String CONSTRUCTOR = "constructor";
    public static final String ATTRIBUTE = "attribute";
    public static final String ENUMVALUE = "enumvalue";
    public static final String METHOD = "method";
    public static final String METHOD_END = "methodEnd";
    public static final String IMPORT = "import";
    public static final String CLASS_BODY = "classBody";
    public static final String CLASS_END = "classEnd";
    public static final String NAME_TOKEN = "nameToken";
    public static final String LAST_RETURN_POS = "lastReturnPos";
    public static final String IMPLEMENTS = "implements";
    public static final String QUALIFIED_NAME = "qualifiedName";
    public static final String EXTENDS = "extends";
    public static final String GAP = "gap:";
    public static char NEW_LINE = (char)10;
    private StringBuilder fileBody = null;
    private Token lookAheadToken = null;
    private Token currentToken;
    private char currentChar;
    private int index;
    private FileFragmentMap fragmentMap;
    private boolean verbose = false;
    private int endPos;
    private char lookAheadChar;
    private int lookAheadIndex;
    private String searchString;
    private int methodBodyStartPos;
    private String classModifier;
    private int lastFragmentEndPos;
    public Token currentRealToken;
    public Token lookAheadRealToken;
    public Token previousRealToken;
    public int indexOfResult;
    private Token previousToken;
    private String className;
    private String classType;
    public int lastIfStart;
    public int lastIfEnd;
    private int lastReturnStart;
    private LinkedHashMap<String, Integer> methodBodyQualifiedNames = new LinkedHashMap();
    private String fileName;

    public static FileFragmentMap parse(String fileName) {
        return new Parser().doParse(fileName);
    }

    public FileFragmentMap doParse(String fileName) {
        this.setFileName(fileName);
        this.loadFile(fileName);
        if (this.fileBody != null) {
            this.indexOf(CLASS_END);
        }
        return this.fragmentMap;
    }

    private void loadFile(String fileName) {
        this.fragmentMap = new FileFragmentMap(fileName);
        Path path = Paths.get(fileName, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                byte[] bytes = Files.readAllBytes(path);
                this.withFileBody(new StringBuilder(new String(bytes)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Parser withFileBody(StringBuilder fileBody) {
        this.fileBody = fileBody;
        return this;
    }

    private Parser init(int startPos, int endPos) {
        this.currentChar = '\u0000';
        this.index = startPos - 1;
        this.lookAheadIndex = startPos - 1;
        this.lastFragmentEndPos = startPos - 1;
        this.endPos = endPos;
        this.nextChar();
        this.nextChar();
        this.currentToken = new Token();
        this.lookAheadToken = new Token();
        this.previousToken = new Token();
        this.nextToken();
        this.nextToken();
        this.currentRealToken = new Token();
        this.lookAheadRealToken = new Token();
        this.previousRealToken = new Token();
        this.nextRealToken();
        this.nextRealToken();
        return this;
    }

    public int indexOf(String searchString) {
        this.indexOfResult = -1;
        this.init(0, this.fileBody.length());
        this.searchString = searchString;
        try {
            this.parseFile();
        }
        catch (SearchStringFoundException searchStringFoundException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.indexOfResult;
    }

    private void parseFile() {
        if (this.currentRealTokenEquals(PACKAGE)) {
            this.parsePackageDecl();
        }
        int startPos = this.currentRealToken.startPos;
        while (this.currentRealTokenEquals(IMPORT)) {
            this.parseImport();
        }
        this.parseClassDecl();
    }

    private void parseClassDecl() {
        int startPos;
        int preCommentStartPos = this.currentRealToken.preCommentStartPos;
        int preCommentEndPos = this.currentRealToken.preCommentEndPos;
        int startPosAnnotations = this.currentRealToken.startPos;
        while ("@".equals(this.currentRealWord())) {
            String string = this.parseAnnotations();
        }
        int startPosClazz = this.currentRealToken.startPos;
        this.classModifier = this.parseModifiers();
        String classTyp = this.parseClassType();
        this.className = this.currentRealWord();
        this.nextRealToken();
        this.parseGenericTypeSpec();
        if (EXTENDS.equals(this.currentRealWord())) {
            startPos = this.currentRealToken.startPos;
            this.skip(EXTENDS);
            this.parseTypeRef();
        }
        if (IMPLEMENTS.equals(this.currentRealWord())) {
            startPos = this.currentRealToken.startPos;
            this.skip(IMPLEMENTS);
            while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals('{')) {
                this.nextRealToken();
                if (!this.currentRealKindEquals(',')) continue;
                this.nextRealToken();
            }
        }
        this.addCodeFragment(CLASS, startPosAnnotations, this.currentRealToken.endPos);
        this.parseClassBody();
    }

    private void parseGenericTypeSpec() {
        if (this.currentRealKindEquals('<')) {
            this.skipTo('>');
            this.nextRealToken();
        }
    }

    private String parseClassType() {
        this.classType = "";
        if (CLASS.equals(this.currentRealWord())) {
            this.classType = CLASS;
        } else if (INTERFACE.equals(this.currentRealWord())) {
            this.classType = INTERFACE;
        } else if (ENUM.equals(this.currentRealWord())) {
            this.classType = ENUM;
        }
        if (!this.classType.isEmpty()) {
            this.skip(this.classType);
        }
        return this.classType;
    }

    private void parseClassBody() {
        this.skip("{");
        while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals('}')) {
            this.parseMemberDecl();
        }
        if (this.currentRealKindEquals('}')) {
            this.addCodeFragment(CLASS_END, this.currentRealToken.startPos, this.currentRealToken.endPos);
        }
        this.addCodeFragment(GAP, this.currentRealToken.endPos + 1, this.fileBody.length() - 1);
    }

    private void parseMemberDecl() {
        int preCommentStartPos = this.currentRealToken.preCommentStartPos;
        int preCommentEndPos = this.currentRealToken.preCommentEndPos;
        int annotationsStartPos = this.currentRealToken.startPos;
        String annotations = this.parseAnnotations();
        int startPos = this.currentRealToken.startPos;
        String modifiers = this.parseModifiers();
        if (this.currentRealTokenEquals("<")) {
            this.skip("<");
            while (!this.currentRealTokenEquals(">")) {
                this.nextRealToken();
            }
            this.skip(">");
        }
        if (this.currentRealTokenEquals(CLASS) || this.currentRealTokenEquals(INTERFACE)) {
            while (!this.currentRealTokenEquals("{")) {
                this.nextRealToken();
            }
            this.skipBody();
            return;
        }
        if (this.currentRealTokenEquals(ENUM)) {
            this.skip(ENUM);
            this.nextRealToken();
            this.skipBody();
            return;
        }
        if (this.currentRealTokenEquals(this.className) && this.lookAheadRealToken.kind == '(') {
            this.skip(this.className);
            String params = this.parseFormalParamList();
            if (this.currentRealTokenEquals("throws")) {
                this.skipTo('{');
            }
            this.methodBodyStartPos = this.currentRealToken.startPos;
            this.parseBlock();
            String constructorSignature = "constructor:" + this.className + params;
            this.addCodeFragment(constructorSignature, annotationsStartPos, this.previousRealToken.endPos);
        } else {
            String type = this.parseTypeRef();
            String memberName = this.currentRealWord();
            this.verbose("parsing member: " + memberName);
            this.nextRealToken();
            if (this.currentRealKindEquals('=')) {
                this.skip("=");
                this.parseExpression();
                this.addCodeFragment("attribute:" + memberName, annotationsStartPos, this.currentRealToken.endPos);
                this.skip(";");
            } else if (this.currentRealKindEquals(';') && !",".equals(memberName)) {
                this.addCodeFragment("attribute:" + memberName, annotationsStartPos, this.currentRealToken.endPos);
                this.skip(";");
            } else if (this.currentRealKindEquals('(')) {
                String params = this.parseFormalParamList();
                if (type.startsWith("@")) {
                    return;
                }
                String throwsTags = null;
                if (this.currentRealTokenEquals("throws")) {
                    int temp = this.currentRealToken.startPos;
                    this.skipTo('{');
                    throwsTags = this.fileBody.substring(temp, this.currentRealToken.startPos);
                }
                this.methodBodyStartPos = this.currentRealToken.startPos;
                if (this.currentRealKindEquals('{')) {
                    this.parseBlock();
                } else if (this.currentRealKindEquals(';')) {
                    this.skip(';');
                }
                String methodSignature = "method:" + memberName + params;
                this.addCodeFragment(methodSignature, annotationsStartPos, this.previousRealToken.endPos);
            } else if (ENUM.equals(this.classType)) {
                if (",".equalsIgnoreCase(memberName) || ";".equalsIgnoreCase(memberName) || !";".equals(type) && this.currentRealKindEquals('\u0000')) {
                    String params = "enumvalue:" + type;
                } else {
                    String enumSignature = "enumvalue:" + type;
                    this.skipTo(';');
                    this.skip(";");
                }
            }
        }
    }

    private String parseAnnotations() {
        String result = "";
        while ("@".equals(this.currentRealWord())) {
            result = result + this.currentRealWord();
            this.nextRealToken();
            result = result + this.currentRealWord();
            this.nextRealToken();
            while (this.currentRealWord().equals(".")) {
                result = result + this.currentRealWord();
                this.nextRealToken();
                result = result + this.currentRealWord();
                this.nextRealToken();
            }
            if (!"(".equals(this.currentRealWord())) continue;
            result = result + this.currentRealWord();
            this.nextRealToken();
            while (!")".equals(this.currentRealWord())) {
                result = result + this.currentRealWord();
                this.nextRealToken();
            }
            result = result + this.currentRealWord();
            this.nextRealToken();
        }
        return result;
    }

    private void skipTo(char c) {
        while (!this.currentRealKindEquals(c) && !this.currentRealKindEquals('\u0000')) {
            this.nextRealToken();
        }
    }

    private void skipBody() {
        int index = 1;
        while (index > 0 && !this.currentRealKindEquals('\u0000')) {
            this.nextRealToken();
            if (this.currentRealTokenEquals("{")) {
                ++index;
                continue;
            }
            if (!this.currentRealTokenEquals("}")) continue;
            --index;
        }
        this.nextRealToken();
    }

    private void verbose(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    private void parseExpression() {
        while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals(';')) {
            if (this.currentRealKindEquals('{')) {
                this.parseBlock();
                continue;
            }
            this.nextRealToken();
        }
    }

    private void parseBlock() {
        this.skip("{");
        while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals('}')) {
            if (this.currentRealKindEquals('{')) {
                this.parseBlock();
                continue;
            }
            this.nextRealToken();
        }
        this.skip("}");
    }

    private String parseTypeRef() {
        StringBuilder typeString = new StringBuilder();
        String typeName = VOID;
        if (this.currentRealTokenEquals(VOID)) {
            this.nextRealToken();
        } else {
            typeName = this.parseQualifiedName();
        }
        typeString.append(typeName);
        if (this.currentRealKindEquals('<')) {
            this.parseGenericTypeDefPart(typeString);
        }
        if (this.currentRealKindEquals('[')) {
            typeString.append("[]");
            this.skip("[");
            while (!"]".equals(this.currentRealWord()) && !this.currentRealKindEquals('\u0000')) {
                this.nextRealToken();
            }
            this.skip("]");
        }
        if (this.currentRealKindEquals('.')) {
            typeString.append("...");
            this.skip(".");
            this.skip(".");
            this.skip(".");
        }
        if (EXTENDS.equals(this.lookAheadRealToken.text.toString())) {
            typeString.append((CharSequence)this.currentRealToken.text);
            this.nextRealToken();
            typeString.append((CharSequence)this.currentRealToken.text);
            this.nextRealToken();
            typeString.append((CharSequence)this.currentRealToken.text);
            this.nextRealToken();
            typeString.append((CharSequence)this.currentRealToken.text);
        }
        if ("@".equals(typeString.toString())) {
            typeString.append((CharSequence)this.currentRealToken.text);
        }
        return typeString.toString();
    }

    private void parseGenericTypeDefPart(StringBuilder typeString) {
        this.skip("<");
        typeString.append('<');
        while (!this.currentRealKindEquals('>') && !this.currentRealKindEquals('\u0000')) {
            if (this.currentRealKindEquals('<')) {
                this.parseGenericTypeDefPart(typeString);
                continue;
            }
            typeString.append(this.currentRealWord());
            this.nextRealToken();
        }
        typeString.append(">");
        this.skip(">");
    }

    private String parseFormalParamList() {
        StringBuilder paramList = new StringBuilder().append('(');
        this.skip("(");
        while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals(')')) {
            int typeStartPos = this.currentRealToken.startPos;
            this.parseTypeRef();
            int typeEndPos = this.currentRealToken.startPos - 1;
            paramList.append(this.fileBody.substring(typeStartPos, typeEndPos));
            if (this.currentRealKindEquals(')')) break;
            this.nextRealToken();
            if (!this.currentRealKindEquals(',')) continue;
            this.skip(",");
            paramList.append(',');
        }
        this.skip(")");
        paramList.append(')');
        return paramList.toString();
    }

    private boolean currentRealKindEquals(char c) {
        return this.currentRealToken.kind == c;
    }

    private String currentRealWord() {
        return this.currentRealToken.text.toString();
    }

    private boolean currentRealTokenEquals(String word) {
        return StrUtil.stringEquals(this.currentRealWord(), word);
    }

    private String parseModifiers() {
        String result = "";
        String modifiers = " public protected private static abstract final native synchronized transient volatile strictfp ";
        while (modifiers.indexOf(" " + this.currentRealWord() + " ") >= 0) {
            result = result + this.currentRealWord() + " ";
            this.nextRealToken();
        }
        return result;
    }

    private void parseImport() {
        int startPos = this.currentRealToken.startPos;
        this.nextRealToken();
        String modifier = this.parseModifiers();
        String importName = this.parseQualifiedName();
        if (this.currentRealToken.kind == '*') {
            this.skip("*");
        }
        this.skip(";");
        this.addCodeFragment("import:" + importName, startPos, this.previousRealToken.endPos);
    }

    private void parsePackageDecl() {
        int startPos = this.currentRealToken.startPos;
        this.nextRealToken();
        String packageName = this.parseQualifiedName();
        this.skip(";");
        this.addCodeFragment(PACKAGE, startPos, this.previousRealToken.endPos);
    }

    private void addCodeFragment(String key, int startPos, int endPos) {
        if (endPos < startPos) {
            endPos = startPos - 1;
        }
        CodeFragment gap = new CodeFragment().setKey(GAP).setText(this.fileBody.substring(this.lastFragmentEndPos + 1, startPos));
        this.fragmentMap.add(gap);
        CodeFragment codeFragment = new CodeFragment().setKey(key).setText(this.fileBody.substring(startPos, endPos + 1));
        this.fragmentMap.add(codeFragment);
        this.lastFragmentEndPos = endPos;
    }

    private String parseQualifiedName() {
        int startPos = this.currentRealToken.startPos;
        int endPos = this.currentRealToken.endPos;
        this.nextRealToken();
        while (this.currentRealKindEquals('.') && this.lookAheadRealToken.kind != '.' && !this.currentRealKindEquals('\u0000')) {
            this.skip(".");
            endPos = this.currentRealToken.endPos;
            this.nextRealToken();
        }
        return this.fileBody.substring(startPos, endPos + 1);
    }

    private void skip(char c) {
        if (this.currentRealKindEquals(c)) {
            this.nextRealToken();
        } else {
            System.out.println("Parser Problem: '" + this.currentRealToken.kind + "' : but '" + c + "' expected in " + this.className + ".java  at line " + this.getLineIndexOf(this.currentRealToken.startPos) + "\n" + this.getLineForPos(this.currentRealToken.startPos));
        }
    }

    private void skip(String string) {
        if (!this.currentRealTokenEquals(string)) {
            System.err.println("Parser Error: expected token " + string + " found " + this.currentRealWord() + " at pos " + this.currentRealToken.startPos + " at line " + this.getLineIndexOf(this.currentRealToken.startPos, this.fileBody) + " in file \n" + this.fileName);
            throw new RuntimeException("parse error");
        }
        this.nextRealToken();
    }

    private long getLineIndexOf(int startPos, StringBuilder fileBody) {
        long count = 1L;
        String substring = fileBody.substring(0, startPos);
        for (int index = 0; index < substring.length() - 1; ++index) {
            char firstChar = substring.charAt(index);
            if (firstChar != NEW_LINE) continue;
            ++count;
        }
        return count;
    }

    public long getLineIndexOf(int startPos) {
        if (startPos < 0) {
            return -1L;
        }
        long count = 1L;
        String substring = this.fileBody.substring(0, startPos);
        for (int index = 0; index < substring.length() - 1; ++index) {
            char firstChar = substring.charAt(index);
            if (firstChar != NEW_LINE) continue;
            ++count;
        }
        return count;
    }

    private void nextRealToken() {
        Token tmp = this.previousRealToken;
        this.previousRealToken = this.currentRealToken;
        this.currentRealToken = this.lookAheadRealToken;
        this.lookAheadRealToken = tmp;
        this.lookAheadRealToken.kind = '\u0000';
        this.lookAheadRealToken.preCommentStartPos = 0;
        this.lookAheadRealToken.preCommentEndPos = 0;
        this.lookAheadRealToken.text.delete(0, this.lookAheadRealToken.text.length());
        while (this.currentToken.kind == 'c' || this.currentToken.kind == NEW_LINE) {
            if (this.currentToken.text.indexOf("/*") == 0) {
                this.parseLongComment();
                continue;
            }
            if (this.currentToken.text.indexOf("//") == 0) {
                this.parseLineComment();
                continue;
            }
            this.nextToken();
        }
        if (this.currentToken.kind == '\"') {
            int constStartPos = this.currentToken.startPos;
            this.parseStringConstant();
            this.lookAheadRealToken.kind = (char)34;
            this.lookAheadRealToken.text.append(this.fileBody.substring(constStartPos, this.previousToken.startPos + 1));
            this.lookAheadRealToken.startPos = constStartPos;
            this.lookAheadRealToken.endPos = this.previousToken.startPos;
        } else if (this.currentToken.kind == '\'') {
            int constStartPos = this.currentToken.startPos;
            this.parseCharConstant();
            this.lookAheadRealToken.kind = (char)39;
            this.lookAheadRealToken.text.append(this.fileBody.substring(constStartPos, this.previousToken.startPos + 1));
            this.lookAheadRealToken.startPos = constStartPos;
            this.lookAheadRealToken.endPos = this.previousToken.startPos;
        } else if (this.currentToken.kind == '9') {
            this.lookAheadRealToken.kind = this.currentToken.kind;
            this.lookAheadRealToken.text.append((int)this.currentToken.value);
            this.lookAheadRealToken.startPos = this.currentToken.startPos;
            this.lookAheadRealToken.endPos = this.currentToken.endPos;
            this.nextToken();
        } else {
            this.lookAheadRealToken.kind = this.currentToken.kind;
            this.lookAheadRealToken.text.append(this.currentToken.text.toString());
            this.lookAheadRealToken.startPos = this.currentToken.startPos;
            this.lookAheadRealToken.endPos = this.currentToken.endPos;
            this.nextToken();
        }
    }

    private void parseCharConstant() {
        this.skipBasicToken('\'');
        if (this.currentToken.kind == '\\') {
            this.nextToken();
        }
        this.nextToken();
        this.skipBasicToken('\'');
    }

    private void parseLineComment() {
        this.lookAheadRealToken.preCommentStartPos = this.currentToken.startPos;
        this.nextToken();
        while (this.currentToken.kind != '\u0000' && this.currentToken.kind != '\n') {
            this.nextToken();
        }
        this.lookAheadRealToken.preCommentEndPos = this.currentToken.endPos;
        this.nextToken();
    }

    private void parseStringConstant() {
        this.skipBasicToken('\"');
        while (this.currentToken.kind != '\u0000' && this.currentToken.kind != '\"') {
            if (this.currentToken.kind == '\\') {
                this.nextToken();
            }
            this.nextToken();
        }
        this.skipBasicToken('\"');
    }

    private void skipBasicToken(char s) {
        if (this.currentToken.kind == s) {
            this.nextToken();
        }
    }

    private void parseLongComment() {
        this.lookAheadRealToken.preCommentStartPos = this.currentToken.startPos;
        this.nextToken();
        while (this.currentToken.kind != '\u0000' && this.currentToken.kind != 'd') {
            this.nextToken();
        }
        this.lookAheadRealToken.preCommentEndPos = this.currentToken.endPos;
        this.nextToken();
    }

    private void nextToken() {
        Token tmp = this.previousToken;
        this.previousToken = this.currentToken;
        this.currentToken = this.lookAheadToken;
        this.lookAheadToken = tmp;
        this.lookAheadToken.kind = '\u0000';
        this.lookAheadToken.text.delete(0, this.lookAheadToken.text.length());
        int state = 105;
        while (true) {
            switch (state) {
                case 105: {
                    if (Character.isLetter(this.currentChar) || this.currentChar == '_') {
                        state = 118;
                        this.lookAheadToken.kind = (char)118;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.startPos = this.index;
                        break;
                    }
                    if (this.currentChar == '\u0000') {
                        this.lookAheadToken.kind = '\u0000';
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        return;
                    }
                    if (Character.isDigit(this.currentChar)) {
                        state = 57;
                        this.lookAheadToken.kind = (char)57;
                        this.lookAheadToken.value = this.currentChar - 48;
                        this.lookAheadToken.startPos = this.index;
                        break;
                    }
                    if (this.currentChar == '/' && (this.lookAheadChar == '*' || this.lookAheadChar == '/')) {
                        this.lookAheadToken.kind = (char)99;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (this.currentChar == '*' && this.lookAheadChar == '/') {
                        this.lookAheadToken.kind = (char)100;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if ("+-*/\\\"'~=()><{}!.,@[]&|?;:#".indexOf(this.currentChar) >= 0) {
                        this.lookAheadToken.kind = this.currentChar;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (this.currentChar == NEW_LINE) {
                        this.lookAheadToken.kind = NEW_LINE;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (!Character.isWhitespace(this.currentChar)) break;
                    break;
                }
                case 57: {
                    if (Character.isDigit(this.currentChar)) {
                        this.lookAheadToken.value = this.lookAheadToken.value * 10.0 + (double)(this.currentChar - 48);
                        break;
                    }
                    if (this.currentChar == '.') {
                        state = 56;
                        break;
                    }
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
                case 56: {
                    if (Character.isDigit(this.currentChar)) break;
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
                case 118: {
                    if (Character.isLetter(this.currentChar) || Character.isDigit(this.currentChar) || this.currentChar == '_') {
                        this.lookAheadToken.text.append(this.currentChar);
                        break;
                    }
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
            }
            this.nextChar();
        }
    }

    private void nextChar() {
        this.currentChar = this.lookAheadChar;
        this.index = this.lookAheadIndex;
        this.lookAheadChar = '\u0000';
        while (this.lookAheadChar == '\u0000' && this.lookAheadIndex < this.endPos - 1) {
            ++this.lookAheadIndex;
            this.lookAheadChar = this.fileBody.charAt(this.lookAheadIndex);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getLineForPos(int currentInsertPos) {
        String part1 = this.fileBody.substring(0, currentInsertPos);
        String part2 = this.fileBody.substring(currentInsertPos);
        int startPos = 1 + part1.lastIndexOf("\n");
        int endPos = currentInsertPos + part2.indexOf("\n");
        String lineString = "\"" + this.fileBody.substring(startPos, endPos).toString() + "\"";
        int index = currentInsertPos - startPos;
        char[] chars1 = new char[index];
        Arrays.fill(chars1, ' ');
        String string1 = new String(chars1);
        String posString = "\n" + string1 + "^";
        return lineString + posString;
    }

    class SearchStringFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        SearchStringFoundException() {
        }
    }
}

