/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.builder;

import org.fulib.builder.AssociationBuilder;
import org.fulib.builder.ClassModelBuilder;
import org.fulib.classmodel.AssocRole;
import org.fulib.classmodel.Attribute;
import org.fulib.classmodel.ClassModel;
import org.fulib.classmodel.Clazz;

public class ClassBuilder {
    private Clazz clazz;

    public ClassBuilder(ClassModel classModel, String className) {
        ClassModelBuilder.checkValidJavaId(className);
        if (classModel.getClazz(className) != null) {
            throw new IllegalArgumentException("duplicate class name" + className);
        }
        Clazz clazz = new Clazz();
        clazz.setModel(classModel);
        clazz.setName(className);
        clazz.setPropertyStyle(classModel.getDefaultPropertyStyle());
        this.setClazz(clazz);
    }

    private void setClazz(Clazz clazz) {
        this.clazz = clazz;
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public ClassBuilder buildAttribute(String name, String type) {
        this.buildAttribute(name, type, null);
        return this;
    }

    public ClassBuilder buildAttribute(String name, String type, String initialValue) {
        ClassModelBuilder.checkValidJavaId(name);
        if (this.clazz.getAttribute(name) != null || this.clazz.getRole(name) != null) {
            throw new IllegalArgumentException("duplicate attribute / role name");
        }
        Attribute attribute = new Attribute();
        attribute.setClazz(this.clazz);
        attribute.setName(name);
        attribute.setType(type);
        attribute.setPropertyStyle(this.clazz.getPropertyStyle());
        attribute.setInitialization(initialValue);
        return this;
    }

    public AssociationBuilder buildAssociation(ClassBuilder otherClass, String myRoleName, int myCardinality, String otherRoleName, int otherCardinality) {
        ClassModelBuilder.checkValidJavaId(myRoleName);
        if (otherRoleName != null) {
            ClassModelBuilder.checkValidJavaId(otherRoleName);
        }
        if (this.clazz.getAttribute(myRoleName) != null || this.clazz.getRole(myRoleName) != null) {
            throw new IllegalArgumentException("duplicate attribute / role name");
        }
        if (myRoleName.equals(otherRoleName) && myCardinality != otherCardinality) {
            throw new IllegalArgumentException("duplicate attribute / role name");
        }
        AssocRole myRole = new AssocRole().setClazz(this.getClazz()).setName(myRoleName).setCardinality(myCardinality).setPropertyStyle(this.clazz.getPropertyStyle()).setRoleType(this.clazz.getModel().getDefaultRoleType());
        AssocRole otherRole = new AssocRole().setClazz(otherClass.getClazz()).setName(otherRoleName).setCardinality(otherCardinality).setPropertyStyle(this.clazz.getPropertyStyle()).setRoleType(this.clazz.getModel().getDefaultRoleType());
        myRole.setOther(otherRole);
        return new AssociationBuilder(myRole);
    }

    public ClassBuilder setSuperClass(ClassBuilder superClass) {
        this.clazz.setSuperClass(superClass.getClazz());
        return this;
    }

    public ClassBuilder setJavaFXPropertyStyle() {
        this.clazz.setPropertyStyle("JavaFX");
        return this;
    }
}

