/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.codegen;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fulib.scenarios.ast.expr.conditional.AttributeCheckExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperator;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperatorExpr;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.codegen.CodeGenerator;
import org.fulib.scenarios.codegen.ExprGenerator;
import org.fulib.scenarios.transform.Typer;

public enum AssertionGenerator implements ConditionalExpr.Visitor<CodeGenerator, Object>
{
    INSTANCE;

    private static final Pattern METHOD_PATTERN;

    @Override
    public Object visit(ConditionalExpr conditionalExpr, CodeGenerator codeGen) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object visit(AttributeCheckExpr attributeCheckExpr, CodeGenerator codeGen) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object visit(ConditionalOperatorExpr conditionalOperatorExpr, CodeGenerator par) {
        boolean numeric = AssertionGenerator.isNumeric(conditionalOperatorExpr);
        ConditionalOperator operator = conditionalOperatorExpr.getOperator();
        String assertionFormat = numeric ? operator.getNumberAssertion() : operator.getObjectAssertion();
        AssertionGenerator.generateCondOp(conditionalOperatorExpr, par, assertionFormat);
        Matcher matcher = METHOD_PATTERN.matcher(assertionFormat);
        while (matcher.find()) {
            String methodName = matcher.group(1);
            if (methodName.startsWith("assert")) {
                par.addImport("static org.junit.Assert." + methodName);
                continue;
            }
            par.addImport("static org.hamcrest.CoreMatchers." + methodName);
        }
        return null;
    }

    static void generateCondOp(ConditionalOperatorExpr conditionalOperatorExpr, CodeGenerator par, String format) {
        int lhsIndex = format.indexOf("<lhs>");
        int rhsIndex = format.indexOf("<rhs>");
        par.bodyBuilder.append(format, 0, lhsIndex);
        conditionalOperatorExpr.getLhs().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(format, lhsIndex + 5, rhsIndex);
        conditionalOperatorExpr.getRhs().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(format, rhsIndex + 5, format.length());
    }

    static boolean isNumeric(ConditionalOperatorExpr conditionalOperatorExpr) {
        Type lhsType = conditionalOperatorExpr.getLhs().accept(Typer.INSTANCE, null);
        Type rhsType = conditionalOperatorExpr.getRhs().accept(Typer.INSTANCE, null);
        return Typer.isNumeric(lhsType) || Typer.isNumeric(rhsType);
    }

    static {
        METHOD_PATTERN = Pattern.compile("(?!\\.)(\\w+)\\(");
    }
}

