/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.codegen;

import org.fulib.classmodel.Clazz;
import org.fulib.classmodel.FMethod;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.codegen.CodeGenerator;
import org.fulib.scenarios.codegen.ExprGenerator;
import org.fulib.scenarios.codegen.SentenceGenerator;
import org.fulib.scenarios.codegen.TypeGenerator;

public enum DeclGenerator implements Decl.Visitor<CodeGenerator, Object>
{
    INSTANCE;


    @Override
    public Object visit(Decl decl, CodeGenerator par) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object visit(ClassDecl classDecl, CodeGenerator par) {
        par.clazz = par.modelManager.haveClass(classDecl.getName());
        for (AttributeDecl attributeDecl : classDecl.getAttributes().values()) {
            attributeDecl.accept(this, par);
        }
        for (AssociationDecl associationDecl : classDecl.getAssociations().values()) {
            associationDecl.accept(this, par);
        }
        for (MethodDecl method : classDecl.getMethods()) {
            method.accept(this, par);
        }
        return null;
    }

    @Override
    public Object visit(AttributeDecl attributeDecl, CodeGenerator par) {
        Clazz clazz = par.modelManager.haveClass(attributeDecl.getOwner().getName());
        par.modelManager.haveAttribute(clazz, attributeDecl.getName(), attributeDecl.getType().accept(TypeGenerator.INSTANCE, par));
        return null;
    }

    @Override
    public Object visit(AssociationDecl associationDecl, CodeGenerator par) {
        Clazz clazz = par.modelManager.haveClass(associationDecl.getOwner().getName());
        Clazz otherClazz = par.modelManager.haveClass(associationDecl.getTarget().getName());
        AssociationDecl other = associationDecl.getOther();
        if (other != null) {
            par.modelManager.haveRole(clazz, associationDecl.getName(), otherClazz, associationDecl.getCardinality(), other.getName(), other.getCardinality());
        } else {
            par.modelManager.haveRole(clazz, associationDecl.getName(), otherClazz, associationDecl.getCardinality());
        }
        return null;
    }

    @Override
    public Object visit(MethodDecl methodDecl, CodeGenerator par) {
        Clazz clazz = par.modelManager.haveClass(methodDecl.getOwner().getName());
        FMethod method = new FMethod();
        method.setClazz(clazz);
        method.writeName(methodDecl.getName());
        method.writeReturnType(methodDecl.getType().accept(TypeGenerator.INSTANCE, par));
        for (ParameterDecl parameter : methodDecl.getParameters()) {
            String name = parameter.getName();
            if ("this".equals(name)) continue;
            method.readParams().put(name, parameter.getType().accept(TypeGenerator.INSTANCE, par));
        }
        par.bodyBuilder = new StringBuilder();
        methodDecl.getBody().accept(SentenceGenerator.INSTANCE, par);
        method.setMethodBody(par.bodyBuilder.toString());
        par.bodyBuilder = null;
        return null;
    }

    @Override
    public Object visit(ParameterDecl parameterDecl, CodeGenerator par) {
        throw new UnsupportedOperationException("handled by visit(MethodDecl, ...)");
    }

    @Override
    public Object visit(VarDecl varDecl, CodeGenerator par) {
        par.emitIndent();
        par.bodyBuilder.append(varDecl.getType().accept(TypeGenerator.INSTANCE, par)).append(' ').append(varDecl.getName()).append(" = ");
        varDecl.getExpr().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(";\n");
        return null;
    }
}

