/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.fulib.Generator;
import org.fulib.StrUtil;
import org.fulib.TypeScriptParser;
import org.fulib.classmodel.AssocRole;
import org.fulib.classmodel.Attribute;
import org.fulib.classmodel.Clazz;
import org.fulib.classmodel.FileFragmentMap;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.StringRenderer;

public class Generator4TypeScriptClassFile {
    private String customTemplatesFile;

    public Generator4TypeScriptClassFile setCustomTemplatesFile(String customTemplatesFile) {
        this.customTemplatesFile = customTemplatesFile;
        return this;
    }

    public void generate(Clazz clazz) {
        String classFileName = clazz.getModel().getPackageSrcFolder() + "/" + clazz.getName() + ".ts";
        FileFragmentMap fragmentMap = TypeScriptParser.parse(classFileName);
        this.generateClassDecl(clazz, fragmentMap);
        this.generateAttributes(clazz, fragmentMap);
        this.generateConstructor(clazz, fragmentMap);
        this.generateRoles(clazz, fragmentMap);
        this.generateRemoveYou(clazz, fragmentMap);
        fragmentMap.add("classEnd", "}", 1);
        if (clazz.getModified() && fragmentMap.classBodyIsEmpty(fragmentMap)) {
            Path path = Paths.get(classFileName, new String[0]);
            try {
                Files.deleteIfExists(path);
                Logger.getLogger(Generator.class.getName()).info("\n   deleting empty file " + classFileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            fragmentMap.writeFile();
        }
    }

    private void generateClassDecl(Clazz clazz, FileFragmentMap fragmentMap) {
        STGroup group = this.createSTGroup("templates/typescript/tsClassDecl.stg");
        ST st = group.getInstanceOf("classDecl");
        st.add("name", (Object)clazz.getName());
        String result = st.render();
        fragmentMap.add("class", result, 1);
    }

    private void generateConstructor(Clazz clazz, FileFragmentMap fragmentMap) {
        String initValue;
        STGroup group = this.createSTGroup("templates/typescript/tsClassDecl.stg");
        StringBuilder buf = new StringBuilder();
        for (Attribute attribute : clazz.getAttributes()) {
            initValue = "0";
            if (attribute.getType().equals("String")) {
                initValue = "''";
            }
            buf.append("this.").append(attribute.getName()).append(" = " + initValue + ";\n");
        }
        for (AssocRole role : clazz.getRoles()) {
            initValue = "[]";
            if (role.getCardinality() == 1) {
                initValue = "null";
            }
            buf.append("this._").append(role.getName()).append(" = ").append(initValue).append(";\n");
        }
        ST st = group.getInstanceOf("constructor");
        st.add("body", (Object)buf.toString());
        String result = st.render();
        fragmentMap.add("method:constructor()", result, 2);
    }

    private void generateAttributes(Clazz clazz, FileFragmentMap fragmentMap) {
        for (Attribute attr : clazz.getAttributes()) {
            STGroup group = this.createSTGroup("templates/typescript/attributes.stg");
            String attrType = attr.getType();
            if (" double int ".indexOf(attrType = StrUtil.downFirstChar(attrType)) >= 0) {
                attrType = "number";
            }
            ST attrTemplate = group.getInstanceOf("attrDecl");
            attrTemplate.add("type", (Object)attrType);
            attrTemplate.add("name", (Object)attr.getName());
            String result = attrTemplate.render();
            fragmentMap.add("attribute:" + attr.getName(), result, 2, attr.getModified());
        }
    }

    private void generateRoles(Clazz clazz, FileFragmentMap fragmentMap) {
        for (AssocRole role : clazz.getRoles()) {
            if (role.getName() == null) continue;
            STGroup group = this.createSTGroup("templates/typescript/associations.stg");
            String roleType = role.getOther().getClazz().getName();
            if (!roleType.equals(clazz.getName())) {
                String importText = String.format("import %s from \"./%s\";\n\n", roleType, roleType);
                fragmentMap.add("import:" + roleType, importText, 0);
            }
            if (role.getCardinality() != 1) {
                roleType = roleType + "[]";
            }
            ST st = group.getInstanceOf("roleAttrDecl");
            st.add("roleName", (Object)role.getName());
            st.add("roleType", (Object)roleType);
            String result = st.render();
            fragmentMap.add("attribute:_" + role.getName(), result, 2, role.getModified());
            st = group.getInstanceOf("getMethod");
            st.add("roleName", (Object)role.getName());
            st.add("roleType", (Object)roleType);
            result = st.render();
            fragmentMap.add("method:get " + role.getName() + "()", result, 2, role.getModified());
            st = group.getInstanceOf("setMethod");
            st.add("roleName", (Object)role.getName());
            st.add("toMany", (Object)(role.getCardinality() != 1 ? 1 : 0));
            st.add("myClassName", (Object)clazz.getName());
            st.add("otherClassName", (Object)role.getOther().getClazz().getName());
            st.add("otherRoleName", (Object)role.getOther().getName());
            st.add("otherToMany", (Object)(role.getOther().getCardinality() != 1 ? 1 : 0));
            st.add("roleType", (Object)roleType);
            result = st.render();
            String signature = "set " + role.getName() + "(" + role.getOther().getClazz().getName() + ")";
            if (role.getCardinality() != 1) {
                signature = "with" + StrUtil.cap(role.getName()) + "(any[])";
            }
            fragmentMap.add("method:" + signature, result, 3, role.getModified());
            if (role.getCardinality() == 1) continue;
            st = group.getInstanceOf("withoutMethod");
            st.add("roleName", (Object)role.getName());
            st.add("toMany", (Object)(role.getCardinality() != 1 ? 1 : 0));
            st.add("myClassName", (Object)clazz.getName());
            st.add("otherClassName", (Object)role.getOther().getClazz().getName());
            st.add("otherRoleName", (Object)role.getOther().getName());
            st.add("otherToMany", (Object)(role.getOther().getCardinality() != 1 ? 1 : 0));
            st.add("roleType", (Object)roleType);
            result = st.render();
            fragmentMap.add("method:without" + StrUtil.cap(role.getName()) + "(any[])", result, 3, role.getModified());
        }
    }

    private void generateRemoveYou(Clazz clazz, FileFragmentMap fragmentMap) {
        STGroup group = this.createSTGroup("templates/typescript/tsClassDecl.stg");
        StringBuilder buf = new StringBuilder();
        for (AssocRole role : clazz.getRoles()) {
            if (role.getCardinality() == 1) {
                buf.append("this.").append(role.getName()).append(" = null;\n");
                continue;
            }
            buf.append("this.without").append(StrUtil.cap(role.getName())).append("(this._").append(role.getName()).append(");\n");
        }
        ST st = group.getInstanceOf("removeYou");
        st.add("body", (Object)buf.toString());
        String result = st.render();
        fragmentMap.add("method:removeYou()", result, 2);
    }

    public STGroup createSTGroup(String origFileName) {
        STGroupFile group;
        try {
            group = new STGroupFile(this.customTemplatesFile);
            STGroupFile origGroup = new STGroupFile(origFileName);
            group.importTemplates((STGroup)origGroup);
        }
        catch (Exception e) {
            group = new STGroupFile(origFileName);
        }
        group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        return group;
    }
}

