/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.fulib.yaml.Yamler;

public class EventSource {
    public static final String EVENT_KEY = ".eventKey";
    public static final String EVENT_TIMESTAMP = ".eventTimestamp";
    public static final String EVENT_TYPE = "eventType";
    private Yamler yamler = new Yamler();
    private LinkedHashMap<String, Long> keyNumMap = new LinkedHashMap();
    private TreeMap<Long, LinkedHashMap<String, String>> numEventMap = new TreeMap();
    private long lastEventTime;
    private long oldEventTimeStamp = 0L;
    public DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private ArrayList<Consumer<LinkedHashMap<String, String>>> eventListeners = new ArrayList();

    public long getLastEventTime() {
        return this.lastEventTime;
    }

    public SortedMap<Long, LinkedHashMap<String, String>> pull(long since) {
        SortedMap<Long, LinkedHashMap<String, String>> tailMap = this.numEventMap.tailMap(since);
        return tailMap;
    }

    public SortedMap<Long, LinkedHashMap<String, String>> pull(long since, String ... relevantEventTypes) {
        return this.pull(since, (Map.Entry<Long, LinkedHashMap<String, String>> e) -> this.filterRelevantEventTypes((Map.Entry<Long, LinkedHashMap<String, String>>)e, Arrays.asList(relevantEventTypes)));
    }

    private Boolean filterRelevantEventTypes(Map.Entry<Long, LinkedHashMap<String, String>> e, List<String> relevantEventTypes) {
        LinkedHashMap<String, String> map = e.getValue();
        return relevantEventTypes.contains(map.get(EVENT_TYPE));
    }

    public SortedMap<Long, LinkedHashMap<String, String>> pull(long since, Function<Map.Entry<Long, LinkedHashMap<String, String>>, Boolean> filterOp) {
        SortedMap<Long, LinkedHashMap<String, String>> tailMap = this.numEventMap.tailMap(since);
        TreeMap<Long, LinkedHashMap<String, String>> resultMap = new TreeMap<Long, LinkedHashMap<String, String>>();
        for (Map.Entry<Long, LinkedHashMap<String, String>> entry : tailMap.entrySet()) {
            boolean result = filterOp.apply(entry);
            if (!result) continue;
            resultMap.put(entry.getKey(), entry.getValue());
        }
        return resultMap;
    }

    public LinkedHashMap<String, String> getEvent(String eventKey) {
        Long aLong = this.keyNumMap.get(eventKey);
        if (aLong == null) {
            return null;
        }
        LinkedHashMap<String, String> map = this.numEventMap.get(aLong);
        return map;
    }

    public boolean isOverwritten(LinkedHashMap<String, String> map) {
        String eventKey = map.get(EVENT_KEY);
        String eventTimeTxt = map.get(EVENT_TIMESTAMP);
        Long storedTime = this.keyNumMap.get(eventKey);
        if (storedTime == null) {
            return false;
        }
        String storedTimeTxt = this.dateFormat.format(storedTime);
        return storedTimeTxt.compareTo(eventTimeTxt) >= 0;
    }

    public EventSource setOldEventTimeStamp(String oldTimeStampString) {
        if (oldTimeStampString == null) {
            return this;
        }
        long oldTimeStamp = 0L;
        try {
            oldTimeStamp = this.dateFormat.parse(oldTimeStampString).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return this.setOldEventTimeStamp(oldTimeStamp);
    }

    public EventSource setOldEventTimeStamp(long oldEventTimeStamp) {
        this.oldEventTimeStamp = oldEventTimeStamp;
        return this;
    }

    public EventSource append(LinkedHashMap<String, String> event) {
        Long oldNum;
        this.setOldEventTimeStamp(event.get(EVENT_TIMESTAMP));
        this.lastEventTime = this.oldEventTimeStamp > this.lastEventTime ? this.oldEventTimeStamp : System.currentTimeMillis();
        String timestampString = this.dateFormat.format(this.lastEventTime);
        this.oldEventTimeStamp = 0L;
        event.put(EVENT_TIMESTAMP, timestampString);
        String key = event.get(EVENT_KEY);
        if (key != null && (oldNum = this.keyNumMap.get(key)) != null) {
            this.numEventMap.remove(oldNum);
        }
        this.keyNumMap.put(key, this.lastEventTime);
        this.numEventMap.put(this.lastEventTime, event);
        for (Consumer<LinkedHashMap<String, String>> listener : this.eventListeners) {
            listener.accept(event);
        }
        return this;
    }

    public EventSource append(String buf) {
        if (buf == null) {
            return this;
        }
        ArrayList<LinkedHashMap<String, String>> list = this.yamler.decodeList(buf);
        for (LinkedHashMap<String, String> event : list) {
            this.append(event);
        }
        return this;
    }

    public String encodeYaml() {
        return EventSource.encodeYaml(this.numEventMap);
    }

    public static String encodeYaml(SortedMap<Long, LinkedHashMap<String, String>> eventMap) {
        StringBuffer buf = new StringBuffer();
        for (Map.Entry<Long, LinkedHashMap<String, String>> entry : eventMap.entrySet()) {
            LinkedHashMap<String, String> event = entry.getValue();
            String oneObj = EventSource.encodeYaml(event);
            buf.append(oneObj);
        }
        return buf.toString();
    }

    public static String encodeYaml(List<LinkedHashMap<String, String>> events) {
        StringBuffer buf = new StringBuffer();
        for (LinkedHashMap<String, String> event : events) {
            String oneObj = EventSource.encodeYaml(event);
            buf.append(oneObj);
        }
        return buf.toString();
    }

    public static String encodeYaml(LinkedHashMap<String, String> event) {
        StringBuffer buf = new StringBuffer();
        String prefix = "- ";
        for (Map.Entry<String, String> keyValuePair : event.entrySet()) {
            buf.append(prefix).append(keyValuePair.getKey()).append(": ").append(Yamler.encapsulate(keyValuePair.getValue())).append("\n");
            prefix = "  ";
        }
        buf.append("\n");
        return buf.toString();
    }

    public void addEventListener(Consumer<LinkedHashMap<String, String>> listener) {
        this.eventListeners.add(listener);
    }
}

