/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.tool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CodingErrorAction;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.tool.ScenarioCompiler;

public class LibraryHelper {
    public static void loadLibraries(ScenarioCompiler compiler) {
        for (String entry : compiler.getConfig().getClasspath()) {
            LibraryHelper.loadLibrary(entry, compiler);
        }
    }

    private static void loadLibrary(String classpathEntry, ScenarioCompiler compiler) {
        if (classpathEntry.endsWith(".jar")) {
            LibraryHelper.loadJarLibrary(classpathEntry, compiler);
        } else {
            LibraryHelper.loadDirLibrary(classpathEntry, compiler);
        }
    }

    private static void loadDirLibrary(String src, ScenarioCompiler compiler) {
        for (String packageName : compiler.getConfig().getImports()) {
            String packageDir = packageName.replace('.', '/');
            File[] files = new File(src, packageDir).listFiles();
            if (files == null) {
                return;
            }
            ScenarioGroup scenarioGroup = compiler.resolveGroup(packageDir);
            for (File file : files) {
                ScenarioFile scenarioFile;
                String fileName = file.getName();
                if (!file.isFile() || !fileName.endsWith(".md") || (scenarioFile = compiler.parseScenario(file)) == null) continue;
                String name = fileName.substring(0, fileName.length() - 3);
                scenarioFile.setExternal(true);
                scenarioFile.setName(name);
                scenarioFile.setGroup(scenarioGroup);
                scenarioGroup.getFiles().put(name, scenarioFile);
            }
        }
    }

    private static void loadJarLibrary(String src, ScenarioCompiler compiler) {
        try (JarFile jarFile = new JarFile(src);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                LibraryHelper.loadJarEntry(src, compiler, jarFile, entry);
            }
        }
        catch (IOException e) {
            e.printStackTrace(compiler.getErr());
        }
    }

    private static void loadJarEntry(String src, ScenarioCompiler compiler, JarFile jarFile, JarEntry entry) throws IOException {
        String entryName = entry.getName();
        if (!entryName.endsWith(".md")) {
            return;
        }
        int slashIndex = entryName.lastIndexOf(47);
        if (slashIndex < 0) {
            return;
        }
        int beginIndex = entryName.charAt(0) == '/' ? 1 : 0;
        String packageDir = entryName.substring(beginIndex, slashIndex);
        String packageName = packageDir.replace('/', '.');
        if (!compiler.getConfig().getImports().contains(packageName)) {
            return;
        }
        try (InputStream stream = jarFile.getInputStream(entry);){
            ReadableByteChannel channel = Channels.newChannel(stream);
            CodePointCharStream input = CharStreams.fromChannel((ReadableByteChannel)channel, (int)4096, (CodingErrorAction)CodingErrorAction.REPLACE, (String)(src + '!' + entryName));
            ScenarioFile file = compiler.parseScenario((CharStream)input);
            if (file != null) {
                String scenarioName = entryName.substring(slashIndex + 1, entryName.length() - 3);
                file.setExternal(true);
                file.setName(scenarioName);
                ScenarioGroup scenarioGroup = compiler.resolveGroup(packageDir);
                file.setGroup(scenarioGroup);
                scenarioGroup.getFiles().put(scenarioName, file);
            }
        }
    }
}

