/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.fulib.StrUtil;
import org.fulib.scenarios.ast.CompilationContext;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.access.ExampleAccess;
import org.fulib.scenarios.ast.expr.access.ListAttributeAccess;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.call.CreationExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.conditional.AttributeCheckExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperator;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperatorExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.expr.primary.StringLiteral;
import org.fulib.scenarios.ast.sentence.AddSentence;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.ConditionalSentence;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.ExpectSentence;
import org.fulib.scenarios.ast.sentence.ExprSentence;
import org.fulib.scenarios.ast.sentence.FlattenSentenceList;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.RemoveSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.TemplateSentence;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.ast.type.UnresolvedType;
import org.fulib.scenarios.parser.Identifiers;
import org.fulib.scenarios.transform.AddResolve;
import org.fulib.scenarios.transform.ExtractDecl;
import org.fulib.scenarios.transform.Namer;
import org.fulib.scenarios.transform.RemoveResolve;
import org.fulib.scenarios.transform.SymbolCollector;
import org.fulib.scenarios.transform.Typer;
import org.fulib.scenarios.transform.scope.DelegatingScope;
import org.fulib.scenarios.transform.scope.EmptyScope;
import org.fulib.scenarios.transform.scope.HidingScope;
import org.fulib.scenarios.transform.scope.Scope;

public enum NameResolver implements CompilationContext.Visitor<Object, Object>,
ScenarioGroup.Visitor<Scope, Object>,
ScenarioFile.Visitor<Scope, Object>,
Scenario.Visitor<Scope, Object>,
Sentence.Visitor<Scope, Sentence>,
Type.Visitor<Scope, Type>,
Expr.Visitor<Scope, Expr>,
Name.Visitor<Scope, Name>
{
    INSTANCE;

    protected static final String ENCLOSING_CLASS = "<enclosing:class>";

    @Override
    public Object visit(CompilationContext compilationContext, Object par) {
        Map<String, ScenarioGroup> groups = compilationContext.getGroups();
        HashSet<ScenarioGroup> importedGroups = new HashSet<ScenarioGroup>();
        final HashMap<String, ClassDecl> importedClasses = new HashMap<String, ClassDecl>();
        for (String packageName : compilationContext.getConfig().getImports()) {
            String packageDir = packageName.replace('.', '/');
            ScenarioGroup group = groups.get(packageDir);
            if (group == null) continue;
            group.accept(this, EmptyScope.INSTANCE);
            importedGroups.add(group);
            importedClasses.putAll(group.getClasses());
        }
        Scope importedScope = new Scope(){

            @Override
            public Decl resolve(String name) {
                return (Decl)importedClasses.get(name);
            }

            @Override
            public void add(Decl decl) {
            }
        };
        groups.values().parallelStream().filter(o -> !importedGroups.contains(o)).forEach(it -> it.accept(this, importedScope));
        return null;
    }

    @Override
    public Object visit(final ScenarioGroup scenarioGroup, Scope par) {
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                ClassDecl classDecl = scenarioGroup.getClasses().get(name);
                return classDecl != null ? classDecl : super.resolve(name);
            }

            @Override
            public void add(Decl decl) {
                ClassDecl classDecl = (ClassDecl)decl;
                classDecl.setGroup(scenarioGroup);
                scenarioGroup.getClasses().put(decl.getName(), classDecl);
            }
        };
        for (ScenarioFile file : scenarioGroup.getFiles().values()) {
            if (!file.getExternal()) continue;
            file.accept(this, scope);
            file.getClassDecl().setFrozen(true);
        }
        for (ClassDecl classDecl : scenarioGroup.getClasses().values()) {
            classDecl.setFrozen(true);
        }
        for (ScenarioFile file : scenarioGroup.getFiles().values()) {
            if (file.getExternal()) continue;
            file.accept(this, scope);
        }
        return null;
    }

    @Override
    public Object visit(ScenarioFile scenarioFile, Scope par) {
        ScenarioGroup group = scenarioFile.getGroup();
        final String className = Identifiers.toUpperCamelCase(scenarioFile.getName()) + "Test";
        final ClassDecl classDecl = ClassDecl.of(group, className, null, new LinkedHashMap<String, AttributeDecl>(), new LinkedHashMap<String, AssociationDecl>(), new ArrayList<MethodDecl>());
        classDecl.setExternal(scenarioFile.getExternal());
        classDecl.setType(ClassType.of(classDecl));
        scenarioFile.setClassDecl(classDecl);
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                return className.equals(name) || NameResolver.ENCLOSING_CLASS.equals(name) ? classDecl : super.resolve(name);
            }
        };
        for (Scenario scenario : scenarioFile.getScenarios().values()) {
            scenario.accept(this, scope);
        }
        return null;
    }

    @Override
    public Object visit(Scenario scenario, Scope par) {
        ClassDecl classDecl = scenario.getFile().getClassDecl();
        final String methodName = Identifiers.toLowerCamelCase(scenario.getName());
        SentenceList body = scenario.getBody();
        final MethodDecl methodDecl = MethodDecl.of(classDecl, methodName, null, PrimitiveType.VOID, body);
        final ParameterDecl thisParam = ParameterDecl.of(methodDecl, "this", classDecl.getType());
        methodDecl.setParameters(Collections.singletonList(thisParam));
        classDecl.getMethods().add(methodDecl);
        scenario.setMethodDecl(methodDecl);
        body.accept(this, new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                if ("this".equals(name)) {
                    return thisParam;
                }
                if (methodName.equals(name)) {
                    return methodDecl;
                }
                return super.resolve(name);
            }
        });
        return null;
    }

    @Override
    public Sentence visit(SentenceList sentenceList, Scope par) {
        final HashMap decls = new HashMap();
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                Decl decl = (Decl)decls.get(name);
                return decl != null ? decl : super.resolve(name);
            }

            @Override
            public void add(Decl decl) {
                if (decl instanceof VarDecl) {
                    decls.put(decl.getName(), decl);
                    return;
                }
                super.add(decl);
            }
        };
        List<Sentence> oldItems = sentenceList.getItems();
        ArrayList<Sentence> newItems = new ArrayList<Sentence>(oldItems.size());
        for (Sentence item : oldItems) {
            item.accept(SymbolCollector.INSTANCE, decls);
            Sentence resolved = item.accept(this, scope);
            FlattenSentenceList.add(newItems, resolved);
        }
        sentenceList.setItems(newItems);
        return sentenceList;
    }

    @Override
    public Sentence visit(ExpectSentence expectSentence, Scope par) {
        expectSentence.getPredicates().replaceAll(it -> (ConditionalExpr)it.accept(this, par));
        return expectSentence;
    }

    @Override
    public Sentence visit(DiagramSentence diagramSentence, Scope par) {
        diagramSentence.setObject(diagramSentence.getObject().accept(this, par));
        return diagramSentence;
    }

    @Override
    public Sentence visit(HasSentence hasSentence, Scope par) {
        Expr receiver = hasSentence.getObject().accept(this, par);
        hasSentence.setObject(receiver);
        ClassDecl objectClass = NameResolver.resolveClass(par, receiver);
        String name = receiver.accept(Namer.INSTANCE, null);
        Scope scope = name != null ? new HidingScope(name, par) : par;
        for (NamedExpr namedExpr : hasSentence.getClauses()) {
            namedExpr.setExpr(namedExpr.getExpr().accept(this, scope));
            namedExpr.setName(NameResolver.resolveAttributeOrAssociation(objectClass, namedExpr.getName(), namedExpr.getExpr()));
        }
        return hasSentence;
    }

    @Override
    public Sentence visit(IsSentence isSentence, Scope par) {
        VarDecl varDecl = isSentence.getDescriptor();
        varDecl.setExpr(varDecl.getExpr().accept(this, par));
        if (varDecl.getType() == null) {
            varDecl.setType(varDecl.getExpr().accept(Typer.INSTANCE, null));
        }
        return isSentence;
    }

    @Override
    public Sentence visit(AnswerSentence answerSentence, Scope par) {
        if (answerSentence.getActor() != null) {
            answerSentence.setActor(answerSentence.getActor().accept(this, par));
        }
        answerSentence.setResult(answerSentence.getResult().accept(this, par));
        return answerSentence;
    }

    @Override
    public Sentence visit(AddSentence addSentence, Scope par) {
        Expr source = addSentence.getSource().accept(this, par);
        Expr target = addSentence.getTarget();
        return target.accept(AddResolve.INSTANCE, source).accept(this, par);
    }

    @Override
    public Sentence visit(RemoveSentence removeSentence, Scope par) {
        Expr source = removeSentence.getSource().accept(this, par);
        Expr target = removeSentence.getTarget();
        return target.accept(RemoveResolve.INSTANCE, source).accept(this, par);
    }

    @Override
    public Sentence visit(ConditionalSentence conditionalSentence, Scope par) {
        conditionalSentence.setCondition((ConditionalExpr)conditionalSentence.getCondition().accept(this, par));
        conditionalSentence.setActions((SentenceList)conditionalSentence.getActions().accept(this, par));
        return conditionalSentence;
    }

    @Override
    public Sentence visit(ExprSentence exprSentence, Scope par) {
        exprSentence.setExpr(exprSentence.getExpr().accept(this, par));
        return exprSentence;
    }

    @Override
    public Sentence visit(TemplateSentence templateSentence, Scope par) {
        templateSentence.getExprs().replaceAll(it -> it.accept(this, par));
        return templateSentence;
    }

    @Override
    public Type visit(UnresolvedType unresolvedType, Scope par) {
        try {
            return PrimitiveType.valueOf(unresolvedType.getName());
        }
        catch (IllegalArgumentException unknownEnumConstant) {
            return NameResolver.resolveClass(par, unresolvedType.getName()).getType();
        }
    }

    @Override
    public Type visit(PrimitiveType primitiveType, Scope par) {
        return primitiveType;
    }

    @Override
    public Type visit(ClassType classType, Scope par) {
        return classType;
    }

    @Override
    public Type visit(ListType listType, Scope par) {
        listType.setElementType(listType.getElementType().accept(this, par));
        return listType;
    }

    @Override
    public Expr visit(Expr expr, Scope par) {
        return expr;
    }

    @Override
    public Expr visit(AttributeAccess attributeAccess, Scope par) {
        Expr receiver = attributeAccess.getReceiver().accept(this, par);
        attributeAccess.setReceiver(receiver);
        Type receiverType = receiver.accept(Typer.INSTANCE, null);
        if (receiverType instanceof ListType) {
            String attributeName = attributeAccess.getName().accept(Namer.INSTANCE, null);
            Type elementType = ((ListType)receiverType).getElementType();
            Name resolvedName = NameResolver.getAttributeOrAssociation(NameResolver.resolveClass(par, elementType), attributeName);
            return ListAttributeAccess.of(resolvedName, receiver);
        }
        attributeAccess.setName(NameResolver.getAttributeOrAssociation(par, receiver, attributeAccess.getName()));
        return attributeAccess;
    }

    @Override
    public Expr visit(ExampleAccess exampleAccess, Scope par) {
        exampleAccess.setExpr(exampleAccess.getExpr().accept(this, par));
        return exampleAccess;
    }

    @Override
    public Expr visit(NameAccess nameAccess, Scope par) {
        if (nameAccess.getName() instanceof UnresolvedName) {
            UnresolvedName unresolvedName = (UnresolvedName)nameAccess.getName();
            String unresolvedValue = unresolvedName.getValue();
            Decl target = par.resolve(unresolvedValue);
            if (target == null) {
                return StringLiteral.of(unresolvedName.getText());
            }
            nameAccess.setName(ResolvedName.of(target));
        }
        return nameAccess;
    }

    @Override
    public Expr visit(CreationExpr creationExpr, Scope par) {
        creationExpr.setType(creationExpr.getType().accept(this, par));
        ClassDecl classDecl = NameResolver.resolveClass(par, creationExpr.getType());
        for (NamedExpr namedExpr : creationExpr.getAttributes()) {
            namedExpr.setExpr(namedExpr.getExpr().accept(this, par));
            namedExpr.setName(NameResolver.resolveAttributeOrAssociation(classDecl, namedExpr.getName(), namedExpr.getExpr()));
        }
        return creationExpr;
    }

    @Override
    public Expr visit(CallExpr callExpr, Scope par) {
        List<NamedExpr> arguments = callExpr.getArguments();
        Expr receiver = callExpr.getReceiver();
        if (receiver != null) {
            receiver = receiver.accept(this, par);
        } else {
            Decl thisDecl = par.resolve("this");
            receiver = NameAccess.of(ResolvedName.of(thisDecl));
        }
        callExpr.setReceiver(receiver);
        for (NamedExpr argument : arguments) {
            argument.setExpr(argument.getExpr().accept(this, par));
        }
        ClassDecl receiverClass = NameResolver.resolveClass(par, callExpr.getReceiver());
        String methodName = callExpr.getName().accept(Namer.INSTANCE, null);
        MethodDecl method = NameResolver.resolveMethod(receiverClass, methodName);
        List<ParameterDecl> parameters = method.getParameters();
        boolean isNew = method.getParameters().isEmpty();
        final HashMap<String, ParameterDecl> decls = new HashMap<String, ParameterDecl>();
        if (isNew) {
            ParameterDecl thisParam = ParameterDecl.of(method, "this", receiverClass.getType());
            parameters.add(thisParam);
            decls.put("this", thisParam);
        } else {
            decls.put("this", parameters.get(0));
            String params = parameters.stream().skip(1L).map(ParameterDecl::getName).collect(Collectors.joining(" "));
            String args = arguments.stream().map(NamedExpr::getName).map(n -> n.accept(Namer.INSTANCE, null)).collect(Collectors.joining(" "));
            if (!params.equals(args)) {
                throw new IllegalStateException("mismatching parameters and arguments:\nparameters: " + params + "\narguments : " + args);
            }
        }
        String receiverName = receiver.accept(Namer.INSTANCE, null);
        if (receiverName != null) {
            decls.put(receiverName, parameters.get(0));
        }
        for (int i = 0; i < arguments.size(); ++i) {
            ParameterDecl param;
            NamedExpr argument = arguments.get(i);
            String name = argument.getName().accept(Namer.INSTANCE, null);
            Expr expr = argument.getExpr();
            if (isNew) {
                Type type = expr.accept(Typer.INSTANCE, null);
                param = ParameterDecl.of(method, name, type);
                parameters.add(param);
            } else {
                param = parameters.get(i + 1);
            }
            argument.setName(ResolvedName.of(param));
            decls.put(name, param);
            String exprName = expr.accept(Namer.INSTANCE, null);
            if (exprName == null) continue;
            decls.put(exprName, param);
        }
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                Decl decl = (Decl)decls.get(name);
                return decl != null ? decl : super.resolve(name);
            }
        };
        callExpr.getBody().accept(this, scope);
        if (method.getType() == null) {
            Type returnType = callExpr.accept(Typer.INSTANCE, null);
            method.setType(returnType);
        }
        method.getBody().getItems().addAll(callExpr.getBody().getItems());
        return callExpr;
    }

    @Override
    public Expr visit(AttributeCheckExpr attributeCheckExpr, Scope par) {
        Expr receiver = attributeCheckExpr.getReceiver();
        Expr expected = attributeCheckExpr.getValue();
        Name attribute = attributeCheckExpr.getAttribute();
        AttributeAccess access = AttributeAccess.of(attribute, receiver);
        ConditionalOperatorExpr condOp = ConditionalOperatorExpr.of(access, ConditionalOperator.IS, expected);
        return condOp.accept(this, par);
    }

    @Override
    public Expr visit(ConditionalOperatorExpr conditionalOperatorExpr, Scope par) {
        conditionalOperatorExpr.setLhs(conditionalOperatorExpr.getLhs().accept(this, par));
        conditionalOperatorExpr.setRhs(conditionalOperatorExpr.getRhs().accept(this, par));
        return conditionalOperatorExpr;
    }

    @Override
    public Expr visit(ListExpr listExpr, Scope par) {
        listExpr.getElements().replaceAll(it -> it.accept(this, par));
        return listExpr;
    }

    @Override
    public Name visit(Name name, Scope par) {
        return name;
    }

    @Override
    public Name visit(ResolvedName resolvedName, Scope par) {
        return resolvedName;
    }

    @Override
    public Name visit(UnresolvedName unresolvedName, Scope par) {
        Decl decl = par.resolve(unresolvedName.getValue());
        return decl == null ? unresolvedName : ResolvedName.of(decl);
    }

    static ClassDecl getEnclosingClass(Scope scope) {
        return (ClassDecl)scope.resolve(ENCLOSING_CLASS);
    }

    static ClassDecl resolveClass(Scope scope, Expr expr) {
        Type type = expr.accept(Typer.INSTANCE, null);
        return NameResolver.resolveClass(scope, type);
    }

    static ClassDecl resolveClass(Scope scope, Type type) {
        if (type instanceof ListType) {
            return NameResolver.resolveClass(scope, ((ListType)type).getElementType());
        }
        String typeName = type.accept(Namer.INSTANCE, null);
        return NameResolver.resolveClass(scope, typeName);
    }

    static ClassDecl resolveClass(Scope scope, String name) {
        Decl resolved = scope.resolve(name);
        if (resolved instanceof ClassDecl) {
            return (ClassDecl)resolved;
        }
        if (resolved != null) {
            throw new IllegalStateException("class name " + name + " resolved to " + resolved);
        }
        ClassDecl decl = ClassDecl.of(null, name, null, new LinkedHashMap<String, AttributeDecl>(), new LinkedHashMap<String, AssociationDecl>(), new ArrayList<MethodDecl>());
        decl.setExternal(NameResolver.getEnclosingClass(scope).getExternal());
        decl.setType(ClassType.of(decl));
        scope.add(decl);
        return decl;
    }

    static MethodDecl resolveMethod(ClassDecl classDecl, String name) {
        MethodDecl decl2;
        for (MethodDecl decl2 : classDecl.getMethods()) {
            if (!name.equals(decl2.getName())) continue;
            return decl2;
        }
        if (classDecl.getFrozen()) {
            throw new IllegalStateException("unresolved external method " + classDecl.getName() + "." + name);
        }
        SentenceList body = SentenceList.of(new ArrayList<Sentence>());
        decl2 = MethodDecl.of(classDecl, name, new ArrayList<ParameterDecl>(), null, body);
        classDecl.getMethods().add(decl2);
        return decl2;
    }

    static Name resolveAttributeOrAssociation(ClassDecl classDecl, Name name, Expr rhs) {
        if (name.accept(ExtractDecl.INSTANCE, null) != null) {
            return name;
        }
        return ResolvedName.of(NameResolver.resolveAttributeOrAssociation(classDecl, name.accept(Namer.INSTANCE, null), rhs));
    }

    static Decl resolveAttributeOrAssociation(ClassDecl classDecl, String attributeName, Expr rhs) {
        AttributeDecl existingAttribute = classDecl.getAttributes().get(attributeName);
        if (existingAttribute != null) {
            return existingAttribute;
        }
        AssociationDecl existingAssociation = classDecl.getAssociations().get(attributeName);
        if (existingAssociation != null) {
            return existingAssociation;
        }
        Type attributeType = rhs.accept(Typer.INSTANCE, null);
        if (attributeType instanceof ListType) {
            Type otherType = ((ListType)attributeType).getElementType();
            if (otherType instanceof ClassType) {
                return NameResolver.resolveAssociation(classDecl, attributeName, ((ClassType)otherType).getClassDecl(), 2);
            }
            return NameResolver.resolveAttribute(classDecl, attributeName, attributeType);
        }
        if (attributeType instanceof ClassType) {
            return NameResolver.resolveAssociation(classDecl, attributeName, ((ClassType)attributeType).getClassDecl(), 1);
        }
        return NameResolver.resolveAttribute(classDecl, attributeName, attributeType);
    }

    static AttributeDecl resolveAttribute(ClassDecl classDecl, String name, Type type) {
        AttributeDecl existing = classDecl.getAttributes().get(name);
        if (existing != null) {
            Type existingType = existing.getType();
            if (!type.equals(existingType)) {
                throw new IllegalStateException("mismatched attribute type " + classDecl.getName() + "." + name + ": " + existingType + " vs " + type);
            }
            return existing;
        }
        if (classDecl.getFrozen()) {
            throw new IllegalStateException("unresolved external attribute " + classDecl.getName() + "." + name);
        }
        AttributeDecl attribute = AttributeDecl.of(classDecl, name, type);
        classDecl.getAttributes().put(name, attribute);
        return attribute;
    }

    static AssociationDecl resolveAssociation(ClassDecl classDecl, String name, ClassDecl otherClass, int cardinality) {
        AssociationDecl existing = classDecl.getAssociations().get(name);
        if (existing != null) {
            if (existing.getTarget() != otherClass || existing.getCardinality() != cardinality) {
                throw new IllegalStateException("mismatched association type " + classDecl.getName() + "." + name + ": " + NameResolver.cardinalityString(existing.getCardinality()) + " " + existing.getTarget().getName() + " vs " + NameResolver.cardinalityString(cardinality) + " " + otherClass.getName());
            }
            return existing;
        }
        if (classDecl.getFrozen()) {
            throw new IllegalStateException("unresolved external association " + classDecl.getName() + "." + name);
        }
        Type associationType = cardinality != 1 ? ListType.of(otherClass.getType()) : otherClass.getType();
        AssociationDecl association = AssociationDecl.of(classDecl, name, cardinality, otherClass, associationType, null);
        classDecl.getAssociations().put(association.getName(), association);
        if (!otherClass.getFrozen()) {
            String otherName = StrUtil.downFirstChar(classDecl.getName());
            AssociationDecl other = AssociationDecl.of(otherClass, otherName, 1, classDecl, classDecl.getType(), null);
            otherClass.getAssociations().put(other.getName(), other);
            association.setOther(other);
            other.setOther(association);
        }
        return association;
    }

    private static String cardinalityString(int cardinality) {
        return cardinality == 1 ? "one" : "many";
    }

    static Name getAttributeOrAssociation(Scope scope, Expr receiver, Name name) {
        if (name.accept(ExtractDecl.INSTANCE, null) != null) {
            return name;
        }
        return NameResolver.getAttributeOrAssociation(NameResolver.resolveClass(scope, receiver), name.accept(Namer.INSTANCE, null));
    }

    static Name getAttributeOrAssociation(ClassDecl receiverClass, String name) {
        AttributeDecl attribute = receiverClass.getAttributes().get(name);
        if (attribute != null) {
            return ResolvedName.of(attribute);
        }
        AssociationDecl association = receiverClass.getAssociations().get(name);
        if (association != null) {
            return ResolvedName.of(association);
        }
        throw new IllegalStateException("unresolved attribute or association " + receiverClass.getName() + "." + name);
    }
}

