/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.transform;

import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.access.ExampleAccess;
import org.fulib.scenarios.ast.expr.access.ListAttributeAccess;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.call.CreationExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.conditional.AttributeCheckExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperatorExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.expr.primary.NumberLiteral;
import org.fulib.scenarios.ast.expr.primary.StringLiteral;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.transform.ExtractDecl;
import org.fulib.scenarios.transform.ReturnExpr;

public final class Typer
extends Enum<Typer>
implements Expr.Visitor<Object, Type>,
Name.Visitor<Object, Type> {
    public static final /* enum */ Typer INSTANCE = new Typer();
    private static final /* synthetic */ Typer[] $VALUES;

    public static Typer[] values() {
        return (Typer[])$VALUES.clone();
    }

    public static Typer valueOf(String name) {
        return Enum.valueOf(Typer.class, name);
    }

    @Override
    public Type visit(AttributeAccess attributeAccess, Object par) {
        return attributeAccess.getName().accept(this, par);
    }

    @Override
    public Type visit(ExampleAccess exampleAccess, Object par) {
        return exampleAccess.getExpr().accept(this, par);
    }

    @Override
    public Type visit(CreationExpr creationExpr, Object par) {
        return creationExpr.getType();
    }

    @Override
    public Type visit(CallExpr callExpr, Object par) {
        Expr expr = callExpr.getBody().accept(ReturnExpr.INSTANCE, par);
        return expr != null ? expr.accept(INSTANCE, par) : PrimitiveType.VOID;
    }

    @Override
    public Type visit(NameAccess nameAccess, Object par) {
        return nameAccess.getName().accept(this, par);
    }

    @Override
    public Type visit(NumberLiteral numberLiteral, Object par) {
        return PrimitiveType.DOUBLE;
    }

    @Override
    public Type visit(StringLiteral stringLiteral, Object par) {
        return PrimitiveType.STRING;
    }

    @Override
    public Type visit(ConditionalExpr conditionalExpr, Object par) {
        return PrimitiveType.BOOLEAN;
    }

    @Override
    public Type visit(AttributeCheckExpr attributeCheckExpr, Object par) {
        return PrimitiveType.BOOLEAN;
    }

    @Override
    public Type visit(ListAttributeAccess listAttributeAccess, Object par) {
        Type attributeType = listAttributeAccess.getName().accept(ExtractDecl.INSTANCE, null).getType();
        return ListType.of(attributeType);
    }

    @Override
    public Type visit(ConditionalOperatorExpr conditionalOperatorExpr, Object par) {
        return PrimitiveType.BOOLEAN;
    }

    @Override
    public Type visit(ListExpr listExpr, Object par) {
        Type commonType = null;
        for (Expr element : listExpr.getElements()) {
            Type elementType = element.accept(this, par);
            if (commonType == null) {
                commonType = elementType;
                continue;
            }
            if (commonType.equals(elementType)) continue;
            return ListType.of(PrimitiveType.OBJECT);
        }
        assert (commonType != null) : "empty list expression";
        Type wrapperType = Typer.primitiveToWrapper(commonType);
        return ListType.of(wrapperType);
    }

    @Override
    public Type visit(UnresolvedName unresolvedName, Object par) {
        throw new IllegalStateException("unresolved name " + unresolvedName.getValue());
    }

    @Override
    public Type visit(ResolvedName resolvedName, Object par) {
        return resolvedName.getDecl().getType();
    }

    public static Type primitiveToWrapper(Type primitive) {
        if (!(primitive instanceof PrimitiveType)) {
            return primitive;
        }
        switch ((PrimitiveType)primitive) {
            case VOID: {
                return PrimitiveType.VOID_WRAPPER;
            }
            case BOOLEAN: {
                return PrimitiveType.BOOLEAN_WRAPPER;
            }
            case BYTE: {
                return PrimitiveType.BYTE_WRAPPER;
            }
            case SHORT: {
                return PrimitiveType.SHORT_WRAPPER;
            }
            case CHAR: {
                return PrimitiveType.CHAR_WRAPPER;
            }
            case INT: {
                return PrimitiveType.INT_WRAPPER;
            }
            case LONG: {
                return PrimitiveType.LONG_WRAPPER;
            }
            case FLOAT: {
                return PrimitiveType.FLOAT_WRAPPER;
            }
            case DOUBLE: {
                return PrimitiveType.DOUBLE_WRAPPER;
            }
        }
        return primitive;
    }

    public static boolean isNumeric(Type type) {
        if (!(type instanceof PrimitiveType)) {
            return false;
        }
        switch ((PrimitiveType)type) {
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE_WRAPPER: 
            case SHORT_WRAPPER: 
            case CHAR_WRAPPER: 
            case INT_WRAPPER: 
            case LONG_WRAPPER: 
            case FLOAT_WRAPPER: 
            case DOUBLE_WRAPPER: {
                return true;
            }
        }
        return false;
    }

    static {
        $VALUES = new Typer[]{INSTANCE};
    }
}

