/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.builder;

import java.util.LinkedHashMap;
import java.util.function.Consumer;
import org.fulib.StrUtil;
import org.fulib.builder.ClassBuilder;
import org.fulib.builder.ClassModelBuilder;
import org.fulib.builder.IModelManager;
import org.fulib.builder.ModelEventManager;
import org.fulib.classmodel.AssocRole;
import org.fulib.classmodel.Attribute;
import org.fulib.classmodel.ClassModel;
import org.fulib.classmodel.Clazz;
import org.fulib.classmodel.FMethod;
import org.fulib.yaml.Yamler;

public class ClassModelManager
implements IModelManager {
    public static final String THE_CLASS_MODEL = "theClassModel";
    public static final String HAVE_PACKAGE_NAME = "havePackageName";
    public static final String HAVE_MAIN_JAVA_DIR = "haveMainJavaDir";
    public static final String HAVE_CLASS = "haveClass";
    public static final String HAVE_ATTRIBUTE = "haveAttribute";
    public static final String CLASS_NAME = "className";
    public static final String ATTR_NAME = "attrName";
    public static final String ATTR_TYPE = "attrType";
    public static final String HAVE_ROLE = "haveRole";
    public static final String SRC_CLASS_NAME = "srcClassName";
    public static final String TGT_CLASS_NAME = "tgtClassName";
    public static final String TGT_CARDINALITY = "tgtCardinality";
    public static final String SRC_ROLE = "srcRole";
    public static final String SRC_SIZE = "srcSize";
    public static final String TGT_ROLE = "tgtRole";
    public static final String TGT_SIZE = "tgtSize";
    public static final String HAVE_METHOD = "haveMethod";
    public static final String METHOD_NAME = "methodName";
    public static final String PARAMS = "params";
    public static final String METHOD_BODY = "methodBody";
    public static final String DECLARATION = "declaration";
    private ClassModel classModel;
    private ModelEventManager mem;

    @Override
    public void initConsumers(LinkedHashMap<String, Consumer<LinkedHashMap<String, String>>> consumerMap) {
        if (consumerMap == null) {
            consumerMap = new LinkedHashMap();
            consumerMap.put(HAVE_PACKAGE_NAME, map -> {
                String packageName = (String)map.get("packageName");
                this.havePackageName(packageName);
            });
            consumerMap.put(HAVE_MAIN_JAVA_DIR, map -> {
                String sourceFolder = (String)map.get("mainJavaDir");
                this.haveMainJavaDir(sourceFolder);
            });
            consumerMap.put(HAVE_CLASS, map -> {
                String name = (String)map.get("name");
                this.haveClass(name);
            });
            consumerMap.put(HAVE_ATTRIBUTE, map -> {
                String className = (String)map.get(CLASS_NAME);
                String attrName = (String)map.get(ATTR_NAME);
                String attrType = (String)map.get(ATTR_TYPE);
                Clazz clazz = this.haveClass(className);
                this.haveAttribute(clazz, attrName, attrType);
            });
            consumerMap.put(HAVE_ROLE, map -> {
                String srcClassName = (String)map.get(SRC_CLASS_NAME);
                String attrName = (String)map.get(ATTR_NAME);
                String tgtClassName = (String)map.get(TGT_CLASS_NAME);
                String sizeName = (String)map.get(TGT_CARDINALITY);
                Clazz srcClazz = this.haveClass(srcClassName);
                Clazz tgClazz = this.haveClass(tgtClassName);
                int size = Integer.valueOf(sizeName);
                this.haveRole(srcClazz, attrName, tgClazz, size);
            });
        }
    }

    public ClassModelManager() {
        this.mem = new ModelEventManager();
        this.mem.setModelManager(this);
        this.classModel = new ClassModel().setDefaultPropertyStyle("POJO").setDefaultRoleType("java.util.ArrayList<%s>");
    }

    public ClassModelManager(ModelEventManager classModelEventManager) {
        this.mem = classModelEventManager;
        this.classModel = new ClassModel().setDefaultPropertyStyle("POJO").setDefaultRoleType("java.util.ArrayList<%s>");
    }

    public ClassModel getClassModel() {
        return this.classModel;
    }

    public ClassModelManager havePackageName(String packagename) {
        String oldPackageName = this.classModel.getPackageName();
        if (StrUtil.stringEquals(oldPackageName, packagename)) {
            return this;
        }
        this.classModel.setPackageName(packagename);
        LinkedHashMap<String, String> event = new LinkedHashMap<String, String>();
        event.put("eventType", HAVE_PACKAGE_NAME);
        event.put(".eventKey", Yamler.encapsulate("theClassModel_packageName"));
        event.put("packageName", Yamler.encapsulate(packagename));
        this.mem.append(event);
        return this;
    }

    public ClassModelManager haveMainJavaDir(String sourceFolder) {
        String mainJavaDir = this.classModel.getMainJavaDir();
        if (StrUtil.stringEquals(mainJavaDir, sourceFolder)) {
            return this;
        }
        this.classModel.setMainJavaDir(sourceFolder);
        LinkedHashMap<String, String> event = new LinkedHashMap<String, String>();
        event.put("eventType", HAVE_MAIN_JAVA_DIR);
        event.put(".eventKey", Yamler.encapsulate("theClassModel_mainJavaDir"));
        event.put("mainJavaDir", Yamler.encapsulate(sourceFolder));
        this.mem.append(event);
        return this;
    }

    public Clazz haveClass(String className) {
        Clazz clazz = this.classModel.getClazz(className);
        if (clazz != null) {
            return clazz;
        }
        clazz = new ClassBuilder(this.classModel, className).getClazz();
        LinkedHashMap<String, String> event = new LinkedHashMap<String, String>();
        event.put("eventType", HAVE_CLASS);
        event.put(".eventKey", Yamler.encapsulate(className));
        event.put("name", Yamler.encapsulate(className));
        this.mem.append(event);
        return clazz;
    }

    public Attribute haveAttribute(Clazz clazz, String attrName, String attrType) {
        Attribute attr = clazz.getAttribute(attrName);
        if (attr != null && attr.getType().equals(attrType)) {
            return attr;
        }
        if (attr == null) {
            ClassModelBuilder.checkValidJavaId(attrName);
            if (clazz.getAttribute(attrName) != null || clazz.getRole(attrName) != null) {
                throw new IllegalArgumentException("duplicate attribute / role name: " + attrName);
            }
            attr = new Attribute();
            attr.setName(attrName);
            attr.setClazz(clazz);
            attr.setPropertyStyle(clazz.getPropertyStyle());
        }
        attr.setType(attrType);
        LinkedHashMap<String, String> event = new LinkedHashMap<String, String>();
        event.put("eventType", HAVE_ATTRIBUTE);
        event.put(".eventKey", Yamler.encapsulate(clazz.getName() + "." + attrName));
        event.put(CLASS_NAME, Yamler.encapsulate(clazz.getName()));
        event.put(ATTR_NAME, Yamler.encapsulate(attrName));
        event.put(ATTR_TYPE, Yamler.encapsulate(attrType));
        this.mem.append(event);
        return attr;
    }

    public AssocRole haveRole(Clazz srcClass, String attrName, Clazz tgtClass, int size) {
        String otherRoleName = StrUtil.downFirstChar(srcClass.getName());
        return this.haveRole(srcClass, attrName, tgtClass, size, otherRoleName, 1, false);
    }

    public AssocRole haveRole(Clazz srcClass, String srcRole, Clazz tgtClass, int srcSize, String tgtRole, int tgtSize) {
        return this.haveRole(srcClass, srcRole, tgtClass, srcSize, tgtRole, tgtSize, true);
    }

    private AssocRole haveRole(Clazz srcClass, String srcRole, Clazz tgtClass, int srcSize, String tgtRole, int tgtSize, boolean bothRoles) {
        AssocRole role = srcClass.getRole(srcRole);
        if (!(role == null || role.getCardinality() < srcSize || role.getOther().getClazz() != tgtClass || bothRoles && !role.getOther().getName().equals(tgtRole) || bothRoles && role.getOther().getCardinality() < tgtSize)) {
            return role;
        }
        if (StrUtil.stringEquals(srcRole, tgtRole)) {
            tgtSize = srcSize;
        }
        if (role == null) {
            role = new AssocRole().setClazz(srcClass).setName(srcRole).setCardinality(srcSize).setPropertyStyle(srcClass.getPropertyStyle()).setRoleType(srcClass.getModel().getDefaultRoleType());
            AssocRole otherRole = new AssocRole().setClazz(tgtClass).setName(tgtRole).setCardinality(tgtSize).setPropertyStyle(tgtClass.getPropertyStyle()).setRoleType(tgtClass.getModel().getDefaultRoleType());
            role.setOther(otherRole);
        }
        int maxSize = Math.max(role.getCardinality(), srcSize);
        role.setCardinality(maxSize);
        int maxTgtSize = Math.max(role.getOther().getCardinality(), tgtSize);
        if (bothRoles) {
            role.getOther().setName(tgtRole);
        }
        role.getOther().setCardinality(tgtSize);
        LinkedHashMap<String, String> event = new LinkedHashMap<String, String>();
        event.put("eventType", HAVE_ROLE);
        event.put(".eventKey", Yamler.encapsulate(srcClass.getName() + "." + srcRole));
        event.put(SRC_CLASS_NAME, Yamler.encapsulate(srcClass.getName()));
        event.put(SRC_ROLE, Yamler.encapsulate(srcRole));
        event.put(TGT_CLASS_NAME, Yamler.encapsulate(tgtClass.getName()));
        event.put(SRC_SIZE, "" + maxSize);
        event.put(TGT_ROLE, Yamler.encapsulate(tgtRole));
        event.put(TGT_SIZE, "" + maxTgtSize);
        this.mem.append(event);
        return role;
    }

    public FMethod haveMethod(Clazz srcClass, String declaration) {
        return this.haveMethod(srcClass, declaration, null);
    }

    public FMethod haveMethod(Clazz clazz, String declaration, String body) {
        FMethod method = null;
        for (FMethod fMethod : clazz.getMethods()) {
            if (!fMethod.getDeclaration().equals(declaration)) continue;
            method = fMethod;
            break;
        }
        if (method != null && (body == null || body.equals(method.getMethodBody()))) {
            return method;
        }
        if (method == null) {
            method = new FMethod();
        }
        method.setClazz(clazz).setDeclaration(declaration).setMethodBody(body);
        String key = clazz.getName() + "." + method.getDeclaration();
        LinkedHashMap<String, String> event = new LinkedHashMap<String, String>();
        event.put("eventType", HAVE_METHOD);
        event.put(".eventKey", Yamler.encapsulate(key));
        event.put(CLASS_NAME, Yamler.encapsulate(clazz.getName()));
        event.put(DECLARATION, Yamler.encapsulate(method.getDeclaration()));
        event.put(METHOD_BODY, Yamler.encapsulate(method.getMethodBody()));
        this.mem.append(event);
        return method;
    }

    public FMethod getMethod(String declaration) {
        for (Clazz clazz : this.getClassModel().getClasses()) {
            for (FMethod fMethod : clazz.getMethods()) {
                if (!fMethod.getDeclaration().equals(declaration)) continue;
                return fMethod;
            }
        }
        return null;
    }
}

