/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.codegen;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fulib.FulibTools;
import org.fulib.Generator;
import org.fulib.builder.ClassModelManager;
import org.fulib.classmodel.Clazz;
import org.fulib.classmodel.FMethod;
import org.fulib.scenarios.ast.CompilationContext;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.visitor.Namer;
import org.fulib.scenarios.visitor.codegen.CodeGenDTO;
import org.fulib.scenarios.visitor.codegen.DeclGenerator;
import org.fulib.scenarios.visitor.resolve.SymbolCollector;

public enum CodeGenerator implements CompilationContext.Visitor<Object, Object>,
ScenarioGroup.Visitor<CodeGenDTO, Object>,
ScenarioFile.Visitor<CodeGenDTO, Object>
{
    INSTANCE;


    @Override
    public Object visit(CompilationContext compilationContext, Object par) {
        compilationContext.getGroups().values().parallelStream().forEach(it -> {
            CodeGenDTO dto = new CodeGenDTO();
            dto.config = compilationContext.getConfig();
            it.accept(this, dto);
        });
        return null;
    }

    @Override
    public Object visit(ScenarioGroup scenarioGroup, CodeGenDTO par) {
        boolean testClassesToGenerate;
        par.group = scenarioGroup;
        String modelDir = par.config.getModelDir();
        String testDir = par.config.getTestDir();
        String packageDir = scenarioGroup.getPackageDir();
        String packageName = packageDir.replace('/', '.');
        boolean modelClassesToGenerate = !scenarioGroup.getClasses().values().stream().allMatch(ClassDecl::getExternal);
        boolean bl = testClassesToGenerate = !scenarioGroup.getFiles().values().stream().allMatch(ScenarioFile::getExternal);
        if (!modelClassesToGenerate && !testClassesToGenerate) {
            return null;
        }
        if (CodeGenerator.sameFile(modelDir, testDir)) {
            par.modelManager = new ClassModelManager().havePackageName(packageName).haveMainJavaDir(modelDir);
            if (modelClassesToGenerate) {
                this.generateModel(scenarioGroup, par, modelDir, packageDir);
            }
            if (testClassesToGenerate) {
                this.generateTests(scenarioGroup, par);
            }
            new Generator().generate(par.modelManager.getClassModel());
            return null;
        }
        if (modelClassesToGenerate) {
            par.modelManager = new ClassModelManager().havePackageName(packageName).haveMainJavaDir(modelDir);
            this.generateModel(scenarioGroup, par, modelDir, packageDir);
            new Generator().generate(par.modelManager.getClassModel());
        }
        if (testClassesToGenerate) {
            par.modelManager = new ClassModelManager().havePackageName(packageName).haveMainJavaDir(testDir);
            this.generateTests(scenarioGroup, par);
            new Generator().generate(par.modelManager.getClassModel());
        }
        return null;
    }

    private void generateTests(ScenarioGroup scenarioGroup, CodeGenDTO par) {
        for (ScenarioFile file : scenarioGroup.getFiles().values()) {
            file.accept(this, par);
        }
    }

    private void generateModel(ScenarioGroup scenarioGroup, CodeGenDTO par, String modelDir, String packageDir) {
        for (ClassDecl classDecl : scenarioGroup.getClasses().values()) {
            classDecl.accept(DeclGenerator.INSTANCE, par);
        }
        if (par.config.isClassDiagram()) {
            FulibTools.classDiagrams().dumpPng(par.modelManager.getClassModel(), modelDir + "/" + packageDir + "/classDiagram.png");
        }
        if (par.config.isClassDiagramSVG()) {
            FulibTools.classDiagrams().dumpSVG(par.modelManager.getClassModel(), modelDir + "/" + packageDir + "/classDiagram.svg");
        }
    }

    private static boolean sameFile(String modelDir, String testDir) {
        try {
            return Files.isSameFile(Paths.get(modelDir, new String[0]), Paths.get(testDir, new String[0]));
        }
        catch (IOException e) {
            File modelFile = new File(modelDir);
            File testFile = new File(testDir);
            try {
                return modelFile.getCanonicalPath().equals(testFile.getCanonicalPath());
            }
            catch (IOException e2) {
                return modelFile.getAbsolutePath().equals(testFile.getAbsolutePath());
            }
        }
    }

    @Override
    public Object visit(ScenarioFile scenarioFile, CodeGenDTO par) {
        if (scenarioFile.getExternal()) {
            return null;
        }
        par.clazz = par.modelManager.haveClass(scenarioFile.getClassDecl().getName());
        for (Scenario scenario : scenarioFile.getScenarios().values()) {
            this.addDiagramSentences(scenario, par);
        }
        scenarioFile.getClassDecl().accept(DeclGenerator.INSTANCE, par);
        par.addImport("org.junit.Test");
        for (Scenario scenario : scenarioFile.getScenarios().values()) {
            String methodName = scenario.getMethodDecl().getName();
            CodeGenerator.getFMethod(par.clazz, methodName).setAnnotations("@Test");
        }
        return null;
    }

    private void addDiagramSentences(Scenario scenario, CodeGenDTO par) {
        DiagramSentence diagramSentence;
        if (!par.config.isObjectDiagram() && !par.config.isObjectDiagramSVG()) {
            return;
        }
        String methodName = scenario.getMethodDecl().getName();
        List<Sentence> sentences = scenario.getBody().getItems();
        if (sentences.isEmpty()) {
            return;
        }
        TreeMap symbolTable = new TreeMap();
        for (Sentence item : sentences) {
            item.accept(SymbolCollector.INSTANCE, symbolTable);
        }
        if (symbolTable.isEmpty()) {
            return;
        }
        Map<String, ClassDecl> classes = scenario.getFile().getGroup().getClasses();
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        for (Decl it : symbolTable.values()) {
            Type type = it.getType();
            String typeName = type.accept(Namer.INSTANCE, null);
            if (classes.get(typeName) == null) continue;
            exprs.add(NameAccess.of(ResolvedName.of(it)));
        }
        if (exprs.isEmpty()) {
            return;
        }
        ListExpr listExpr = ListExpr.of(exprs);
        if (par.config.isObjectDiagram()) {
            diagramSentence = DiagramSentence.of(listExpr, methodName + ".png");
            sentences.add(diagramSentence);
        }
        if (par.config.isObjectDiagramSVG()) {
            diagramSentence = DiagramSentence.of(listExpr, methodName + ".svg");
            sentences.add(diagramSentence);
        }
    }

    private static FMethod getFMethod(Clazz clazz, String name) {
        for (FMethod fMethod : clazz.getMethods()) {
            if (!name.equals(fMethod.readName())) continue;
            return fMethod;
        }
        throw new RuntimeException("method " + clazz.getName() + "." + name + " not found");
    }
}

