/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.fulib.scenarios.ast.CompilationContext;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.scope.DelegatingScope;
import org.fulib.scenarios.ast.scope.EmptyScope;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.parser.Identifiers;
import org.fulib.scenarios.visitor.ExtractDecl;
import org.fulib.scenarios.visitor.Namer;
import org.fulib.scenarios.visitor.Typer;
import org.fulib.scenarios.visitor.resolve.SentenceResolver;
import org.fulib.scenarios.visitor.resolve.TypeResolver;

public enum NameResolver implements CompilationContext.Visitor<Object, Object>,
ScenarioGroup.Visitor<Scope, Object>,
ScenarioFile.Visitor<Scope, Object>,
Scenario.Visitor<Scope, Object>,
Name.Visitor<Scope, Name>
{
    INSTANCE;

    protected static final String ENCLOSING_CLASS = "<enclosing:class>";
    protected static final String PREDICATE_RECEIVER = "<predicate-receiver>";

    @Override
    public Object visit(CompilationContext compilationContext, Object par) {
        Map<String, ScenarioGroup> groups = compilationContext.getGroups();
        HashSet<ScenarioGroup> importedGroups = new HashSet<ScenarioGroup>();
        final HashMap<String, ClassDecl> importedClasses = new HashMap<String, ClassDecl>();
        for (String packageName : compilationContext.getConfig().getImports()) {
            String packageDir = packageName.replace('.', '/');
            ScenarioGroup group = groups.get(packageDir);
            if (group == null) continue;
            group.accept(this, EmptyScope.INSTANCE);
            importedGroups.add(group);
            importedClasses.putAll(group.getClasses());
        }
        Scope importedScope = new Scope(){

            @Override
            public Decl resolve(String name) {
                return (Decl)importedClasses.get(name);
            }

            @Override
            public void add(Decl decl) {
            }
        };
        groups.values().parallelStream().filter(o -> !importedGroups.contains(o)).forEach(it -> it.accept(this, importedScope));
        return null;
    }

    @Override
    public Object visit(final ScenarioGroup scenarioGroup, Scope par) {
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                ClassDecl classDecl = scenarioGroup.getClasses().get(name);
                return classDecl != null ? classDecl : super.resolve(name);
            }

            @Override
            public void add(Decl decl) {
                ClassDecl classDecl = (ClassDecl)decl;
                classDecl.setGroup(scenarioGroup);
                scenarioGroup.getClasses().put(decl.getName(), classDecl);
            }
        };
        for (ClassDecl classDecl : scenarioGroup.getClasses().values()) {
            for (AttributeDecl attributeDecl : classDecl.getAttributes().values()) {
                attributeDecl.setType(attributeDecl.getType().accept(TypeResolver.INSTANCE, scope));
            }
            for (MethodDecl methodDecl : classDecl.getMethods()) {
                methodDecl.setType(methodDecl.getType().accept(TypeResolver.INSTANCE, scope));
            }
            classDecl.setFrozen(true);
        }
        for (ScenarioFile file : scenarioGroup.getFiles().values()) {
            if (file.getExternal()) continue;
            file.accept(this, scope);
        }
        return null;
    }

    @Override
    public Object visit(ScenarioFile scenarioFile, Scope par) {
        ScenarioGroup group = scenarioFile.getGroup();
        final String className = Identifiers.toUpperCamelCase(scenarioFile.getName()) + "Test";
        final ClassDecl classDecl = ClassDecl.of(group, className, null, new LinkedHashMap<String, AttributeDecl>(), new LinkedHashMap<String, AssociationDecl>(), new ArrayList<MethodDecl>());
        classDecl.setExternal(scenarioFile.getExternal());
        classDecl.setType(ClassType.of(classDecl));
        scenarioFile.setClassDecl(classDecl);
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                return className.equals(name) || NameResolver.ENCLOSING_CLASS.equals(name) ? classDecl : super.resolve(name);
            }
        };
        for (Scenario scenario : scenarioFile.getScenarios().values()) {
            scenario.accept(this, scope);
        }
        return null;
    }

    @Override
    public Object visit(Scenario scenario, Scope par) {
        ClassDecl classDecl = scenario.getFile().getClassDecl();
        final String methodName = Identifiers.toLowerCamelCase(scenario.getName());
        SentenceList body = scenario.getBody();
        final MethodDecl methodDecl = MethodDecl.of(classDecl, methodName, null, PrimitiveType.VOID, body);
        final ParameterDecl thisParam = ParameterDecl.of(methodDecl, "this", classDecl.getType());
        methodDecl.setParameters(Collections.singletonList(thisParam));
        classDecl.getMethods().add(methodDecl);
        scenario.setMethodDecl(methodDecl);
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                if ("this".equals(name)) {
                    return thisParam;
                }
                if (methodName.equals(name)) {
                    return methodDecl;
                }
                return super.resolve(name);
            }
        };
        body.accept(SentenceResolver.INSTANCE, scope);
        return null;
    }

    @Override
    public Name visit(Name name, Scope par) {
        return name;
    }

    @Override
    public Name visit(ResolvedName resolvedName, Scope par) {
        return resolvedName;
    }

    @Override
    public Name visit(UnresolvedName unresolvedName, Scope par) {
        Decl decl = par.resolve(unresolvedName.getValue());
        return decl == null ? unresolvedName : ResolvedName.of(decl);
    }

    static ClassDecl getEnclosingClass(Scope scope) {
        return (ClassDecl)scope.resolve(ENCLOSING_CLASS);
    }

    static ClassDecl resolveClass(Scope scope, Expr expr) {
        Type type = expr.accept(Typer.INSTANCE, null);
        return NameResolver.resolveClass(scope, type);
    }

    static ClassDecl resolveClass(Scope scope, Type type) {
        if (type instanceof ListType) {
            return NameResolver.resolveClass(scope, ((ListType)type).getElementType());
        }
        String typeName = type.accept(Namer.INSTANCE, null);
        return NameResolver.resolveClass(scope, typeName);
    }

    static ClassDecl resolveClass(Scope scope, String name) {
        Decl resolved = scope.resolve(name);
        if (resolved instanceof ClassDecl) {
            return (ClassDecl)resolved;
        }
        if (resolved != null) {
            throw new IllegalStateException("class name " + name + " resolved to " + resolved);
        }
        ClassDecl decl = ClassDecl.of(null, name, null, new LinkedHashMap<String, AttributeDecl>(), new LinkedHashMap<String, AssociationDecl>(), new ArrayList<MethodDecl>());
        decl.setExternal(NameResolver.getEnclosingClass(scope).getExternal());
        decl.setType(ClassType.of(decl));
        scope.add(decl);
        return decl;
    }

    static MethodDecl resolveMethod(ClassDecl classDecl, String name) {
        MethodDecl decl2;
        for (MethodDecl decl2 : classDecl.getMethods()) {
            if (!name.equals(decl2.getName())) continue;
            return decl2;
        }
        if (classDecl.getFrozen()) {
            throw new IllegalStateException("unresolved external method " + classDecl.getName() + "." + name);
        }
        SentenceList body = SentenceList.of(new ArrayList<Sentence>());
        decl2 = MethodDecl.of(classDecl, name, new ArrayList<ParameterDecl>(), null, body);
        classDecl.getMethods().add(decl2);
        return decl2;
    }

    static Name resolveAttributeOrAssociation(ClassDecl classDecl, Name name, Expr rhs) {
        if (name.accept(ExtractDecl.INSTANCE, null) != null) {
            return name;
        }
        return ResolvedName.of(NameResolver.resolveAttributeOrAssociation(classDecl, name.accept(Namer.INSTANCE, null), rhs));
    }

    static Decl resolveAttributeOrAssociation(ClassDecl classDecl, String attributeName, Expr rhs) {
        AttributeDecl existingAttribute = classDecl.getAttributes().get(attributeName);
        if (existingAttribute != null) {
            return existingAttribute;
        }
        AssociationDecl existingAssociation = classDecl.getAssociations().get(attributeName);
        if (existingAssociation != null) {
            return existingAssociation;
        }
        Type attributeType = rhs.accept(Typer.INSTANCE, null);
        if (attributeType instanceof ListType) {
            Type otherType = ((ListType)attributeType).getElementType();
            if (otherType instanceof ClassType) {
                return NameResolver.resolveAssociation(classDecl, attributeName, 2, ((ClassType)otherType).getClassDecl());
            }
            return NameResolver.resolveAttribute(classDecl, attributeName, attributeType);
        }
        if (attributeType instanceof ClassType) {
            return NameResolver.resolveAssociation(classDecl, attributeName, 1, ((ClassType)attributeType).getClassDecl());
        }
        return NameResolver.resolveAttribute(classDecl, attributeName, attributeType);
    }

    static AttributeDecl resolveAttribute(ClassDecl classDecl, String name, Type type) {
        AttributeDecl existing = classDecl.getAttributes().get(name);
        if (existing != null) {
            Type existingType = existing.getType();
            if (!type.equals(existingType)) {
                throw new IllegalStateException("mismatched attribute type " + classDecl.getName() + "." + name + ": " + existingType + " vs " + type);
            }
            return existing;
        }
        if (classDecl.getFrozen()) {
            throw new IllegalStateException("unresolved external attribute " + classDecl.getName() + "." + name);
        }
        AttributeDecl attribute = AttributeDecl.of(classDecl, name, type);
        classDecl.getAttributes().put(name, attribute);
        return attribute;
    }

    static AssociationDecl resolveAssociation(ClassDecl classDecl, String name, int cardinality, ClassDecl otherClass) {
        return NameResolver.resolveAssociation(classDecl, name, cardinality, otherClass, null, 0);
    }

    static AssociationDecl resolveAssociation(ClassDecl classDecl, String name, int cardinality, ClassDecl otherClass, String otherName, int otherCardinality) {
        AssociationDecl existing = classDecl.getAssociations().get(name);
        if (existing != null) {
            if (existing.getTarget() != otherClass || existing.getCardinality() != cardinality) {
                String olda = NameResolver.associationString(classDecl, name, existing.getCardinality(), existing.getTarget());
                String newa = NameResolver.associationString(classDecl, name, cardinality, otherClass);
                throw new IllegalStateException("conflicting redeclaration of association\nold: " + olda + "\nnew: " + newa);
            }
            AssociationDecl other = existing.getOther();
            if (other == null) {
                if (otherName != null) {
                    String newa = NameResolver.associationString(otherClass, otherName, otherCardinality, classDecl);
                    throw new IllegalStateException("conflicting redeclaration of reverse association\nold: none/uni-directional\nnew: " + newa);
                }
            } else if (!(otherName == null || otherName.equals(other.getName()) && otherCardinality == other.getCardinality())) {
                String olda = NameResolver.associationString(other.getOwner(), other.getName(), other.getCardinality(), classDecl);
                String newa = NameResolver.associationString(otherClass, otherName, otherCardinality, classDecl);
                throw new IllegalStateException("conflicting redeclaration of reverse association\nold: " + olda + "\nnew: " + newa);
            }
            return existing;
        }
        if (classDecl.getFrozen()) {
            throw new IllegalStateException("unresolved association " + NameResolver.associationString(classDecl, name, cardinality, otherClass));
        }
        AssociationDecl association = NameResolver.createAssociation(classDecl, name, cardinality, otherClass);
        if (otherClass == classDecl && name.equals(otherName)) {
            if (cardinality != otherCardinality) {
                throw new UnsupportedOperationException("mismatching cardinality of self-association\norigin:  " + NameResolver.cardinalityString(cardinality) + "\nreverse: " + NameResolver.cardinalityString(otherCardinality));
            }
            association.setOther(association);
        } else if (otherName != null) {
            if (otherClass.getFrozen()) {
                throw new IllegalStateException("unresolved reverse association " + NameResolver.associationString(otherClass, otherName, otherCardinality, classDecl));
            }
            AssociationDecl other = NameResolver.createAssociation(otherClass, otherName, otherCardinality, classDecl);
            association.setOther(other);
            other.setOther(association);
        }
        return association;
    }

    private static AssociationDecl createAssociation(ClassDecl owner, String name, int cardinality, ClassDecl target) {
        Type type = cardinality != 1 ? ListType.of(target.getType()) : target.getType();
        AssociationDecl association = AssociationDecl.of(owner, name, cardinality, target, type, null);
        owner.getAssociations().put(association.getName(), association);
        return association;
    }

    private static String associationString(ClassDecl owner, String name, int cardinality, ClassDecl other) {
        return owner.getName() + "." + name + ": " + NameResolver.cardinalityString(cardinality) + " " + other.getName();
    }

    private static String cardinalityString(int cardinality) {
        return cardinality == 1 ? "one" : "many";
    }

    static Name getAttributeOrAssociation(Scope scope, Expr receiver, Name name) {
        if (name.accept(ExtractDecl.INSTANCE, null) != null) {
            return name;
        }
        return NameResolver.getAttributeOrAssociation(NameResolver.resolveClass(scope, receiver), name.accept(Namer.INSTANCE, null));
    }

    static Name getAttributeOrAssociation(ClassDecl receiverClass, String name) {
        AttributeDecl attribute = receiverClass.getAttributes().get(name);
        if (attribute != null) {
            return ResolvedName.of(attribute);
        }
        AssociationDecl association = receiverClass.getAssociations().get(name);
        if (association != null) {
            return ResolvedName.of(association);
        }
        throw new IllegalStateException("unresolved attribute or association " + receiverClass.getName() + "." + name);
    }
}

