/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;
import org.fulib.scenarios.ast.scope.DelegatingScope;
import org.fulib.scenarios.ast.scope.HidingScope;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.sentence.AddSentence;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.ConditionalSentence;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.ExpectSentence;
import org.fulib.scenarios.ast.sentence.ExprSentence;
import org.fulib.scenarios.ast.sentence.FlattenSentenceList;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.RemoveSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.TakeSentence;
import org.fulib.scenarios.ast.sentence.TemplateSentence;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.visitor.ExtractDecl;
import org.fulib.scenarios.visitor.Namer;
import org.fulib.scenarios.visitor.Typer;
import org.fulib.scenarios.visitor.resolve.AddResolve;
import org.fulib.scenarios.visitor.resolve.ExprResolver;
import org.fulib.scenarios.visitor.resolve.NameResolver;
import org.fulib.scenarios.visitor.resolve.RemoveResolve;
import org.fulib.scenarios.visitor.resolve.SymbolCollector;

public enum SentenceResolver implements Sentence.Visitor<Scope, Sentence>
{
    INSTANCE;


    @Override
    public Sentence visit(SentenceList sentenceList, Scope par) {
        final HashMap decls = new HashMap();
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                Decl decl = (Decl)decls.get(name);
                return decl != null ? decl : super.resolve(name);
            }

            @Override
            public void add(Decl decl) {
                if (decl instanceof VarDecl) {
                    decls.put(decl.getName(), decl);
                    return;
                }
                super.add(decl);
            }
        };
        List<Sentence> oldItems = sentenceList.getItems();
        ArrayList<Sentence> newItems = new ArrayList<Sentence>(oldItems.size());
        for (Sentence item : oldItems) {
            Sentence resolved = item.accept(this, scope);
            resolved.accept(SymbolCollector.INSTANCE, decls);
            FlattenSentenceList.add(newItems, resolved);
        }
        sentenceList.setItems(newItems);
        return sentenceList;
    }

    @Override
    public Sentence visit(ExpectSentence expectSentence, Scope par) {
        expectSentence.getPredicates().replaceAll(it -> (ConditionalExpr)it.accept(ExprResolver.INSTANCE, par));
        return expectSentence;
    }

    @Override
    public Sentence visit(DiagramSentence diagramSentence, Scope par) {
        diagramSentence.setObject(diagramSentence.getObject().accept(ExprResolver.INSTANCE, par));
        return diagramSentence;
    }

    @Override
    public Sentence visit(HasSentence hasSentence, Scope par) {
        Expr receiver = hasSentence.getObject().accept(ExprResolver.INSTANCE, par);
        hasSentence.setObject(receiver);
        ClassDecl objectClass = NameResolver.resolveClass(par, receiver);
        String name = receiver.accept(Namer.INSTANCE, null);
        Scope scope = name != null ? new HidingScope(name, par) : par;
        for (NamedExpr namedExpr : hasSentence.getClauses()) {
            this.resolveHasNamedExpr(namedExpr, objectClass, scope);
        }
        return hasSentence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolveHasNamedExpr(NamedExpr namedExpr, ClassDecl objectClass, Scope scope) {
        ClassDecl otherClass;
        int cardinality;
        Expr expr = namedExpr.getExpr().accept(ExprResolver.INSTANCE, scope);
        namedExpr.setExpr(expr);
        if (namedExpr.getOtherName() == null) {
            namedExpr.setName(NameResolver.resolveAttributeOrAssociation(objectClass, namedExpr.getName(), expr));
            return;
        }
        String assocName = namedExpr.getName().accept(Namer.INSTANCE, null);
        String otherName = namedExpr.getOtherName().accept(Namer.INSTANCE, null);
        int otherCardinality = namedExpr.getOtherMany() ? 42 : 1;
        Type exprType = expr.accept(Typer.INSTANCE, scope);
        if (exprType instanceof ListType) {
            cardinality = 42;
            Type elementType = ((ListType)exprType).getElementType();
            if (!(elementType instanceof ClassType)) throw new IllegalStateException("illegal reverse association name for attribute");
            otherClass = ((ClassType)elementType).getClassDecl();
        } else {
            if (!(exprType instanceof ClassType)) throw new IllegalStateException("illegal reverse association name for attribute");
            cardinality = 1;
            otherClass = ((ClassType)exprType).getClassDecl();
        }
        AssociationDecl assoc = NameResolver.resolveAssociation(objectClass, assocName, cardinality, otherClass, otherName, otherCardinality);
        AssociationDecl other = assoc.getOther();
        namedExpr.setName(ResolvedName.of(assoc));
        namedExpr.setOtherName(ResolvedName.of(other));
    }

    @Override
    public Sentence visit(IsSentence isSentence, Scope par) {
        VarDecl varDecl = isSentence.getDescriptor();
        varDecl.setExpr(varDecl.getExpr().accept(ExprResolver.INSTANCE, par));
        if (varDecl.getType() == null) {
            varDecl.setType(varDecl.getExpr().accept(Typer.INSTANCE, null));
        }
        return isSentence;
    }

    @Override
    public Sentence visit(AnswerSentence answerSentence, Scope par) {
        if (answerSentence.getActor() != null) {
            answerSentence.setActor(answerSentence.getActor().accept(NameResolver.INSTANCE, par));
        }
        answerSentence.setResult(answerSentence.getResult().accept(ExprResolver.INSTANCE, par));
        return answerSentence;
    }

    @Override
    public Sentence visit(AddSentence addSentence, Scope par) {
        Expr source = addSentence.getSource().accept(ExprResolver.INSTANCE, par);
        Expr target = addSentence.getTarget();
        return target.accept(AddResolve.INSTANCE, source).accept(this, par);
    }

    @Override
    public Sentence visit(RemoveSentence removeSentence, Scope par) {
        Expr source = removeSentence.getSource().accept(ExprResolver.INSTANCE, par);
        Expr target = removeSentence.getTarget();
        return target.accept(RemoveResolve.INSTANCE, source).accept(this, par);
    }

    @Override
    public Sentence visit(TakeSentence takeSentence, Scope par) {
        takeSentence.setExample(takeSentence.getExample().accept(ExprResolver.INSTANCE, par));
        takeSentence.setCollection(takeSentence.getCollection().accept(ExprResolver.INSTANCE, par));
        final VarDecl varDecl = SentenceResolver.resolveVar(takeSentence);
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                return name.equals(varDecl.getName()) ? varDecl : super.resolve(name);
            }
        };
        takeSentence.setActions((SentenceList)takeSentence.getActions().accept(this, scope));
        return takeSentence;
    }

    private static VarDecl resolveVar(TakeSentence takeSentence) {
        Type type = takeSentence.getExample().accept(Typer.INSTANCE, null);
        Name name = takeSentence.getVarName();
        if (name != null) {
            Decl decl = name.accept(ExtractDecl.INSTANCE, null);
            if (decl != null) {
                return (VarDecl)decl;
            }
            String nameValue = name.accept(Namer.INSTANCE, null);
            VarDecl varDecl = VarDecl.of(nameValue, type, null);
            takeSentence.setVarName(ResolvedName.of(varDecl));
            return varDecl;
        }
        String exampleName = takeSentence.getExample().accept(Namer.INSTANCE, null);
        if (exampleName != null) {
            VarDecl varDecl = VarDecl.of(exampleName, type, null);
            takeSentence.setVarName(ResolvedName.of(varDecl));
            return varDecl;
        }
        throw new UnsupportedOperationException("cannot infer loop variable name");
    }

    @Override
    public Sentence visit(ConditionalSentence conditionalSentence, Scope par) {
        conditionalSentence.setCondition((ConditionalExpr)conditionalSentence.getCondition().accept(ExprResolver.INSTANCE, par));
        conditionalSentence.setActions((SentenceList)conditionalSentence.getActions().accept(this, par));
        return conditionalSentence;
    }

    @Override
    public Sentence visit(ExprSentence exprSentence, Scope par) {
        exprSentence.setExpr(exprSentence.getExpr().accept(ExprResolver.INSTANCE, par));
        return exprSentence;
    }

    @Override
    public Sentence visit(TemplateSentence templateSentence, Scope par) {
        templateSentence.getExprs().replaceAll(it -> it.accept(ExprResolver.INSTANCE, par));
        return templateSentence;
    }
}

