/*
 * Decompiled with CFR 0.152.
 */
package org.fulib;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fulib.StrUtil;
import org.fulib.classmodel.AssocRole;
import org.fulib.classmodel.Attribute;
import org.fulib.classmodel.ClassModel;
import org.fulib.classmodel.Clazz;
import org.fulib.classmodel.FMethod;
import org.fulib.util.Generator4ClassFile;
import org.fulib.yaml.YamlIdMap;

public class Generator {
    private static Logger logger = Logger.getLogger(Generator.class.getName());
    private String customTemplateFile = null;

    public void generate(ClassModel model) {
        ClassModel oldModel = this.loadOldClassModel(model.getPackageSrcFolder());
        if (oldModel != null) {
            this.markModifiedElementsInOldModel(oldModel, model);
            this.generateClasses(oldModel);
        }
        this.generateClasses(model);
        this.saveClassmodel(model);
    }

    private void generateClasses(ClassModel model) {
        for (Clazz clazz : model.getClasses()) {
            new Generator4ClassFile().setCustomTemplatesFile(this.getCustomTemplateFile()).generate(clazz);
        }
    }

    private ClassModel loadOldClassModel(String modelFolder) {
        String fileName = modelFolder + "/classModel.yaml";
        try {
            Path path = Paths.get(fileName, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            byte[] bytes = Files.readAllBytes(path);
            String yamlString = new String(bytes);
            YamlIdMap idMap = new YamlIdMap(ClassModel.class.getPackage().getName());
            ClassModel model = (ClassModel)idMap.decode(yamlString);
            return model;
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, "\n   could not load " + fileName, e);
            return null;
        }
    }

    private void saveClassmodel(ClassModel model) {
        YamlIdMap idMap = new YamlIdMap(ClassModel.class.getPackage().getName());
        String yamlString = idMap.encode(model);
        try {
            String modelFolder = model.getPackageSrcFolder();
            String fileName = modelFolder + "/classModel.yaml";
            Files.createDirectories(Paths.get(modelFolder, new String[0]), new FileAttribute[0]);
            Files.write(Paths.get(fileName, new String[0]), yamlString.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void markModifiedElementsInOldModel(ClassModel oldModel, ClassModel newModel) {
        for (Clazz oldClazz : oldModel.getClasses()) {
            Clazz newClazz = newModel.getClazz(oldClazz.getName());
            this.markModifiedElementsInOldClazz(oldClazz, newClazz);
        }
    }

    private void markModifiedElementsInOldClazz(Clazz oldClazz, Clazz newClazz) {
        boolean modified;
        logger = Logger.getLogger(Generator.class.getName());
        if (newClazz == null) {
            oldClazz.markAsModified();
            logger.info("\n   markedAsModified: class " + oldClazz.getName());
        }
        for (Attribute oldAttr : oldClazz.getAttributes()) {
            boolean bl = modified = newClazz == null;
            if (!modified) {
                Attribute newAttr = newClazz.getAttribute(oldAttr.getName());
                boolean bl2 = modified = newAttr == null || !StrUtil.stringEquals(oldAttr.getType(), newAttr.getType()) || !StrUtil.stringEquals(oldAttr.getPropertyStyle(), newAttr.getPropertyStyle());
            }
            if (!modified) continue;
            oldAttr.markAsModified();
            logger.info("\n   markedAsModified: attribute " + oldAttr.getName());
        }
        for (AssocRole oldRole : oldClazz.getRoles()) {
            boolean bl = modified = newClazz == null;
            if (!modified) {
                AssocRole newRole = newClazz.getRole(oldRole.getName());
                boolean bl3 = modified = newRole == null || oldRole.getCardinality() != newRole.getCardinality() || !StrUtil.stringEquals(oldRole.getPropertyStyle(), oldRole.getPropertyStyle());
            }
            if (!modified) continue;
            oldRole.markAsModified();
            logger.info("\n   markedAsModified: role " + oldRole.getName());
            if (oldRole.getOther() == null) continue;
            oldRole.getOther().markAsModified();
            logger.info("\n   markedAsModified: role " + oldRole.getOther().getName());
        }
        for (FMethod oldMethod : oldClazz.getMethods()) {
            modified = newClazz == null;
            String oldDeclaration = oldMethod.getDeclaration();
            if (!modified) {
                for (FMethod newMethod : newClazz.getMethods()) {
                    if (!newMethod.getDeclaration().equals(oldDeclaration)) continue;
                    modified = false;
                    break;
                }
                modified = true;
            }
            if (!modified) continue;
            oldMethod.setModified(true);
            logger.info("\n   markedAsModified: method " + oldMethod.getDeclaration());
        }
    }

    public String getCustomTemplateFile() {
        return this.customTemplateFile;
    }

    public Generator setCustomTemplatesFile(String customFileName) {
        this.customTemplateFile = customFileName;
        return this;
    }

    static {
        logger.setLevel(Level.SEVERE);
    }
}

