/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.ast.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.type.Type;

public enum PrimitiveType implements Type
{
    VOID("void"),
    BOOLEAN("boolean"),
    BYTE("byte"),
    SHORT("short"),
    CHAR("char"),
    INT("int"),
    LONG("long"),
    FLOAT("float"),
    DOUBLE("double"),
    OBJECT("Object"),
    STRING("String"),
    VOID_WRAPPER("Void"),
    BOOLEAN_WRAPPER("Boolean"),
    BYTE_WRAPPER("Byte"),
    SHORT_WRAPPER("Short"),
    CHAR_WRAPPER("Character"),
    INT_WRAPPER("Integer"),
    LONG_WRAPPER("Long"),
    FLOAT_WRAPPER("Float"),
    DOUBLE_WRAPPER("Double");

    public static final Map<String, PrimitiveType> javaNameMap;
    private final String javaName;

    private PrimitiveType(String javaName) {
        this.javaName = javaName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    @Override
    public <P, R> R accept(Node.Visitor<P, R> visitor, P par) {
        return visitor.visit(this, par);
    }

    @Override
    public <P, R> R accept(Type.Visitor<P, R> visitor, P par) {
        return visitor.visit(this, par);
    }

    public <P, R> R accept(Visitor<P, R> visitor, P par) {
        return visitor.visit(this, par);
    }

    static {
        PrimitiveType[] values = PrimitiveType.values();
        HashMap<String, PrimitiveType> map = new HashMap<String, PrimitiveType>(values.length);
        for (PrimitiveType value : values) {
            map.put(value.javaName, value);
        }
        javaNameMap = Collections.unmodifiableMap(map);
    }

    static interface Visitor<P, R> {
        public R visit(PrimitiveType var1, P var2);
    }
}

