/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.codegen;

import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.ast.type.UnresolvedType;
import org.fulib.scenarios.visitor.Typer;
import org.fulib.scenarios.visitor.codegen.CodeGenDTO;

public enum TypeGenerator implements Type.Visitor<CodeGenDTO, String>,
ClassDecl.Visitor<CodeGenDTO, String>
{
    INSTANCE;


    @Override
    public String visit(UnresolvedType unresolvedType, CodeGenDTO par) {
        throw new UnsupportedOperationException("unresolved type " + unresolvedType.getName());
    }

    @Override
    public String visit(ClassType classType, CodeGenDTO par) {
        return classType.getClassDecl().accept(this, par);
    }

    @Override
    public String visit(ListType listType, CodeGenDTO par) {
        par.addImport("java.util.List");
        Type elementType = listType.getElementType();
        Type wrappedType = Typer.primitiveToWrapper(elementType);
        return "List<" + wrappedType.accept(this, par) + ">";
    }

    @Override
    public String visit(PrimitiveType primitiveType, CodeGenDTO par) {
        return primitiveType.getJavaName();
    }

    @Override
    public String visit(ClassDecl classDecl, CodeGenDTO par) {
        ScenarioGroup group = classDecl.getGroup();
        if (group != par.group) {
            par.addImport(group.getPackageDir().replace('/', '.') + '.' + classDecl.getName());
        }
        return classDecl.getName();
    }
}

