/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.preprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.access.ExampleAccess;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.collection.MapAccessExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.sentence.FlattenSentenceList;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.visitor.Namer;

public enum AssignmentDesugar implements Expr.Visitor<Expr, Sentence>
{
    INSTANCE;


    @Override
    public Sentence visit(Expr expr, Expr par) {
        throw new IllegalStateException("cannot assign to " + expr.getClass().getEnclosingClass().getSimpleName());
    }

    @Override
    public Sentence visit(AttributeAccess attributeAccess, Expr par) {
        Expr receiver = attributeAccess.getReceiver();
        Name name = attributeAccess.getName();
        NamedExpr namedExpr = NamedExpr.of(name, par);
        return HasSentence.of(receiver, Collections.singletonList(namedExpr));
    }

    @Override
    public Sentence visit(ExampleAccess exampleAccess, Expr par) {
        return exampleAccess.getExpr().accept(this, par);
    }

    @Override
    public Sentence visit(MapAccessExpr mapAccessExpr, Expr par) {
        throw new AssertionError((Object)"appears after NameResolver");
    }

    @Override
    public Sentence visit(ListExpr listExpr, Expr par) {
        List<Expr> sources;
        List<Expr> targets = listExpr.getElements();
        int numElements = targets.size();
        ArrayList<Sentence> result = new ArrayList<Sentence>(numElements);
        if (par instanceof ListExpr && (sources = ((ListExpr)par).getElements()).size() == numElements) {
            for (int i = 0; i < numElements; ++i) {
                Expr target = targets.get(i);
                Expr source = sources.get(i);
                Sentence part = target.accept(this, source);
                result.add(part);
            }
        } else {
            VarDecl temp = VarDecl.of("temp", null, par);
            result.add(IsSentence.of(temp));
            for (Expr target : targets) {
                NameAccess source = NameAccess.of(ResolvedName.of(temp));
                Sentence part = target.accept(this, source);
                result.add(part);
            }
        }
        return new FlattenSentenceList(result);
    }

    @Override
    public Sentence visit(NameAccess nameAccess, Expr par) {
        String name = nameAccess.getName().accept(Namer.INSTANCE, null);
        VarDecl varDecl = VarDecl.of(name, null, par);
        return IsSentence.of(varDecl);
    }
}

