/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.builder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import org.fulib.builder.IModelManager;
import org.fulib.yaml.EventSource;
import org.fulib.yaml.Yamler;

public class ModelEventManager {
    private final EventSource eventSource = new EventSource();
    private IModelManager modelManager;
    private LinkedHashMap<String, Consumer<LinkedHashMap<String, String>>> consumerMap;

    public IModelManager getModelManager() {
        return this.modelManager;
    }

    public void setModelManager(IModelManager modelManager) {
        this.modelManager = modelManager;
    }

    public void applyEvents(String yaml) {
        if (yaml == null) {
            return;
        }
        Yamler yamler = new Yamler();
        ArrayList<LinkedHashMap<String, String>> list = yamler.decodeList(yaml);
        this.applyEvents(list);
    }

    public void applyEvents(ArrayList<LinkedHashMap<String, String>> events) {
        this.modelManager.initConsumers(this.consumerMap);
        for (LinkedHashMap<String, String> map : events) {
            if (this.eventSource.isOverwritten(map)) continue;
            String oldTimeStampString = map.get(".eventTimestamp");
            this.eventSource.setOldEventTimeStamp(oldTimeStampString);
            String eventType = map.get("eventType");
            Consumer<LinkedHashMap<String, String>> consumer = this.consumerMap.get(eventType);
            consumer.accept(map);
        }
        this.eventSource.setOldEventTimeStamp(0L);
    }

    public void append(LinkedHashMap<String, String> event) {
        this.eventSource.append(event);
    }
}

