/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.parser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.text.StringEscapeUtils;
import org.fulib.scenarios.ast.MultiDescriptor;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.access.ExampleAccess;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.call.CreationExpr;
import org.fulib.scenarios.ast.expr.collection.FilterExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.collection.RangeExpr;
import org.fulib.scenarios.ast.expr.conditional.AttributeCheckExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperator;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperatorExpr;
import org.fulib.scenarios.ast.expr.conditional.PredicateOperator;
import org.fulib.scenarios.ast.expr.conditional.PredicateOperatorExpr;
import org.fulib.scenarios.ast.expr.primary.DoubleLiteral;
import org.fulib.scenarios.ast.expr.primary.IntLiteral;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.expr.primary.StringLiteral;
import org.fulib.scenarios.ast.sentence.AddSentence;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.CallSentence;
import org.fulib.scenarios.ast.sentence.CommentLevel;
import org.fulib.scenarios.ast.sentence.ConditionalSentence;
import org.fulib.scenarios.ast.sentence.CreateSentence;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.ExpectSentence;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.RemoveSentence;
import org.fulib.scenarios.ast.sentence.SectionSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.TakeSentence;
import org.fulib.scenarios.ast.sentence.ThereSentence;
import org.fulib.scenarios.ast.sentence.WriteSentence;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.ast.type.UnresolvedType;
import org.fulib.scenarios.parser.Identifiers;
import org.fulib.scenarios.parser.ScenarioParser;
import org.fulib.scenarios.parser.ScenarioParserBaseListener;

public class ASTListener
extends ScenarioParserBaseListener {
    private ScenarioFile file;
    private Deque<Node> stack = new ArrayDeque<Node>();

    public ScenarioFile getFile() {
        return this.file;
    }

    private <T> T pop() {
        return (T)this.stack.pop();
    }

    private <T> List<T> pop(Class<T> type, int count) {
        ArrayList<Object> result = new ArrayList<Object>(Collections.nCopies(count, null));
        for (int i = count - 1; i >= 0; --i) {
            result.set(i, type.cast(this.stack.pop()));
        }
        return result;
    }

    @Override
    public void exitFile(ScenarioParser.FileContext ctx) {
        List<Scenario> scenarios = this.pop(Scenario.class, ctx.scenario().size());
        LinkedHashMap<String, Scenario> scenarioMap = new LinkedHashMap<String, Scenario>();
        this.file = ScenarioFile.of(null, null, scenarioMap, null);
        for (Scenario scenario : scenarios) {
            scenarioMap.put(scenario.getName(), scenario);
            scenario.setFile(this.file);
        }
    }

    @Override
    public void exitScenario(ScenarioParser.ScenarioContext ctx) {
        String name = ctx.header().HEADLINE_TEXT().getText().trim();
        List<Sentence> sentences = this.pop(Sentence.class, ctx.sentence().size());
        SentenceList body = SentenceList.of(sentences);
        Scenario scenario = Scenario.of(null, name, body, null);
        this.stack.push(scenario);
    }

    @Override
    public void exitSectionSentence(ScenarioParser.SectionSentenceContext ctx) {
        String text = ctx.HEADLINE_TEXT().getText().trim();
        SectionSentence sectionSentence = SectionSentence.of(text, CommentLevel.CODE_SECTION);
        this.stack.push(sectionSentence);
    }

    @Override
    public void exitCommentSentence(ScenarioParser.CommentSentenceContext ctx) {
        String text = ctx.HEADLINE_TEXT().getText().trim();
        SectionSentence sectionSentence = SectionSentence.of(text, CommentLevel.REGULAR);
        this.stack.push(sectionSentence);
    }

    @Override
    public void exitThereSentence(ScenarioParser.ThereSentenceContext ctx) {
        List<MultiDescriptor> descriptors = this.pop(MultiDescriptor.class, ctx.thereClause().size());
        this.stack.push(ThereSentence.of(descriptors));
    }

    private List<NamedExpr> popAttributes(ScenarioParser.WithClausesContext withClauses) {
        int numAttributes = withClauses != null ? withClauses.withClause().size() : 0;
        return this.pop(NamedExpr.class, numAttributes);
    }

    private void pushDescriptor(List<String> names, ScenarioParser.WithClausesContext withClausesContext) {
        List<NamedExpr> attributes = this.popAttributes(withClausesContext);
        Type type = (Type)this.pop();
        MultiDescriptor multiDescriptor = MultiDescriptor.of(type, names, attributes);
        this.stack.push(multiDescriptor);
    }

    @Override
    public void exitSimpleDescriptor(ScenarioParser.SimpleDescriptorContext ctx) {
        String name = Identifiers.varName(ctx.name());
        List<String> names = name == null ? Collections.emptyList() : Collections.singletonList(name);
        this.pushDescriptor(names, ctx.withClauses());
    }

    @Override
    public void exitMultiDescriptor(ScenarioParser.MultiDescriptorContext ctx) {
        List<String> names = ctx.name().stream().map(Identifiers::varName).collect(Collectors.toList());
        this.pushDescriptor(names, ctx.withClauses());
    }

    @Override
    public void exitExpectSentence(ScenarioParser.ExpectSentenceContext ctx) {
        List<ConditionalExpr> exprs = this.pop(ConditionalExpr.class, ctx.thatClauses().thatClause().size());
        this.stack.push(ExpectSentence.of(exprs));
    }

    @Override
    public void exitDiagramSentence(ScenarioParser.DiagramSentenceContext ctx) {
        Expr object = (Expr)this.pop();
        String fileName = ctx.fileName.getText();
        this.stack.push(DiagramSentence.of(object, fileName));
    }

    @Override
    public void exitHasSentence(ScenarioParser.HasSentenceContext ctx) {
        List<NamedExpr> clauses = this.pop(NamedExpr.class, ctx.hasClauses().hasClause().size());
        Expr object = (Expr)this.pop();
        this.stack.push(HasSentence.of(object, clauses));
    }

    @Override
    public void exitIsSentence(ScenarioParser.IsSentenceContext ctx) {
        List<NamedExpr> attributes = this.popAttributes(ctx.withClauses());
        Type type = (Type)this.pop();
        CreationExpr ctor = CreationExpr.of(type, attributes);
        String name = Identifiers.varName(ctx.name());
        VarDecl varDecl = VarDecl.of(name, null, ctor);
        this.stack.push(IsSentence.of(varDecl));
    }

    @Override
    public void exitCreateSentence(ScenarioParser.CreateSentenceContext ctx) {
        Name actor = Identifiers.name(ctx.actor().name());
        MultiDescriptor desc = (MultiDescriptor)this.pop();
        CreateSentence createSentence = CreateSentence.of(actor, desc);
        this.stack.push(createSentence);
    }

    @Override
    public void exitCallSentence(ScenarioParser.CallSentenceContext ctx) {
        Name actor = Identifiers.name(ctx.actor().name());
        Name name = Identifiers.name(ctx.name());
        List<NamedExpr> args = this.pop(NamedExpr.class, ctx.withClauses() != null ? ctx.withClauses().withClause().size() : 0);
        Expr receiver = ctx.ON() != null ? (Expr)this.pop() : null;
        SentenceList body = SentenceList.of(new ArrayList<Sentence>());
        CallExpr callExpr = CallExpr.of(name, receiver, args, body);
        CallSentence callSentence = CallSentence.of(actor, callExpr);
        this.stack.push(callSentence);
    }

    @Override
    public void exitAnswerSentence(ScenarioParser.AnswerSentenceContext ctx) {
        Name actor = Identifiers.name(ctx.actor().name());
        Expr result = (Expr)this.pop();
        String varName = Identifiers.varName(ctx.name());
        AnswerSentence answerSentence = AnswerSentence.of(actor, result, varName);
        this.stack.push(answerSentence);
    }

    @Override
    public void exitWriteSentence(ScenarioParser.WriteSentenceContext ctx) {
        Expr target = (Expr)this.pop();
        Expr source = (Expr)this.pop();
        Name actor = Identifiers.name(ctx.actor().name());
        WriteSentence writeSentence = WriteSentence.of(actor, source, target);
        this.stack.push(writeSentence);
    }

    @Override
    public void exitAddSentence(ScenarioParser.AddSentenceContext ctx) {
        Expr target = (Expr)this.pop();
        Expr source = (Expr)this.pop();
        Name actor = Identifiers.name(ctx.actor().name());
        AddSentence addSentence = AddSentence.of(actor, source, target);
        this.stack.push(addSentence);
    }

    @Override
    public void exitRemoveSentence(ScenarioParser.RemoveSentenceContext ctx) {
        Expr target = (Expr)this.pop();
        Expr source = (Expr)this.pop();
        Name actor = Identifiers.name(ctx.actor().name());
        RemoveSentence removeSentence = RemoveSentence.of(actor, source, target);
        this.stack.push(removeSentence);
    }

    @Override
    public void exitConditionalSentence(ScenarioParser.ConditionalSentenceContext ctx) {
        List<Sentence> sentences = this.pop(Sentence.class, ctx.simpleSentence().size());
        SentenceList actions = SentenceList.of(sentences);
        ConditionalExpr condition = (ConditionalExpr)this.pop();
        ConditionalSentence sentence = ConditionalSentence.of(condition, actions);
        this.stack.push(sentence);
    }

    @Override
    public void exitTakeSentence(ScenarioParser.TakeSentenceContext ctx) {
        List<Sentence> sentences = this.pop(Sentence.class, ctx.simpleSentence().size());
        SentenceList actions = SentenceList.of(sentences);
        Expr collection = (Expr)this.pop();
        Expr example = (Expr)this.pop();
        Name varName = Identifiers.name(ctx.simpleName());
        Name actor = Identifiers.name(ctx.actor().name());
        this.stack.push(TakeSentence.of(actor, varName, example, collection, actions));
    }

    @Override
    public void exitNamedSimple(ScenarioParser.NamedSimpleContext ctx) {
        Name name = Identifiers.name(ctx.simpleName());
        Expr expr = (Expr)this.pop();
        this.stack.push(NamedExpr.of(name, expr));
    }

    @Override
    public void exitNamedNumber(ScenarioParser.NamedNumberContext ctx) {
        Name name = Identifiers.name(ctx.name());
        Expr expr = (Expr)this.pop();
        this.stack.push(NamedExpr.of(name, expr));
    }

    @Override
    public void exitBidiNamedExpr(ScenarioParser.BidiNamedExprContext ctx) {
        Expr expr = (Expr)this.pop();
        Name name = Identifiers.name(ctx.firstName);
        NamedExpr namedExpr = NamedExpr.of(name, expr);
        namedExpr.setOtherName(Identifiers.name(ctx.otherName));
        namedExpr.setOtherMany(ctx.ONE() != null);
        this.stack.push(namedExpr);
    }

    @Override
    public void exitSimpleTypeClause(ScenarioParser.SimpleTypeClauseContext ctx) {
        this.stack.push(UnresolvedType.of(Identifiers.typeNameValue(ctx)));
    }

    @Override
    public void exitMultiTypeClause(ScenarioParser.MultiTypeClauseContext ctx) {
        this.stack.push(UnresolvedType.of(Identifiers.typeNameValue(ctx)));
    }

    @Override
    public void exitNumber(ScenarioParser.NumberContext ctx) {
        TerminalNode decimal = ctx.DECIMAL();
        if (decimal != null) {
            double value = Double.parseDouble(decimal.getText());
            this.stack.push(DoubleLiteral.of(value));
        } else {
            int value = Integer.parseInt(ctx.INTEGER().getText());
            this.stack.push(IntLiteral.of(value));
        }
    }

    @Override
    public void exitStringLiteral(ScenarioParser.StringLiteralContext ctx) {
        String text = ctx.STRING_LITERAL().getText();
        String stripped = text.substring(1, text.length() - 1);
        String value = StringEscapeUtils.unescapeJava((String)stripped);
        this.stack.push(StringLiteral.of(value));
    }

    @Override
    public void exitNameAccess(ScenarioParser.NameAccessContext ctx) {
        this.stack.push(NameAccess.of(Identifiers.name(ctx.name())));
    }

    @Override
    public void exitAttributeAccess(ScenarioParser.AttributeAccessContext ctx) {
        Name name = Identifiers.name(ctx.name());
        Expr receiver = (Expr)this.pop();
        this.stack.push(AttributeAccess.of(name, receiver));
    }

    @Override
    public void exitExampleAccess(ScenarioParser.ExampleAccessContext ctx) {
        Expr expr = (Expr)this.pop();
        Expr value = (Expr)this.pop();
        this.stack.push(ExampleAccess.of(value, expr));
    }

    @Override
    public void exitFilterExpr(ScenarioParser.FilterExprContext ctx) {
        ConditionalExpr predicate = (ConditionalExpr)this.pop();
        Expr source = (Expr)this.pop();
        FilterExpr filterExpr = FilterExpr.of(source, predicate);
        this.stack.push(filterExpr);
    }

    @Override
    public void exitAttrCheck(ScenarioParser.AttrCheckContext ctx) {
        NamedExpr valueAndAttribute = (NamedExpr)this.pop();
        Expr value = valueAndAttribute.getExpr();
        Name attribute = valueAndAttribute.getName();
        Expr receiver = ctx.access() != null ? (Expr)this.pop() : null;
        this.stack.push(AttributeCheckExpr.of(receiver, attribute, value));
    }

    @Override
    public void exitAndCondExpr(ScenarioParser.AndCondExprContext ctx) {
        for (int i = ctx.AND().size(); i > 0; --i) {
            Expr rhs = (Expr)this.pop();
            Expr lhs = (Expr)this.pop();
            ConditionalOperatorExpr condOp = ConditionalOperatorExpr.of(lhs, ConditionalOperator.AND, rhs);
            this.stack.push(condOp);
        }
    }

    @Override
    public void exitOrCondExpr(ScenarioParser.OrCondExprContext ctx) {
        for (int i = ctx.OR().size(); i > 0; --i) {
            Expr rhs = (Expr)this.pop();
            Expr lhs = (Expr)this.pop();
            ConditionalOperatorExpr condOp = ConditionalOperatorExpr.of(lhs, ConditionalOperator.OR, rhs);
            this.stack.push(condOp);
        }
    }

    @Override
    public void exitCondOpExpr(ScenarioParser.CondOpExprContext ctx) {
        Expr rhs = (Expr)this.pop();
        Expr lhs = ctx.lhs != null ? (Expr)this.pop() : null;
        String opText = ASTListener.inputText(ctx.condOp()).replaceAll("\\s+", " ");
        ConditionalOperator op = ConditionalOperator.getByOp(opText);
        if (op == null) {
            throw new UnsupportedOperationException("no ConditionalOperator constant for '" + opText + "'");
        }
        ConditionalOperatorExpr operatorExpr = ConditionalOperatorExpr.of(lhs, op, rhs);
        this.stack.push(operatorExpr);
    }

    @Override
    public void exitPredOpExpr(ScenarioParser.PredOpExprContext ctx) {
        Expr lhs = ctx.lhs != null ? (Expr)this.pop() : null;
        String opText = ASTListener.inputText(ctx.predOp()).replaceAll("\\s+", " ");
        PredicateOperator op = PredicateOperator.nameMap.get(opText);
        if (op == null) {
            throw new UnsupportedOperationException("no PredicateOperator constant for '" + opText + "'");
        }
        PredicateOperatorExpr expr = PredicateOperatorExpr.of(lhs, op);
        this.stack.push(expr);
    }

    @Override
    public void exitList(ScenarioParser.ListContext ctx) {
        List<Expr> elements = this.pop(Expr.class, ctx.listElem().size());
        this.stack.push(ListExpr.of(elements));
    }

    @Override
    public void exitRange(ScenarioParser.RangeContext ctx) {
        Expr end = (Expr)this.pop();
        Expr start = (Expr)this.pop();
        this.stack.push(RangeExpr.of(start, end));
    }

    static String inputText(ParserRuleContext ctx) {
        CharStream inputStream = ctx.getStart().getInputStream();
        Interval interval = Interval.of((int)ctx.getStart().getStartIndex(), (int)ctx.getStop().getStopIndex());
        return inputStream.getText(interval);
    }

    static void report(Token position, String message) {
        String sourceName = position.getInputStream().getSourceName();
        int line = position.getLine();
        int column = position.getCharPositionInLine() + 1;
        System.err.println(sourceName + ":" + line + ":" + column + ": error: " + message);
    }
}

