/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.access.ExampleAccess;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.call.CreationExpr;
import org.fulib.scenarios.ast.expr.collection.FilterExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.collection.MapAccessExpr;
import org.fulib.scenarios.ast.expr.collection.RangeExpr;
import org.fulib.scenarios.ast.expr.conditional.AttributeCheckExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperator;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperatorExpr;
import org.fulib.scenarios.ast.expr.conditional.PredicateOperatorExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.expr.primary.StringLiteral;
import org.fulib.scenarios.ast.scope.DelegatingScope;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.visitor.Namer;
import org.fulib.scenarios.visitor.Typer;
import org.fulib.scenarios.visitor.resolve.NameResolver;
import org.fulib.scenarios.visitor.resolve.SentenceResolver;
import org.fulib.scenarios.visitor.resolve.TypeResolver;

public enum ExprResolver implements Expr.Visitor<Scope, Expr>
{
    INSTANCE;


    @Override
    public Expr visit(Expr expr, Scope par) {
        return expr;
    }

    @Override
    public Expr visit(AttributeAccess attributeAccess, Scope par) {
        Expr receiver = attributeAccess.getReceiver().accept(this, par);
        attributeAccess.setReceiver(receiver);
        Type receiverType = receiver.accept(Typer.INSTANCE, null);
        if (receiverType instanceof ListType) {
            String attributeName = attributeAccess.getName().accept(Namer.INSTANCE, null);
            Type elementType = ((ListType)receiverType).getElementType();
            Name resolvedName = NameResolver.getAttributeOrAssociation(NameResolver.resolveClass(par, elementType), attributeName);
            return MapAccessExpr.of(resolvedName, receiver);
        }
        attributeAccess.setName(NameResolver.getAttributeOrAssociation(par, receiver, attributeAccess.getName()));
        return attributeAccess;
    }

    @Override
    public Expr visit(ExampleAccess exampleAccess, Scope par) {
        exampleAccess.setExpr(exampleAccess.getExpr().accept(this, par));
        return exampleAccess;
    }

    @Override
    public Expr visit(FilterExpr filterExpr, Scope par) {
        Expr source = filterExpr.getSource().accept(this, par);
        filterExpr.setSource(source);
        Type sourceType = source.accept(Typer.INSTANCE, null);
        Type elementType = ((ListType)sourceType).getElementType();
        final VarDecl it = VarDecl.of("it", elementType, null);
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                return "<predicate-receiver>".equals(name) ? it : super.resolve(name);
            }
        };
        filterExpr.setPredicate((ConditionalExpr)filterExpr.getPredicate().accept(this, scope));
        return filterExpr;
    }

    @Override
    public Expr visit(NameAccess nameAccess, Scope par) {
        if (nameAccess.getName() instanceof UnresolvedName) {
            UnresolvedName unresolvedName = (UnresolvedName)nameAccess.getName();
            String unresolvedValue = unresolvedName.getValue();
            Decl target = par.resolve(unresolvedValue);
            if (target == null) {
                return StringLiteral.of(unresolvedName.getText());
            }
            nameAccess.setName(ResolvedName.of(target));
        }
        return nameAccess;
    }

    @Override
    public Expr visit(CreationExpr creationExpr, Scope par) {
        creationExpr.setType(creationExpr.getType().accept(TypeResolver.INSTANCE, par));
        ClassDecl classDecl = NameResolver.resolveClass(par, creationExpr.getType());
        for (NamedExpr namedExpr : creationExpr.getAttributes()) {
            namedExpr.setExpr(namedExpr.getExpr().accept(this, par));
            namedExpr.setName(NameResolver.resolveAttributeOrAssociation(classDecl, namedExpr.getName(), namedExpr.getExpr()));
        }
        return creationExpr;
    }

    @Override
    public Expr visit(CallExpr callExpr, Scope par) {
        List<NamedExpr> arguments = callExpr.getArguments();
        Expr receiver = callExpr.getReceiver();
        if (receiver != null) {
            receiver = receiver.accept(this, par);
        } else {
            Decl thisDecl = par.resolve("this");
            receiver = NameAccess.of(ResolvedName.of(thisDecl));
        }
        callExpr.setReceiver(receiver);
        for (NamedExpr argument : arguments) {
            argument.setExpr(argument.getExpr().accept(this, par));
        }
        ClassDecl receiverClass = NameResolver.resolveClass(par, callExpr.getReceiver());
        String methodName = callExpr.getName().accept(Namer.INSTANCE, null);
        MethodDecl method = NameResolver.resolveMethod(receiverClass, methodName);
        List<ParameterDecl> parameters = method.getParameters();
        boolean isNew = method.getParameters().isEmpty();
        final HashMap<String, ParameterDecl> decls = new HashMap<String, ParameterDecl>();
        if (isNew) {
            ParameterDecl thisParam = ParameterDecl.of(method, "this", receiverClass.getType());
            parameters.add(thisParam);
            decls.put("this", thisParam);
        } else {
            decls.put("this", parameters.get(0));
            String params = parameters.stream().skip(1L).map(ParameterDecl::getName).collect(Collectors.joining(" "));
            String args = arguments.stream().map(NamedExpr::getName).map(n -> n.accept(Namer.INSTANCE, null)).collect(Collectors.joining(" "));
            if (!params.equals(args)) {
                throw new IllegalStateException("mismatching parameters and arguments:\nparameters: " + params + "\narguments : " + args);
            }
        }
        String receiverName = receiver.accept(Namer.INSTANCE, null);
        if (receiverName != null) {
            decls.put(receiverName, parameters.get(0));
        }
        for (int i = 0; i < arguments.size(); ++i) {
            ParameterDecl param;
            NamedExpr argument = arguments.get(i);
            String name = argument.getName().accept(Namer.INSTANCE, null);
            Expr expr = argument.getExpr();
            if (isNew) {
                Type type = expr.accept(Typer.INSTANCE, null);
                param = ParameterDecl.of(method, name, type);
                parameters.add(param);
            } else {
                param = parameters.get(i + 1);
            }
            argument.setName(ResolvedName.of(param));
            decls.put(name, param);
            String exprName = expr.accept(Namer.INSTANCE, null);
            if (exprName == null) continue;
            decls.put(exprName, param);
        }
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                Decl decl = (Decl)decls.get(name);
                return decl != null ? decl : super.resolve(name);
            }
        };
        callExpr.getBody().accept(SentenceResolver.INSTANCE, scope);
        if (method.getType() == null) {
            Type returnType = callExpr.accept(Typer.INSTANCE, null);
            method.setType(returnType);
        }
        method.getBody().getItems().addAll(callExpr.getBody().getItems());
        return callExpr;
    }

    @Override
    public Expr visit(AttributeCheckExpr attributeCheckExpr, Scope par) {
        Expr receiver = attributeCheckExpr.getReceiver();
        Expr expected = attributeCheckExpr.getValue();
        Name attribute = attributeCheckExpr.getAttribute();
        AttributeAccess access = AttributeAccess.of(attribute, receiver);
        ConditionalOperatorExpr condOp = ConditionalOperatorExpr.of(access, ConditionalOperator.IS, expected);
        return condOp.accept(this, par);
    }

    @Override
    public Expr visit(ConditionalOperatorExpr conditionalOperatorExpr, Scope par) {
        Expr lhs = conditionalOperatorExpr.getLhs();
        if (lhs != null) {
            conditionalOperatorExpr.setLhs(lhs.accept(this, par));
        } else {
            Decl predicateReceiver = par.resolve("<predicate-receiver>");
            if (predicateReceiver == null) {
                throw new IllegalStateException("invalid conditional operator - missing left-hand expression");
            }
            conditionalOperatorExpr.setLhs(NameAccess.of(ResolvedName.of(predicateReceiver)));
        }
        conditionalOperatorExpr.setRhs(conditionalOperatorExpr.getRhs().accept(this, par));
        return conditionalOperatorExpr;
    }

    @Override
    public Expr visit(PredicateOperatorExpr predicateOperatorExpr, Scope par) {
        Expr lhs = predicateOperatorExpr.getLhs();
        if (lhs != null) {
            predicateOperatorExpr.setLhs(lhs.accept(this, par));
        } else {
            Decl predicateReceiver = par.resolve("<predicate-receiver>");
            if (predicateReceiver == null) {
                throw new IllegalStateException("invalid predicate operator - missing left-hand expression");
            }
            predicateOperatorExpr.setLhs(NameAccess.of(ResolvedName.of(predicateReceiver)));
        }
        return predicateOperatorExpr;
    }

    @Override
    public Expr visit(ListExpr listExpr, Scope par) {
        listExpr.getElements().replaceAll(it -> it.accept(this, par));
        return listExpr;
    }

    @Override
    public Expr visit(RangeExpr rangeExpr, Scope par) {
        rangeExpr.setStart(rangeExpr.getStart().accept(this, par));
        rangeExpr.setEnd(rangeExpr.getEnd().accept(this, par));
        return rangeExpr;
    }
}

