/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.fulib.Generator;
import org.fulib.Parser;
import org.fulib.StrUtil;
import org.fulib.classmodel.AssocRole;
import org.fulib.classmodel.Attribute;
import org.fulib.classmodel.Clazz;
import org.fulib.classmodel.CodeFragment;
import org.fulib.classmodel.FMethod;
import org.fulib.classmodel.FileFragmentMap;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.StringRenderer;

public class Generator4ClassFile {
    private String customTemplatesFile;

    public void generate(Clazz clazz) {
        String classFileName = clazz.getModel().getPackageSrcFolder() + "/" + clazz.getName() + ".java";
        FileFragmentMap fragmentMap = Parser.parse(classFileName);
        this.generatePackageDecl(clazz, fragmentMap);
        this.generateClassDecl(clazz, fragmentMap);
        this.generateAttributes(clazz, fragmentMap);
        this.generateAssociations(clazz, fragmentMap);
        this.generateMethods(clazz, fragmentMap);
        this.generatePropertyChangeSupport(clazz, fragmentMap);
        this.generateToString(clazz, fragmentMap);
        this.generateRemoveYou(clazz, fragmentMap);
        fragmentMap.add("classEnd", "}", 1);
        this.generateImports(clazz, fragmentMap);
        if (clazz.getModified() && fragmentMap.classBodyIsEmpty(fragmentMap)) {
            Path path = Paths.get(classFileName, new String[0]);
            try {
                Files.deleteIfExists(path);
                Logger.getLogger(Generator.class.getName()).info("\n   deleting empty file " + classFileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.compressBlankLines(fragmentMap);
            fragmentMap.writeFile();
        }
    }

    private void compressBlankLines(FileFragmentMap fragmentMap) {
        ArrayList<CodeFragment> fragmentList = fragmentMap.getFragmentList();
        int noOfBlankLines = 0;
        block0: for (int i = 0; i < fragmentList.size(); ++i) {
            CodeFragment firstFragment = fragmentList.get(i);
            if (firstFragment.getText().matches("\\s*")) {
                String newText = "";
                for (int pos = firstFragment.getText().length() - 1; pos >= 0; --pos) {
                    if (firstFragment.getText().charAt(pos) != '\n') continue;
                    if (++noOfBlankLines == 2) {
                        newText = firstFragment.getText().substring(pos);
                        firstFragment.setText(newText);
                        continue block0;
                    }
                    if (noOfBlankLines <= 2) continue;
                    newText = firstFragment.getText().substring(pos + 1);
                    firstFragment.setText(newText);
                    continue block0;
                }
                continue;
            }
            noOfBlankLines = 0;
        }
    }

    private void generatePackageDecl(Clazz clazz, FileFragmentMap fragmentMap) {
        String result = String.format("package %s;", clazz.getModel().getPackageName());
        fragmentMap.add("package", result, 2);
    }

    private void generateImports(Clazz clazz, FileFragmentMap fragmentMap) {
        for (String imp : clazz.getImportList()) {
            String[] split = imp.split(" ");
            String key = split[split.length - 1];
            key = key.substring(0, key.length() - 1);
            fragmentMap.add("import:" + key, imp, 1);
        }
    }

    private void generateClassDecl(Clazz clazz, FileFragmentMap fragmentMap) {
        STGroup group = this.createSTGroup("templates/classDecl.stg");
        ST st = group.getInstanceOf("classDecl");
        st.add("name", (Object)clazz.getName());
        st.add("superClass", clazz.getSuperClass() != null ? clazz.getSuperClass().getName() : null);
        String result = st.render();
        fragmentMap.add("class", result, 2);
    }

    private void generateAttributes(Clazz clazz, FileFragmentMap fragmentMap) {
        for (Attribute attr : clazz.getAttributes()) {
            STGroup group;
            if ("JavaFX".equals(attr.getPropertyStyle())) {
                group = this.createSTGroup("templates/JavaFXattributes.stg");
                fragmentMap.add("import:javafx.beans.property.*", "import javafx.beans.property.*;", 1);
            } else {
                group = this.createSTGroup("templates/attributes.stg");
            }
            String attrType = attr.getType();
            if ("JavaFX".equals(attr.getPropertyStyle())) {
                attrType = attrType.equals("int") ? "Integer" : StrUtil.cap(attrType);
            }
            ST attrTemplate = group.getInstanceOf("propertyDecl");
            attrTemplate.add("name", (Object)attr.getName());
            String result = attrTemplate.render();
            fragmentMap.add("attribute:PROPERTY_" + attr.getName(), result, 2, attr.getModified());
            attrTemplate = group.getInstanceOf("attrDecl");
            attrTemplate.add("type", (Object)attrType);
            attrTemplate.add("name", (Object)attr.getName());
            attrTemplate.add("value", (Object)attr.getInitialization());
            result = attrTemplate.render();
            fragmentMap.add("attribute:" + attr.getName(), result, 2, attr.getModified());
            if ("JavaFX".equals(attr.getPropertyStyle())) {
                attrTemplate = group.getInstanceOf("initMethod");
                attrTemplate.add("name", (Object)attr.getName());
                attrTemplate.add("type", (Object)attrType);
                result = attrTemplate.render();
                fragmentMap.add("method:_init" + StrUtil.cap(attr.getName()) + "()", result, 2, attr.getModified());
            } else {
                fragmentMap.add("method:_init" + StrUtil.cap(attr.getName()) + "()", "", 2, true);
            }
            attrTemplate = group.getInstanceOf("attrGet");
            attrTemplate.add("type", (Object)attr.getType());
            attrTemplate.add("name", (Object)attr.getName());
            result = attrTemplate.render();
            fragmentMap.add("method:get" + StrUtil.cap(attr.getName()) + "()", result, 2, attr.getModified());
            attrTemplate = group.getInstanceOf("attrSet");
            attrTemplate.add("class", (Object)attr.getClazz().getName());
            attrTemplate.add("type", (Object)attr.getType());
            attrTemplate.add("name", (Object)attr.getName());
            attrTemplate.add("useEquals", (Object)attr.getType().equals("String"));
            result = attrTemplate.render();
            fragmentMap.add("method:set" + StrUtil.cap(attr.getName()) + "(" + attr.getType() + ")", result, 3, attr.getModified());
            if ("JavaFX".equals(attr.getPropertyStyle())) {
                attrTemplate = group.getInstanceOf("propertyGet");
                attrTemplate.add("name", (Object)attr.getName());
                attrTemplate.add("type", (Object)attrType);
                result = attrTemplate.render();
                fragmentMap.add("method:" + attr.getName() + "Property()", result, 3, attr.getModified());
                continue;
            }
            fragmentMap.add("method:" + attr.getName() + "Property()", "", 3, true);
        }
    }

    private void generateAssociations(Clazz clazz, FileFragmentMap fragmentMap) {
        for (AssocRole role : clazz.getRoles()) {
            String oldSignature;
            String result;
            ST st;
            STGroup group;
            if (role.getName() == null) continue;
            if ("JavaFX".equals(role.getPropertyStyle())) {
                group = this.createSTGroup("templates/JavaFXassociations.stg");
                fragmentMap.add("import:javafx.beans.property.*", "import javafx.beans.property.*;", 1);
            } else {
                group = this.createSTGroup("templates/associations.stg");
            }
            String roleType = role.getOther().getClazz().getName();
            if (role.getCardinality() != 1 && !"JavaFX".equals(role.getPropertyStyle())) {
                roleType = String.format(role.getRoleType(), role.getOther().getClazz().getName());
                st = group.getInstanceOf("emptySetDecl");
                st.add("roleName", (Object)role.getName());
                st.add("otherClassName", (Object)role.getOther().getClazz().getName());
                st.add("roleType", (Object)roleType);
                result = st.render();
                fragmentMap.add("attribute:EMPTY_" + role.getName(), result, 3, role.getModified());
            }
            st = group.getInstanceOf("propertyDecl");
            st.add("roleName", (Object)role.getName());
            result = st.render();
            fragmentMap.add("attribute:PROPERTY_" + role.getName(), result, 2, role.getModified());
            st = group.getInstanceOf("roleAttrDecl");
            st.add("roleName", (Object)role.getName());
            st.add("roleType", (Object)roleType);
            st.add("toMany", (Object)(role.getCardinality() != 1 ? 1 : 0));
            st.add("otherClassName", (Object)role.getOther().getClazz().getName());
            result = st.render();
            fragmentMap.add("attribute:" + role.getName(), result, 2, role.getModified());
            if ("JavaFX".equals(role.getPropertyStyle())) {
                result = "";
                fragmentMap.add("attribute:EMPTY_" + role.getName(), result, 3, true);
                st = group.getInstanceOf("initMethod");
                st.add("roleName", (Object)role.getName());
                st.add("toMany", (Object)(role.getCardinality() != 1 ? 1 : 0));
                st.add("myClassName", (Object)clazz.getName());
                st.add("otherClassName", (Object)role.getOther().getClazz().getName());
                st.add("otherRoleName", (Object)role.getOther().getName());
                st.add("otherToMany", (Object)(role.getOther().getCardinality() != 1 ? 1 : 0));
                result = st.render();
                fragmentMap.add("method:_init" + StrUtil.cap(role.getName()) + "()", result, 2, role.getModified());
            } else {
                fragmentMap.add("method:_init" + StrUtil.cap(role.getName()) + "()", "", 2, true);
            }
            st = group.getInstanceOf("getMethod");
            st.add("roleName", (Object)role.getName());
            st.add("toMany", (Object)(role.getCardinality() != 1 ? 1 : 0));
            st.add("otherClassName", (Object)role.getOther().getClazz().getName());
            st.add("roleType", (Object)roleType);
            result = st.render();
            fragmentMap.add("method:get" + StrUtil.cap(role.getName()) + "()", result, 2, role.getModified());
            st = group.getInstanceOf("setMethod");
            st.add("roleName", (Object)role.getName());
            st.add("toMany", (Object)(role.getCardinality() != 1 ? 1 : 0));
            st.add("myClassName", (Object)clazz.getName());
            st.add("otherClassName", (Object)role.getOther().getClazz().getName());
            st.add("otherRoleName", (Object)role.getOther().getName());
            st.add("otherToMany", (Object)(role.getOther().getCardinality() != 1 ? 1 : 0));
            st.add("roleType", (Object)roleType);
            result = st.render();
            String signature = "set";
            String paramType = role.getOther().getClazz().getName();
            if (role.getCardinality() != 1) {
                signature = "with";
                paramType = "Object...";
            }
            if ("JavaFX".equals(role.getPropertyStyle())) {
                if (role.getCardinality() != 1) {
                    oldSignature = "with" + StrUtil.cap(role.getName()) + "(" + paramType + ")";
                    fragmentMap.add("method:" + oldSignature, "", 3, true);
                }
                paramType = role.getOther().getClazz().getName();
            } else {
                oldSignature = "with" + StrUtil.cap(role.getName()) + "(" + role.getOther().getClazz().getName() + ")";
                fragmentMap.add("method:" + oldSignature, "", 3, true);
            }
            signature = signature + StrUtil.cap(role.getName()) + "(" + paramType + ")";
            fragmentMap.add("method:" + signature, result, 3, role.getModified());
            if (role.getCardinality() != 1) {
                st = group.getInstanceOf("withoutMethod");
                st.add("roleName", (Object)role.getName());
                st.add("toMany", (Object)(role.getCardinality() != 1 ? 1 : 0));
                st.add("myClassName", (Object)clazz.getName());
                st.add("otherClassName", (Object)role.getOther().getClazz().getName());
                st.add("otherRoleName", (Object)role.getOther().getName());
                st.add("otherToMany", (Object)(role.getOther().getCardinality() != 1 ? 1 : 0));
                st.add("roleType", (Object)roleType);
                result = st.render();
                paramType = "Object...";
                if ("JavaFX".equals(role.getPropertyStyle())) {
                    paramType = role.getOther().getClazz().getName();
                }
                fragmentMap.add("method:without" + StrUtil.cap(role.getName()) + "(" + paramType + ")", result, 3, role.getModified());
            }
            if ("JavaFX".equals(role.getPropertyStyle()) && role.getCardinality() == 1) {
                st = group.getInstanceOf("propertyMethod");
                st.add("roleName", (Object)role.getName());
                st.add("otherClassName", (Object)role.getOther().getClazz().getName());
                result = st.render();
                fragmentMap.add("method:" + role.getName() + "Property()", result, 3, role.getModified());
                continue;
            }
            fragmentMap.add("method:" + role.getName() + "Property()", "", 3, true);
        }
    }

    private void generateMethods(Clazz clazz, FileFragmentMap fragmentMap) {
        for (FMethod method : clazz.getMethods()) {
            String signature = method.readSignature();
            String methodBody = method.getMethodBody();
            if (methodBody == null) {
                methodBody = "      // hello world\n";
            }
            String newText = "   " + method.getDeclaration() + " { \n" + methodBody + "   }";
            fragmentMap.add(signature, newText, 2, method.getModified());
        }
    }

    private void generatePropertyChangeSupport(Clazz clazz, FileFragmentMap fragmentMap) {
        if (clazz.getAttributes().size() == 0 && clazz.getRoles().size() == 0) {
            return;
        }
        fragmentMap.add("import:java.beans.PropertyChangeSupport", "import java.beans.PropertyChangeSupport;", 1);
        fragmentMap.add("import:java.beans.PropertyChangeListener", "import java.beans.PropertyChangeListener;", 1);
        STGroup group = this.createSTGroup("templates/propertyChangeSupport.stg");
        String result = "   protected PropertyChangeSupport listeners = null;";
        fragmentMap.add("attribute:listeners", result, 2, clazz.getModified());
        ST st = group.getInstanceOf("firePropertyChange");
        result = st.render();
        fragmentMap.add("method:firePropertyChange(String,Object,Object)", result, 2, clazz.getModified());
        st = group.getInstanceOf("addPropertyChangeListener1");
        result = st.render();
        fragmentMap.add("method:addPropertyChangeListener(PropertyChangeListener)", result, 2, clazz.getModified());
        st = group.getInstanceOf("addPropertyChangeListener2");
        result = st.render();
        fragmentMap.add("method:addPropertyChangeListener(String,PropertyChangeListener)", result, 2, clazz.getModified());
        st = group.getInstanceOf("removePropertyChangeListener1");
        result = st.render();
        fragmentMap.add("method:removePropertyChangeListener(PropertyChangeListener)", result, 2, clazz.getModified());
        st = group.getInstanceOf("removePropertyChangeListener2");
        result = st.render();
        fragmentMap.add("method:removePropertyChangeListener(String,PropertyChangeListener)", result, 2, clazz.getModified());
    }

    private void generateToString(Clazz clazz, FileFragmentMap fragmentMap) {
        ArrayList<String> nameList = new ArrayList<String>();
        boolean modified = false;
        for (Attribute attr : clazz.getAttributes()) {
            if (attr.getType().equals("String")) {
                nameList.add(attr.getName());
            }
            if (!attr.getModified()) continue;
            modified = true;
        }
        String result = "";
        if (nameList.size() > 0) {
            STGroup group = this.createSTGroup("templates/toString.stg");
            ST st = group.getInstanceOf("toString");
            st.add("names", (Object)nameList.toArray(new String[0]));
            result = st.render();
        }
        fragmentMap.add("method:toString()", result, 2, modified);
    }

    private void generateRemoveYou(Clazz clazz, FileFragmentMap fragmentMap) {
        if (clazz.getRoles().size() == 0) {
            return;
        }
        ArrayList<String> toOneList = new ArrayList<String>();
        ArrayList<String> toManyList = new ArrayList<String>();
        ArrayList<String> toOneAggregationList = new ArrayList<String>();
        ArrayList<String> toManyAggregationList = new ArrayList<String>();
        ArrayList<String> toManyTypes = new ArrayList<String>();
        ArrayList<Boolean> javaFXStyles = new ArrayList<Boolean>();
        boolean modified = clazz.getModified();
        for (AssocRole role : clazz.getRoles()) {
            if (role.getName() == null) continue;
            if (role.getCardinality() == 1) {
                if (role.getAggregation()) {
                    toOneAggregationList.add(role.getName());
                    continue;
                }
                toOneList.add(role.getName());
                continue;
            }
            if (role.getAggregation()) {
                toManyAggregationList.add(role.getName());
                toManyTypes.add(role.getOther().getClazz().getName());
                continue;
            }
            toManyList.add(role.getName());
            javaFXStyles.add("JavaFX".equals(role.getPropertyStyle()));
        }
        String result = "";
        STGroup group = this.createSTGroup("templates/removeYou.stg");
        ST st = group.getInstanceOf("removeYou");
        st.add("toOneNames", (Object)toOneList.toArray(new String[0]));
        st.add("toManyNames", (Object)toManyList.toArray(new String[0]));
        st.add("toOneAggregations", (Object)toOneAggregationList.toArray(new String[0]));
        st.add("toManyAggregations", (Object)toManyAggregationList.toArray(new String[0]));
        st.add("toManyTypes", (Object)toManyTypes.toArray(new String[0]));
        st.add("javaFXStyles", (Object)javaFXStyles.toArray(new Boolean[0]));
        result = st.render();
        fragmentMap.add("method:removeYou()", result, 2, modified);
    }

    public String getCustomTemplatesFile() {
        return this.customTemplatesFile;
    }

    public Generator4ClassFile setCustomTemplatesFile(String customTemplateFile) {
        this.customTemplatesFile = customTemplateFile;
        return this;
    }

    private STGroup createSTGroup(String origFileName) {
        STGroupFile group;
        try {
            group = new STGroupFile(this.customTemplatesFile);
            STGroupFile origGroup = new STGroupFile(origFileName);
            group.importTemplates((STGroup)origGroup);
        }
        catch (Exception e) {
            group = new STGroupFile(origFileName);
        }
        group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        return group;
    }
}

