/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;

public class ModelListener
implements PropertyChangeListener {
    private HashSet<Object> supervisedObjects = new HashSet();
    private PropertyChangeListener elementListener;
    private Set<Object> componentElements = new LinkedHashSet<Object>();
    private ReflectorMap creatorMap;
    private boolean closed = false;

    public ModelListener(Object root, PropertyChangeListener elementListener) {
        this.elementListener = elementListener;
        String packageName = root.getClass().getPackage().getName();
        ArrayList<String> packageNameList = new ArrayList<String>();
        packageNameList.add(packageName);
        this.creatorMap = new ReflectorMap(packageNameList);
        this.subscribeTo(root);
    }

    public void removeYou() {
        this.closed = true;
        for (Object obj : this.supervisedObjects) {
            Class<?> clazz = obj.getClass();
            try {
                Method removePropertyChangeListener = clazz.getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                removePropertyChangeListener.invoke(obj, this);
            }
            catch (Exception exception) {}
        }
    }

    private void subscribeTo(Object newObject) {
        if (this.supervisedObjects.contains(newObject)) {
            return;
        }
        Class<?> clazz = newObject.getClass();
        try {
            Method addPropertyChangeListener = clazz.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            addPropertyChangeListener.invoke(newObject, this);
        }
        catch (Exception addPropertyChangeListener) {
            // empty catch block
        }
        this.supervisedObjects.add(newObject);
        Reflector reflector = this.creatorMap.getReflector(newObject);
        if (reflector == null) {
            return;
        }
        for (String prop : reflector.getProperties()) {
            Object newValue = reflector.getValue(newObject, prop);
            if (newValue instanceof Collection) {
                Collection newCollection = (Collection)newValue;
                Iterator iterator = newCollection.iterator();
                while (iterator.hasNext()) {
                    Object obj;
                    Object newEntity = obj = iterator.next();
                    PropertyChangeEvent event = new PropertyChangeEvent(newObject, prop, null, newEntity);
                    this.propertyChange(event);
                }
                continue;
            }
            PropertyChangeEvent event = new PropertyChangeEvent(newObject, prop, null, newValue);
            this.propertyChange(event);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue;
        if (this.closed) {
            return;
        }
        if (evt.getNewValue() != null && !this.supervisedObjects.contains(newValue = evt.getNewValue())) {
            this.subscribeTo(newValue);
        }
        this.elementListener.propertyChange(evt);
    }
}

