/*
 * Decompiled with CFR 0.152.
 */
package org.fulib;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.fulib.Parser;
import org.fulib.StrUtil;
import org.fulib.classmodel.CodeFragment;
import org.fulib.classmodel.FileFragmentMap;
import org.fulib.util.Token;

public class TypeScriptParser {
    public static final char EOF = '\u0000';
    public static final String CLASS = "class";
    public static char NEW_LINE = (char)10;
    public static final char COMMENT_START = 'c';
    public static final char LONG_COMMENT_END = 'd';
    public static final String GAP = "gap:";
    public static final String IMPORT = "import";
    private FileFragmentMap fragmentMap;
    private StringBuilder fileBody = null;
    private String fileName;
    private int indexOfResult;
    private char currentChar;
    private int index;
    private int lookAheadIndex;
    private int lastFragmentEndPos;
    private int endPos;
    private char lookAheadChar;
    private Token currentToken;
    private Token lookAheadToken;
    private Token previousToken;
    private String searchString;
    private Token currentRealToken;
    private Token lookAheadRealToken;
    private Token previousRealToken;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public TypeScriptParser withFileBody(StringBuilder fileBody) {
        this.fileBody = fileBody;
        return this;
    }

    public static FileFragmentMap parse(String classFileName) {
        return new TypeScriptParser().doParse(classFileName);
    }

    public FileFragmentMap doParse(String fileName) {
        this.setFileName(fileName);
        this.loadFile(fileName);
        if (this.fileBody != null) {
            this.indexOf("classEnd");
        }
        return this.fragmentMap;
    }

    private void loadFile(String fileName) {
        this.fragmentMap = new FileFragmentMap(fileName);
        Path path = Paths.get(fileName, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                byte[] bytes = Files.readAllBytes(path);
                this.withFileBody(new StringBuilder(new String(bytes)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private TypeScriptParser init(int startPos, int endPos) {
        this.currentChar = '\u0000';
        this.index = startPos - 1;
        this.lookAheadIndex = startPos - 1;
        this.lastFragmentEndPos = startPos - 1;
        this.endPos = endPos;
        this.nextChar();
        this.nextChar();
        this.currentToken = new Token();
        this.lookAheadToken = new Token();
        this.previousToken = new Token();
        this.nextToken();
        this.nextToken();
        this.currentRealToken = new Token();
        this.lookAheadRealToken = new Token();
        this.previousRealToken = new Token();
        this.nextRealToken();
        this.nextRealToken();
        return this;
    }

    public int indexOf(String searchString) {
        this.indexOfResult = -1;
        this.init(0, this.fileBody.length());
        this.searchString = searchString;
        try {
            this.parseFile();
        }
        catch (Parser.SearchStringFoundException searchStringFoundException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.indexOfResult;
    }

    private void parseFile() {
        int startPos = this.currentRealToken.startPos;
        while (this.currentRealTokenEquals(IMPORT)) {
            this.parseImport();
        }
        this.parseClassDecl();
    }

    private void parseImport() {
        int startPos = this.currentRealToken.startPos;
        this.nextRealToken();
        String importName = this.currentRealToken.text.toString();
        this.nextRealToken();
        if (this.currentRealTokenEquals("from")) {
            this.skip("from");
        }
        String moduleName = this.currentRealToken.text.toString();
        this.nextRealToken();
        this.skip(";");
        this.addCodeFragment("import:" + importName, startPos, this.previousRealToken.endPos);
    }

    private void parseClassDecl() {
        int startPos = this.currentRealToken.startPos;
        this.skip("export");
        this.skip("default");
        this.skip(CLASS);
        String className = this.currentRealWord();
        this.nextRealToken();
        this.addCodeFragment(CLASS, startPos, this.currentRealToken.endPos);
        this.parseClassBody();
    }

    private void parseClassBody() {
        this.skip("{");
        while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals('}')) {
            this.parseMemberDecl();
        }
        if (this.currentRealKindEquals('}')) {
            this.addCodeFragment("classEnd", this.currentRealToken.startPos, this.currentRealToken.endPos);
        }
        this.addCodeFragment(GAP, this.currentRealToken.endPos + 1, this.fileBody.length() - 1);
    }

    private void parseMemberDecl() {
        int startPos = this.currentRealToken.startPos;
        String modifiers = this.parseModifiers();
        String memberName = this.currentRealWord();
        this.nextRealToken();
        if ("get set".indexOf(memberName) >= 0) {
            memberName = memberName + " " + this.currentRealWord();
            this.nextRealToken();
        }
        if (this.currentRealTokenEquals(":")) {
            this.skip(":");
            String type = this.parseUntil(" ; ");
            this.skip(";");
            this.addCodeFragment("attribute:" + memberName, startPos, this.previousRealToken.endPos);
        } else if (this.currentRealTokenEquals("(")) {
            String paramSignature = this.parseParamDeclList();
            if (":".equals(this.currentRealWord())) {
                this.parseUntil(" { ");
            }
            this.parseUntilMatching("{", "}");
            this.addCodeFragment("method:" + memberName + paramSignature, startPos, this.previousRealToken.endPos);
        }
    }

    private String parseParamDeclList() {
        String signature = "(";
        this.skip("(");
        while (!this.currentRealKindEquals('\u0000') && !this.currentRealKindEquals(')')) {
            this.parseUntil(":");
            this.skip(":");
            String typeName = this.parseUntil(",)");
            signature = signature + typeName;
            if (!",".equals(this.currentRealWord())) continue;
            signature = signature + ",";
        }
        this.skip(")");
        signature = signature + ")";
        return signature;
    }

    private void parseUntilMatching(String openingBrace, String closingBrace) {
        this.skip(openingBrace);
        while (!this.currentRealKindEquals('\u0000')) {
            if (openingBrace.equals(this.currentRealWord())) {
                this.parseUntilMatching(openingBrace, closingBrace);
                continue;
            }
            if (closingBrace.equals(this.currentRealWord())) {
                this.skip(closingBrace);
                break;
            }
            this.nextRealToken();
        }
    }

    private String parseUntil(String stopTokens) {
        int startPos = this.currentRealToken.startPos;
        while (!this.currentRealKindEquals('\u0000') && stopTokens.indexOf(this.currentRealWord()) < 0) {
            this.nextRealToken();
        }
        String result = this.fileBody.substring(startPos, this.previousRealToken.endPos + 1);
        return result;
    }

    private String parseModifiers() {
        String result = "";
        String modifiers = " public protected private readonly ";
        while (modifiers.indexOf(" " + this.currentRealWord() + " ") >= 0) {
            result = result + this.currentRealWord() + " ";
            this.nextRealToken();
        }
        return result;
    }

    private boolean currentRealKindEquals(char c) {
        return this.currentRealToken.kind == c;
    }

    private String currentRealWord() {
        return this.currentRealToken.text.toString();
    }

    private boolean currentRealTokenEquals(String word) {
        return StrUtil.stringEquals(this.currentRealWord(), word);
    }

    private void skip(char c) {
        if (this.currentRealKindEquals(c)) {
            this.nextRealToken();
        } else {
            System.out.println("Parser Problem: '" + this.currentRealToken.kind + "' : but '" + c + "' expected in " + this.fileName + " at line " + this.getLineIndexOf(this.currentRealToken.startPos) + "\n" + this.getLineForPos(this.currentRealToken.startPos));
        }
    }

    private void skip(String string) {
        if (!this.currentRealTokenEquals(string)) {
            System.err.println("Parser Error: expected token " + string + " found " + this.currentRealWord() + " at pos " + this.currentRealToken.startPos + " at line " + this.getLineIndexOf(this.currentRealToken.startPos, this.fileBody) + " in file \n" + this.fileName);
            throw new RuntimeException("parse error");
        }
        this.nextRealToken();
    }

    public String getLineForPos(int currentInsertPos) {
        String part1 = this.fileBody.substring(0, currentInsertPos);
        String part2 = this.fileBody.substring(currentInsertPos);
        int startPos = 1 + part1.lastIndexOf("\n");
        int endPos = currentInsertPos + part2.indexOf("\n");
        String lineString = "\"" + this.fileBody.substring(startPos, endPos).toString() + "\"";
        int index = currentInsertPos - startPos;
        char[] chars1 = new char[index];
        Arrays.fill(chars1, ' ');
        String string1 = new String(chars1);
        String posString = "\n" + string1 + "^";
        return lineString + posString;
    }

    private long getLineIndexOf(int startPos, StringBuilder fileBody) {
        long count = 1L;
        String substring = fileBody.substring(0, startPos);
        for (int index = 0; index < substring.length() - 1; ++index) {
            char firstChar = substring.charAt(index);
            if (firstChar != NEW_LINE) continue;
            ++count;
        }
        return count;
    }

    public long getLineIndexOf(int startPos) {
        if (startPos < 0) {
            return -1L;
        }
        long count = 1L;
        String substring = this.fileBody.substring(0, startPos);
        for (int index = 0; index < substring.length() - 1; ++index) {
            char firstChar = substring.charAt(index);
            if (firstChar != NEW_LINE) continue;
            ++count;
        }
        return count;
    }

    private void nextRealToken() {
        Token tmp = this.previousRealToken;
        this.previousRealToken = this.currentRealToken;
        this.currentRealToken = this.lookAheadRealToken;
        this.lookAheadRealToken = tmp;
        this.lookAheadRealToken.kind = '\u0000';
        this.lookAheadRealToken.preCommentStartPos = 0;
        this.lookAheadRealToken.preCommentEndPos = 0;
        this.lookAheadRealToken.text.delete(0, this.lookAheadRealToken.text.length());
        while (this.currentToken.kind == 'c' || this.currentToken.kind == NEW_LINE) {
            if (this.currentToken.text.indexOf("//") == 0) {
                this.parseLineComment();
                continue;
            }
            this.nextToken();
        }
        if (this.currentToken.kind == '\"') {
            int constStartPos = this.currentToken.startPos;
            this.parseStringConstant();
            this.lookAheadRealToken.kind = (char)34;
            this.lookAheadRealToken.text.append(this.fileBody.substring(constStartPos, this.previousToken.startPos + 1));
            this.lookAheadRealToken.startPos = constStartPos;
            this.lookAheadRealToken.endPos = this.previousToken.startPos;
        } else if (this.currentToken.kind == '\'') {
            int constStartPos = this.currentToken.startPos;
            this.parseCharConstant();
            this.lookAheadRealToken.kind = (char)39;
            this.lookAheadRealToken.text.append(this.fileBody.substring(constStartPos, this.previousToken.startPos + 1));
            this.lookAheadRealToken.startPos = constStartPos;
            this.lookAheadRealToken.endPos = this.previousToken.startPos;
        } else if (this.currentToken.kind == '9') {
            this.lookAheadRealToken.kind = this.currentToken.kind;
            this.lookAheadRealToken.text.append((int)this.currentToken.value);
            this.lookAheadRealToken.startPos = this.currentToken.startPos;
            this.lookAheadRealToken.endPos = this.currentToken.endPos;
            this.nextToken();
        } else {
            this.lookAheadRealToken.kind = this.currentToken.kind;
            this.lookAheadRealToken.text.append(this.currentToken.text.toString());
            this.lookAheadRealToken.startPos = this.currentToken.startPos;
            this.lookAheadRealToken.endPos = this.currentToken.endPos;
            this.nextToken();
        }
    }

    private void parseLineComment() {
        this.lookAheadRealToken.preCommentStartPos = this.currentToken.startPos;
        this.nextToken();
        while (this.currentToken.kind != '\u0000' && this.currentToken.kind != '\n') {
            this.nextToken();
        }
        this.lookAheadRealToken.preCommentEndPos = this.currentToken.endPos;
        this.nextToken();
    }

    private void parseStringConstant() {
        this.skipBasicToken('\"');
        while (this.currentToken.kind != '\u0000' && this.currentToken.kind != '\"') {
            if (this.currentToken.kind == '\\') {
                this.nextToken();
            }
            this.nextToken();
        }
        this.skipBasicToken('\"');
    }

    private void parseCharConstant() {
        this.skipBasicToken('\'');
        if (this.currentToken.kind == '\\') {
            this.nextToken();
        }
        this.nextToken();
        this.skipBasicToken('\'');
    }

    private void skipBasicToken(char s) {
        if (this.currentToken.kind == s) {
            this.nextToken();
        }
    }

    private void nextToken() {
        Token tmp = this.previousToken;
        this.previousToken = this.currentToken;
        this.currentToken = this.lookAheadToken;
        this.lookAheadToken = tmp;
        this.lookAheadToken.kind = '\u0000';
        this.lookAheadToken.text.delete(0, this.lookAheadToken.text.length());
        int state = 105;
        while (true) {
            switch (state) {
                case 105: {
                    if (Character.isLetter(this.currentChar) || this.currentChar == '_') {
                        state = 118;
                        this.lookAheadToken.kind = (char)118;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.startPos = this.index;
                        break;
                    }
                    if (this.currentChar == '\u0000') {
                        this.lookAheadToken.kind = '\u0000';
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        return;
                    }
                    if (Character.isDigit(this.currentChar)) {
                        state = 57;
                        this.lookAheadToken.kind = (char)57;
                        this.lookAheadToken.value = this.currentChar - 48;
                        this.lookAheadToken.startPos = this.index;
                        break;
                    }
                    if (this.currentChar == '/' && (this.lookAheadChar == '*' || this.lookAheadChar == '/')) {
                        this.lookAheadToken.kind = (char)99;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (this.currentChar == '*' && this.lookAheadChar == '/') {
                        this.lookAheadToken.kind = (char)100;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if ("+-*/\\\"'~=()><{}!.,@[]&|?;:#".indexOf(this.currentChar) >= 0) {
                        this.lookAheadToken.kind = this.currentChar;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (this.currentChar == NEW_LINE) {
                        this.lookAheadToken.kind = NEW_LINE;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (!Character.isWhitespace(this.currentChar)) break;
                    break;
                }
                case 57: {
                    if (Character.isDigit(this.currentChar)) {
                        this.lookAheadToken.value = this.lookAheadToken.value * 10.0 + (double)(this.currentChar - 48);
                        break;
                    }
                    if (this.currentChar == '.') {
                        state = 56;
                        break;
                    }
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
                case 56: {
                    if (Character.isDigit(this.currentChar)) break;
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
                case 118: {
                    if (Character.isLetter(this.currentChar) || Character.isDigit(this.currentChar) || this.currentChar == '_') {
                        this.lookAheadToken.text.append(this.currentChar);
                        break;
                    }
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
            }
            this.nextChar();
        }
    }

    private void nextChar() {
        this.currentChar = this.lookAheadChar;
        this.index = this.lookAheadIndex;
        this.lookAheadChar = '\u0000';
        while (this.lookAheadChar == '\u0000' && this.lookAheadIndex < this.endPos - 1) {
            ++this.lookAheadIndex;
            this.lookAheadChar = this.fileBody.charAt(this.lookAheadIndex);
        }
    }

    private void addCodeFragment(String key, int startPos, int endPos) {
        if (endPos < startPos) {
            endPos = startPos - 1;
        }
        CodeFragment gap = new CodeFragment().setKey(GAP).setText(this.fileBody.substring(this.lastFragmentEndPos + 1, startPos));
        this.fragmentMap.add(gap);
        CodeFragment codeFragment = new CodeFragment().setKey(key).setText(this.fileBody.substring(startPos, endPos + 1));
        this.fragmentMap.add(codeFragment);
        this.lastFragmentEndPos = endPos;
    }
}

