/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor;

import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.ast.type.UnresolvedType;
import org.fulib.scenarios.visitor.ExtractClassDecl;

public enum TypeComparer implements Type.Visitor<Type, Result>
{
    INSTANCE;


    public static boolean equals(Type a, Type b) {
        return a.accept(INSTANCE, b) == Result.EQUAL;
    }

    @Override
    public Result visit(UnresolvedType unresolvedType, Type par) {
        return Result.UNRELATED;
    }

    @Override
    public Result visit(PrimitiveType primitiveType, Type par) {
        return primitiveType == par ? Result.EQUAL : Result.UNRELATED;
    }

    @Override
    public Result visit(ClassType classType, Type par) {
        ClassDecl classB;
        ClassDecl classA = classType.getClassDecl();
        return classA == (classB = par.accept(ExtractClassDecl.INSTANCE, null)) ? Result.EQUAL : Result.UNRELATED;
    }

    @Override
    public Result visit(ListType listType, Type par) {
        if (!(par instanceof ListType)) {
            return Result.UNRELATED;
        }
        Type elementTypeA = listType.getElementType();
        Type elementTypeB = ((ListType)par).getElementType();
        return elementTypeA.accept(this, elementTypeB);
    }

    public static enum Result {
        EQUAL,
        SUBTYPE,
        UNRELATED;

    }
}

