/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.ErrorExpr;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.access.ExampleAccess;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.call.CreationExpr;
import org.fulib.scenarios.ast.expr.collection.FilterExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.collection.MapAccessExpr;
import org.fulib.scenarios.ast.expr.collection.RangeExpr;
import org.fulib.scenarios.ast.expr.conditional.AttributeCheckExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperator;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperatorExpr;
import org.fulib.scenarios.ast.expr.conditional.PredicateOperatorExpr;
import org.fulib.scenarios.ast.expr.primary.AnswerLiteral;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.expr.primary.StringLiteral;
import org.fulib.scenarios.ast.scope.DelegatingScope;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.visitor.ExtractClassDecl;
import org.fulib.scenarios.visitor.Namer;
import org.fulib.scenarios.visitor.Typer;
import org.fulib.scenarios.visitor.resolve.DeclResolver;
import org.fulib.scenarios.visitor.resolve.SentenceResolver;
import org.fulib.scenarios.visitor.resolve.TypeResolver;

public enum ExprResolver implements Expr.Visitor<Scope, Expr>
{
    INSTANCE;


    @Override
    public Expr visit(Expr expr, Scope par) {
        return expr;
    }

    @Override
    public Expr visit(AttributeAccess attributeAccess, Scope par) {
        Expr receiver = attributeAccess.getReceiver().accept(this, par);
        attributeAccess.setReceiver(receiver);
        Type receiverType = receiver.accept(Typer.INSTANCE, null);
        if (receiverType instanceof ListType) {
            Type elementType = ((ListType)receiverType).getElementType();
            Name resolvedName = DeclResolver.getAttributeOrAssociation(par, elementType, attributeAccess.getName());
            return MapAccessExpr.of(resolvedName, receiver);
        }
        attributeAccess.setName(DeclResolver.getAttributeOrAssociation(par, receiver, attributeAccess.getName()));
        return attributeAccess;
    }

    @Override
    public Expr visit(ExampleAccess exampleAccess, Scope par) {
        exampleAccess.setExpr(exampleAccess.getExpr().accept(this, par));
        return exampleAccess;
    }

    @Override
    public Expr visit(FilterExpr filterExpr, Scope par) {
        Expr source = filterExpr.getSource().accept(this, par);
        filterExpr.setSource(source);
        Type sourceType = source.accept(Typer.INSTANCE, null);
        Type elementType = ((ListType)sourceType).getElementType();
        final VarDecl it = VarDecl.of("it", elementType, null);
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                return "<predicate-receiver>".equals(name) ? it : super.resolve(name);
            }
        };
        filterExpr.setPredicate((ConditionalExpr)filterExpr.getPredicate().accept(this, scope));
        return filterExpr;
    }

    @Override
    public Expr visit(AnswerLiteral answerLiteral, Scope par) {
        Decl answerVar = par.resolve("<answer-var>");
        if (answerVar == null) {
            par.report(Marker.error(answerLiteral.getPosition(), "answer.unresolved", new Object[0]));
            return ErrorExpr.of(PrimitiveType.ERROR);
        }
        return NameAccess.of(ResolvedName.of(answerVar));
    }

    @Override
    public Expr visit(NameAccess nameAccess, Scope par) {
        if (nameAccess.getName() instanceof UnresolvedName) {
            UnresolvedName unresolvedName = (UnresolvedName)nameAccess.getName();
            String unresolvedValue = unresolvedName.getValue();
            Decl target = par.resolve(unresolvedValue);
            if (target == null) {
                StringLiteral stringLiteral = StringLiteral.of(unresolvedName.getText());
                stringLiteral.setPosition(unresolvedName.getPosition());
                return stringLiteral;
            }
            nameAccess.setName(ResolvedName.of(target));
        }
        return nameAccess;
    }

    @Override
    public Expr visit(CreationExpr creationExpr, Scope par) {
        creationExpr.setType(creationExpr.getType().accept(TypeResolver.INSTANCE, par));
        ClassDecl classDecl = creationExpr.getType().accept(ExtractClassDecl.INSTANCE, null);
        for (NamedExpr namedExpr : creationExpr.getAttributes()) {
            namedExpr.setExpr(namedExpr.getExpr().accept(this, par));
            namedExpr.setName(DeclResolver.resolveAttributeOrAssociation(par, classDecl, namedExpr.getName(), namedExpr.getExpr()));
        }
        return creationExpr;
    }

    @Override
    public Expr visit(CallExpr callExpr, Scope par) {
        List<NamedExpr> arguments = callExpr.getArguments();
        Expr receiver = callExpr.getReceiver();
        if (receiver != null) {
            receiver = receiver.accept(this, par);
        } else {
            Decl thisDecl = par.resolve("this");
            receiver = NameAccess.of(ResolvedName.of(thisDecl));
        }
        callExpr.setReceiver(receiver);
        for (NamedExpr argument : arguments) {
            argument.setExpr(argument.getExpr().accept(this, par));
        }
        Type receiverType = callExpr.getReceiver().accept(Typer.INSTANCE, null);
        ClassDecl receiverClass = receiverType.accept(ExtractClassDecl.INSTANCE, null);
        String methodName = callExpr.getName().accept(Namer.INSTANCE, null);
        MethodDecl method = DeclResolver.resolveMethod(par, callExpr.getName().getPosition(), receiverClass, methodName);
        List<ParameterDecl> parameters = method.getParameters();
        boolean isNew = method.getParameters().isEmpty();
        final HashMap<String, ParameterDecl> decls = new HashMap<String, ParameterDecl>();
        callExpr.setName(ResolvedName.of(method));
        if (isNew) {
            ParameterDecl thisParam = ParameterDecl.of(method, "this", receiverClass.getType());
            parameters.add(thisParam);
            decls.put("this", thisParam);
        } else {
            decls.put("this", parameters.get(0));
            String params = parameters.stream().skip(1L).map(ParameterDecl::getName).collect(Collectors.joining(" "));
            String args = arguments.stream().map(NamedExpr::getName).map(n -> n.accept(Namer.INSTANCE, null)).collect(Collectors.joining(" "));
            if (!params.equals(args)) {
                Marker error = Marker.error(callExpr.getPosition(), "call.mismatch.params.args", receiverClass.getName(), methodName, params, args);
                Marker note = DeclResolver.firstDeclaration(method.getPosition(), method.getOwner(), method.getName());
                par.report(error.note(note));
            }
        }
        String receiverName = receiver.accept(Namer.INSTANCE, null);
        if (receiverName != null) {
            decls.put(receiverName, parameters.get(0));
        }
        for (int i = 0; i < arguments.size(); ++i) {
            ParameterDecl param;
            NamedExpr argument = arguments.get(i);
            String name = argument.getName().accept(Namer.INSTANCE, null);
            Expr expr = argument.getExpr();
            if (isNew) {
                Type type = expr.accept(Typer.INSTANCE, null);
                param = ParameterDecl.of(method, name, type);
                parameters.add(param);
            } else {
                param = parameters.get(i + 1);
            }
            argument.setName(ResolvedName.of(param));
            decls.put(name, param);
            String exprName = expr.accept(Namer.INSTANCE, null);
            if (exprName == null) continue;
            decls.put(exprName, param);
        }
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                Decl decl = (Decl)decls.get(name);
                return decl != null ? decl : super.resolve(name);
            }
        };
        callExpr.getBody().accept(SentenceResolver.INSTANCE, scope);
        if (method.getType() == null) {
            Type returnType = callExpr.accept(Typer.INSTANCE, null);
            method.setType(returnType);
        }
        method.getBody().getItems().addAll(callExpr.getBody().getItems());
        return callExpr;
    }

    @Override
    public Expr visit(AttributeCheckExpr attributeCheckExpr, Scope par) {
        Expr receiver = attributeCheckExpr.getReceiver();
        Expr expected = attributeCheckExpr.getValue();
        Name attribute = attributeCheckExpr.getAttribute();
        AttributeAccess access = AttributeAccess.of(attribute, receiver);
        ConditionalOperatorExpr condOp = ConditionalOperatorExpr.of(access, ConditionalOperator.IS, expected);
        return condOp.accept(this, par);
    }

    @Override
    public Expr visit(ConditionalOperatorExpr conditionalOperatorExpr, Scope par) {
        Expr rhs = conditionalOperatorExpr.getRhs().accept(this, par);
        conditionalOperatorExpr.setRhs(rhs);
        Expr lhs = conditionalOperatorExpr.getLhs();
        if (lhs != null) {
            conditionalOperatorExpr.setLhs(lhs.accept(this, par));
        } else {
            Decl predicateReceiver = par.resolve("<predicate-receiver>");
            if (predicateReceiver == null) {
                par.report(Marker.error(conditionalOperatorExpr.getPosition(), "conditional.lhs.missing", new Object[0]));
                conditionalOperatorExpr.setLhs(ErrorExpr.of(rhs.accept(Typer.INSTANCE, null)));
            } else {
                conditionalOperatorExpr.setLhs(NameAccess.of(ResolvedName.of(predicateReceiver)));
            }
        }
        return conditionalOperatorExpr;
    }

    @Override
    public Expr visit(PredicateOperatorExpr predicateOperatorExpr, Scope par) {
        Expr lhs = predicateOperatorExpr.getLhs();
        if (lhs != null) {
            predicateOperatorExpr.setLhs(lhs.accept(this, par));
        } else {
            Decl predicateReceiver = par.resolve("<predicate-receiver>");
            if (predicateReceiver == null) {
                par.report(Marker.error(predicateOperatorExpr.getPosition(), "predicate.lhs.missing", new Object[0]));
                predicateOperatorExpr.setLhs(ErrorExpr.of(null));
            } else {
                predicateOperatorExpr.setLhs(NameAccess.of(ResolvedName.of(predicateReceiver)));
            }
        }
        return predicateOperatorExpr;
    }

    @Override
    public Expr visit(ListExpr listExpr, Scope par) {
        listExpr.getElements().replaceAll(it -> it.accept(this, par));
        return listExpr;
    }

    @Override
    public Expr visit(RangeExpr rangeExpr, Scope par) {
        rangeExpr.setStart(rangeExpr.getStart().accept(this, par));
        rangeExpr.setEnd(rangeExpr.getEnd().accept(this, par));
        return rangeExpr;
    }
}

