/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;
import org.fulib.scenarios.ast.scope.DelegatingScope;
import org.fulib.scenarios.ast.scope.HidingScope;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.sentence.AddSentence;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.AssignSentence;
import org.fulib.scenarios.ast.sentence.ConditionalSentence;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.ExpectSentence;
import org.fulib.scenarios.ast.sentence.ExprSentence;
import org.fulib.scenarios.ast.sentence.FlattenSentenceList;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.RemoveSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.TakeSentence;
import org.fulib.scenarios.ast.sentence.TemplateSentence;
import org.fulib.scenarios.ast.sentence.WriteSentence;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.visitor.ExtractClassDecl;
import org.fulib.scenarios.visitor.ExtractDecl;
import org.fulib.scenarios.visitor.Namer;
import org.fulib.scenarios.visitor.Typer;
import org.fulib.scenarios.visitor.describe.TypeDescriber;
import org.fulib.scenarios.visitor.resolve.AddResolve;
import org.fulib.scenarios.visitor.resolve.AssignmentResolve;
import org.fulib.scenarios.visitor.resolve.DeclResolver;
import org.fulib.scenarios.visitor.resolve.ExprResolver;
import org.fulib.scenarios.visitor.resolve.NameResolver;
import org.fulib.scenarios.visitor.resolve.RemoveResolve;
import org.fulib.scenarios.visitor.resolve.SymbolCollector;

public enum SentenceResolver implements Sentence.Visitor<Scope, Sentence>
{
    INSTANCE;


    @Override
    public Sentence visit(SentenceList sentenceList, Scope par) {
        final HashMap decls = new HashMap();
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                Decl decl = (Decl)decls.get(name);
                return decl != null ? decl : super.resolve(name);
            }

            @Override
            public void add(Decl decl) {
                if (decl instanceof VarDecl) {
                    decls.put(decl.getName(), decl);
                    return;
                }
                super.add(decl);
            }
        };
        List<Sentence> oldItems = sentenceList.getItems();
        ArrayList<Sentence> newItems = new ArrayList<Sentence>(oldItems.size());
        for (Sentence item : oldItems) {
            Sentence resolved = item.accept(this, scope);
            resolved.accept(SymbolCollector.INSTANCE, decls);
            FlattenSentenceList.add(newItems, resolved);
        }
        sentenceList.setItems(newItems);
        return sentenceList;
    }

    @Override
    public Sentence visit(ExpectSentence expectSentence, Scope par) {
        expectSentence.getPredicates().replaceAll(it -> (ConditionalExpr)it.accept(ExprResolver.INSTANCE, par));
        return expectSentence;
    }

    @Override
    public Sentence visit(DiagramSentence diagramSentence, Scope par) {
        diagramSentence.setObject(diagramSentence.getObject().accept(ExprResolver.INSTANCE, par));
        return diagramSentence;
    }

    @Override
    public Sentence visit(HasSentence hasSentence, Scope par) {
        Expr receiver = hasSentence.getObject().accept(ExprResolver.INSTANCE, par);
        hasSentence.setObject(receiver);
        Type receiverType = receiver.accept(Typer.INSTANCE, null);
        ClassDecl receiverClass = receiverType.accept(ExtractClassDecl.INSTANCE, null);
        if (receiverClass == null) {
            par.report(Marker.error(receiver.getPosition(), "has.subject.primitive", receiverType.accept(TypeDescriber.INSTANCE, null)));
            return hasSentence;
        }
        String receiverName = receiver.accept(Namer.INSTANCE, null);
        Scope scope = receiverName != null ? new HidingScope(receiverName, par) : par;
        for (NamedExpr namedExpr : hasSentence.getClauses()) {
            this.resolveHasNamedExpr(namedExpr, receiverClass, scope);
        }
        return hasSentence;
    }

    private void resolveHasNamedExpr(NamedExpr namedExpr, ClassDecl objectClass, Scope scope) {
        int otherCardinality;
        Name name = namedExpr.getName();
        Name otherName = namedExpr.getOtherName();
        Expr expr = namedExpr.getExpr().accept(ExprResolver.INSTANCE, scope);
        namedExpr.setExpr(expr);
        if (otherName == null) {
            namedExpr.setName(DeclResolver.resolveAttributeOrAssociation(scope, objectClass, name, expr));
            return;
        }
        String assocName = name.accept(Namer.INSTANCE, null);
        Type exprType = expr.accept(Typer.INSTANCE, scope);
        int cardinality = exprType instanceof ListType ? 42 : 1;
        ClassDecl otherClass = exprType.accept(ExtractClassDecl.INSTANCE, null);
        String otherAssocName = otherName.accept(Namer.INSTANCE, null);
        int n = otherCardinality = namedExpr.getOtherMany() ? 42 : 1;
        if (otherClass == null) {
            scope.report(Marker.error(otherName.getPosition(), "attribute.reverse.name", otherAssocName, objectClass.getName(), assocName));
            return;
        }
        AssociationDecl assoc = DeclResolver.resolveAssociation(scope, objectClass, assocName, cardinality, otherClass, otherAssocName, otherCardinality, name.getPosition(), otherName.getPosition());
        if (assoc != null) {
            AssociationDecl other = assoc.getOther();
            namedExpr.setName(ResolvedName.of(assoc));
            if (other != null) {
                namedExpr.setOtherName(ResolvedName.of(other));
            }
        }
    }

    @Override
    public Sentence visit(IsSentence isSentence, Scope par) {
        VarDecl varDecl = isSentence.getDescriptor();
        Expr expr = varDecl.getExpr().accept(ExprResolver.INSTANCE, par);
        Type exprType = expr.accept(Typer.INSTANCE, null);
        if (exprType == PrimitiveType.VOID) {
            return ExprSentence.of(expr);
        }
        String name = varDecl.getName();
        if (name == null) {
            name = expr.accept(Namer.INSTANCE, null);
        } else if (name.contains("++")) {
            name = SentenceResolver.findUnique(name, par);
        }
        Decl existing = par.resolve(name);
        if (existing != varDecl && existing instanceof VarDecl) {
            return AssignSentence.of((VarDecl)existing, expr);
        }
        varDecl.setName(name);
        varDecl.setExpr(expr);
        if (varDecl.getType() == null) {
            varDecl.setType(exprType);
        }
        return isSentence;
    }

    private static String findUnique(String name, Scope par) {
        int index = name.indexOf("++");
        String prefix = name.substring(0, index);
        String suffix = name.substring(index + 2);
        int i = 1;
        String numbered;
        while (par.resolve(numbered = prefix + i + suffix) != null) {
            ++i;
        }
        return numbered;
    }

    @Override
    public Sentence visit(AnswerSentence answerSentence, Scope par) {
        if (answerSentence.getActor() != null) {
            answerSentence.setActor(answerSentence.getActor().accept(NameResolver.INSTANCE, par));
        }
        answerSentence.setResult(answerSentence.getResult().accept(ExprResolver.INSTANCE, par));
        return answerSentence;
    }

    private Sentence resolveAssignment(Sentence original, Scope par, Expr source, Expr target, Expr.Visitor<Expr, Sentence> resolve, String code) {
        Sentence sentence = target.accept(resolve, source);
        if (sentence != null) {
            return sentence.accept(this, par);
        }
        par.report(Marker.error(original.getPosition(), code, target.getClass().getEnclosingClass().getSimpleName()));
        return original;
    }

    @Override
    public Sentence visit(WriteSentence writeSentence, Scope par) {
        Expr source = writeSentence.getSource();
        Expr target = writeSentence.getTarget();
        return this.resolveAssignment(writeSentence, par, source, target, AssignmentResolve.INSTANCE, "write.target.invalid");
    }

    @Override
    public Sentence visit(AddSentence addSentence, Scope par) {
        Expr source = addSentence.getSource().accept(ExprResolver.INSTANCE, par);
        Expr target = addSentence.getTarget();
        return this.resolveAssignment(addSentence, par, source, target, AddResolve.INSTANCE, "add.target.invalid");
    }

    @Override
    public Sentence visit(RemoveSentence removeSentence, Scope par) {
        Expr source = removeSentence.getSource().accept(ExprResolver.INSTANCE, par);
        Expr target = removeSentence.getTarget();
        return this.resolveAssignment(removeSentence, par, source, target, RemoveResolve.INSTANCE, "remove.target.invalid");
    }

    @Override
    public Sentence visit(TakeSentence takeSentence, Scope par) {
        Type type;
        String exampleName;
        Expr example = takeSentence.getExample();
        if (example != null) {
            example = example.accept(ExprResolver.INSTANCE, par);
            exampleName = example.accept(Namer.INSTANCE, null);
            takeSentence.setExample(example);
        } else {
            exampleName = null;
        }
        Expr collection = takeSentence.getCollection().accept(ExprResolver.INSTANCE, par);
        takeSentence.setCollection(collection);
        Type listType = collection.accept(Typer.INSTANCE, par);
        if (listType instanceof ListType) {
            type = ((ListType)listType).getElementType();
        } else {
            if (listType != PrimitiveType.ERROR) {
                par.report(Marker.error(collection.getPosition(), "take.source.type", listType.accept(TypeDescriber.INSTANCE, null)));
            }
            type = PrimitiveType.ERROR;
        }
        final VarDecl varDecl = SentenceResolver.resolveVar(takeSentence, par, exampleName, type);
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                return name.equals(varDecl.getName()) || name.equals(exampleName) ? varDecl : super.resolve(name);
            }
        };
        takeSentence.setActions((SentenceList)takeSentence.getActions().accept(this, scope));
        return takeSentence;
    }

    private static VarDecl resolveVar(TakeSentence takeSentence, Scope par, String exampleName, Type type) {
        String varName;
        Name name = takeSentence.getVarName();
        if (name != null) {
            Decl decl = name.accept(ExtractDecl.INSTANCE, null);
            if (decl != null) {
                return (VarDecl)decl;
            }
            varName = name.accept(Namer.INSTANCE, null);
        } else {
            varName = exampleName != null ? exampleName : SentenceResolver.findUnique("i++", par);
        }
        VarDecl varDecl = VarDecl.of(varName, type, null);
        takeSentence.setVarName(ResolvedName.of(varDecl));
        return varDecl;
    }

    @Override
    public Sentence visit(ConditionalSentence conditionalSentence, Scope par) {
        conditionalSentence.setCondition((ConditionalExpr)conditionalSentence.getCondition().accept(ExprResolver.INSTANCE, par));
        conditionalSentence.setActions((SentenceList)conditionalSentence.getActions().accept(this, par));
        return conditionalSentence;
    }

    @Override
    public Sentence visit(AssignSentence assignSentence, Scope par) {
        assignSentence.setValue(assignSentence.getValue().accept(ExprResolver.INSTANCE, par));
        return assignSentence;
    }

    @Override
    public Sentence visit(ExprSentence exprSentence, Scope par) {
        exprSentence.setExpr(exprSentence.getExpr().accept(ExprResolver.INSTANCE, par));
        return exprSentence;
    }

    @Override
    public Sentence visit(TemplateSentence templateSentence, Scope par) {
        templateSentence.getExprs().replaceAll(it -> it.accept(ExprResolver.INSTANCE, par));
        return templateSentence;
    }
}

