/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.YamlObject;
import org.fulib.yaml.YamlObjectReflector;

public class ReflectorMap {
    Map<String, Reflector> reflectorMap = new LinkedHashMap<String, Reflector>();
    private ArrayList<String> packageNames;
    private Class eObject = null;

    public ReflectorMap(String packageName) {
        ArrayList<String> packageNames = new ArrayList<String>();
        packageNames.add(packageName);
        this.packageNames = packageNames;
        try {
            this.eObject = Class.forName("org.eclipse.emf.ecore.EClass");
            Logger.getGlobal().log(Level.INFO, "could load org.eclipse.emf.ecore.EClass");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public ReflectorMap(ArrayList<String> packageNames) {
        this.packageNames = packageNames;
        try {
            this.eObject = ClassLoader.getSystemClassLoader().loadClass("org.eclipse.emf.ecore.EObject");
            Logger.getGlobal().log(Level.INFO, "could load org.eclipse.emf.ecore.EObject");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public Reflector getReflector(Object newObject) {
        if (newObject instanceof YamlObject) {
            return new YamlObjectReflector(newObject);
        }
        String simpleName = newObject.getClass().getSimpleName();
        String fullName = newObject.getClass().getName();
        String packageName = newObject.getClass().getPackage().getName();
        if (this.packageNames.contains(packageName)) {
            Reflector reflector = this.reflectorMap.get(simpleName);
            if (reflector == null) {
                reflector = new Reflector().setClassName(fullName).setClazz(newObject.getClass());
                this.reflectorMap.put(simpleName, reflector);
            }
            return reflector;
        }
        return this.getReflector(simpleName);
    }

    public Reflector getReflector(String clazzName) {
        Reflector reflector = this.reflectorMap.get(clazzName);
        if (reflector != null) {
            return reflector;
        }
        for (String packageName : this.packageNames) {
            String fullClassName = packageName + "." + clazzName;
            try {
                Class<?> theClass = Class.forName(fullClassName);
                if (theClass == null) continue;
                reflector = new Reflector().setClassName(fullClassName);
                this.reflectorMap.put(clazzName, reflector);
                return reflector;
            }
            catch (Exception e) {
                if (this.eObject == null) continue;
                try {
                    fullClassName = packageName + ".impl." + clazzName;
                    Class<?> theClass = Class.forName(fullClassName);
                    if (theClass == null) continue;
                    reflector = new Reflector().setClassName(fullClassName).setUseEMF();
                    this.reflectorMap.put(clazzName, reflector);
                    return reflector;
                }
                catch (Exception e2) {
                    reflector = null;
                }
            }
        }
        if (reflector == null) {
            String packagesString = "";
            for (String name : this.packageNames) {
                packagesString = packagesString + "   " + name + "\n";
            }
            throw new RuntimeException("ReflectorMap could not find class description for " + clazzName + "\nsearching in \n" + packagesString + "You might add more packages to the construction of the ReflectorMap / YamlIdMap \nor you might move the missing class into the common model package.");
        }
        return reflector;
    }
}

