/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.preprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.fulib.StrUtil;
import org.fulib.scenarios.ast.CompilationContext;
import org.fulib.scenarios.ast.MultiDescriptor;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.call.CreationExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.sentence.AreSentence;
import org.fulib.scenarios.ast.sentence.CallSentence;
import org.fulib.scenarios.ast.sentence.ConditionalSentence;
import org.fulib.scenarios.ast.sentence.CreateSentence;
import org.fulib.scenarios.ast.sentence.ExprSentence;
import org.fulib.scenarios.ast.sentence.FlattenSentenceList;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.SectionSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.TakeSentence;
import org.fulib.scenarios.ast.sentence.TemplateSentence;
import org.fulib.scenarios.ast.sentence.ThereSentence;
import org.fulib.scenarios.ast.sentence.WriteSentence;
import org.fulib.scenarios.visitor.Namer;

public enum Desugar implements CompilationContext.Visitor<Object, Object>,
ScenarioGroup.Visitor<Object, Object>,
ScenarioFile.Visitor<Object, Object>,
Scenario.Visitor<Object, Object>,
Sentence.Visitor<Object, Sentence>
{
    INSTANCE;


    @Override
    public Object visit(CompilationContext compilationContext, Object par) {
        compilationContext.getGroups().values().parallelStream().forEach(it -> it.accept(this, null));
        return null;
    }

    @Override
    public Object visit(ScenarioGroup scenarioGroup, Object par) {
        for (ScenarioFile file : scenarioGroup.getFiles().values()) {
            file.accept(this, par);
        }
        return null;
    }

    @Override
    public Object visit(ScenarioFile scenarioFile, Object par) {
        for (Scenario scenario : scenarioFile.getScenarios().values()) {
            scenario.accept(this, par);
        }
        return null;
    }

    @Override
    public Object visit(Scenario scenario, Object par) {
        scenario.setBody((SentenceList)scenario.getBody().accept(this, par));
        return null;
    }

    @Override
    public Sentence visit(Sentence sentence, Object par) {
        return sentence;
    }

    @Override
    public Sentence visit(SentenceList sentenceList, Object par) {
        List<Sentence> oldItems = sentenceList.getItems();
        ArrayList<Sentence> newItems = new ArrayList<Sentence>(oldItems.size());
        for (Sentence sentence : oldItems) {
            Sentence result = sentence.accept(this, par);
            FlattenSentenceList.add(newItems, result);
        }
        sentenceList.setItems(newItems);
        return sentenceList;
    }

    @Override
    public Sentence visit(SectionSentence sectionSentence, Object par) {
        String processedComment = sectionSentence.getLevel().format(sectionSentence.getText().trim());
        return TemplateSentence.of(processedComment, Collections.emptyList());
    }

    @Override
    public Sentence visit(ThereSentence thereSentence, Object par) {
        ArrayList<Sentence> result = new ArrayList<Sentence>();
        for (MultiDescriptor multiDesc : thereSentence.getDescriptors()) {
            Desugar.expand(multiDesc, result);
        }
        return new FlattenSentenceList(result);
    }

    @Override
    public Sentence visit(AreSentence areSentence, Object par) {
        return Desugar.expand(areSentence.getDescriptor());
    }

    @Override
    public Sentence visit(CreateSentence createSentence, Object par) {
        return Desugar.expand(createSentence.getDescriptor());
    }

    @Override
    public Sentence visit(CallSentence callSentence, Object par) {
        CallExpr call = callSentence.getCall();
        call.setBody((SentenceList)call.getBody().accept(this, par));
        String name = call.accept(Namer.INSTANCE, null);
        if (name == null) {
            return ExprSentence.of(call);
        }
        return WriteSentence.of(callSentence.getActor(), call, NameAccess.of(UnresolvedName.of(name, null)));
    }

    @Override
    public Sentence visit(TakeSentence takeSentence, Object par) {
        takeSentence.setBody(takeSentence.getBody().accept(this, par));
        return takeSentence;
    }

    @Override
    public Sentence visit(ConditionalSentence conditionalSentence, Object par) {
        conditionalSentence.setBody(conditionalSentence.getBody().accept(this, par));
        return conditionalSentence;
    }

    private static Sentence expand(MultiDescriptor descriptor) {
        ArrayList<Sentence> result = new ArrayList<Sentence>();
        Desugar.expand(descriptor, result);
        return new FlattenSentenceList(result);
    }

    private static void expand(MultiDescriptor multiDesc, List<Sentence> result) {
        List<String> names = Desugar.getNames(multiDesc);
        ArrayList<VarDecl> varDecls = new ArrayList<VarDecl>(names.size());
        for (String name : names) {
            CreationExpr expr = CreationExpr.of(multiDesc.getType(), Collections.emptyList());
            VarDecl varDecl = VarDecl.of(name, null, expr);
            varDecls.add(varDecl);
            result.add(IsSentence.of(varDecl));
        }
        for (NamedExpr attribute : multiDesc.getAttributes()) {
            List<Expr> elements;
            Name attributeName = attribute.getName();
            Expr attributeExpr = attribute.getExpr();
            if (names.size() == 1) {
                NameAccess object = NameAccess.of(ResolvedName.of((Decl)varDecls.get(0)));
                HasSentence hasSentence = HasSentence.of(object, Collections.singletonList(attribute));
                result.add(hasSentence);
                continue;
            }
            if (attributeExpr instanceof ListExpr && (elements = ((ListExpr)attributeExpr).getElements()).size() == names.size()) {
                for (int i = 0; i < names.size(); ++i) {
                    NameAccess object = NameAccess.of(ResolvedName.of((Decl)varDecls.get(i)));
                    NamedExpr partialAttribute = NamedExpr.of(attributeName, elements.get(i));
                    HasSentence hasSentence = HasSentence.of(object, Collections.singletonList(partialAttribute));
                    result.add(hasSentence);
                }
                continue;
            }
            VarDecl temp = VarDecl.of("temp++", null, attributeExpr);
            result.add(IsSentence.of(temp));
            for (int i = 0; i < names.size(); ++i) {
                NameAccess object = NameAccess.of(ResolvedName.of((Decl)varDecls.get(i)));
                NameAccess tempAccess = NameAccess.of(ResolvedName.of(temp));
                NamedExpr partialAttribute = NamedExpr.of(attributeName, tempAccess);
                HasSentence hasSentence = HasSentence.of(object, Collections.singletonList(partialAttribute));
                result.add(hasSentence);
            }
        }
    }

    private static List<String> getNames(MultiDescriptor multiDesc) {
        List<String> names = multiDesc.getNames();
        if (!names.isEmpty()) {
            return names;
        }
        for (NamedExpr attribute : multiDesc.getAttributes()) {
            if (attribute.getExpr() instanceof ListExpr) {
                List<Expr> elements = ((ListExpr)attribute.getExpr()).getElements();
                List<String> potentialNames = elements.stream().map(it -> it.accept(Namer.INSTANCE, null)).collect(Collectors.toList());
                if (potentialNames.contains(null)) continue;
                return potentialNames;
            }
            String potentialName = attribute.getExpr().accept(Namer.INSTANCE, null);
            if (potentialName == null) continue;
            return Collections.singletonList(potentialName);
        }
        String className = multiDesc.getType().accept(Namer.INSTANCE, null);
        String objectName = StrUtil.downFirstChar(className);
        return Collections.singletonList(objectName);
    }
}

