/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.preprocess;

import java.util.ArrayList;
import java.util.List;
import org.fulib.scenarios.ast.CompilationContext;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.sentence.ActorSentence;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.CallSentence;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.ExpectSentence;
import org.fulib.scenarios.ast.sentence.SectionSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.ThereSentence;
import org.fulib.scenarios.visitor.Namer;
import org.fulib.scenarios.visitor.preprocess.Frame;
import org.fulib.scenarios.visitor.preprocess.TopFrame;

public enum Grouper implements CompilationContext.Visitor<Object, Object>,
ScenarioGroup.Visitor<Object, Object>,
ScenarioFile.Visitor<Object, Object>,
Scenario.Visitor<Object, Object>,
Sentence.Visitor<Frame, Frame>
{
    INSTANCE;

    private static String ACTOR_TEST;

    private static String actorKey(Name name) {
        return name == null ? ACTOR_TEST : "actor:" + name.accept(Namer.INSTANCE, null) + ",";
    }

    @Override
    public Object visit(CompilationContext compilationContext, Object par) {
        compilationContext.getGroups().values().parallelStream().forEach(it -> it.accept(this, null));
        return null;
    }

    @Override
    public Object visit(ScenarioGroup scenarioGroup, Object par) {
        for (ScenarioFile file : scenarioGroup.getFiles().values()) {
            file.accept(this, par);
        }
        return null;
    }

    @Override
    public Object visit(ScenarioFile scenarioFile, Object par) {
        for (Scenario scenario : scenarioFile.getScenarios().values()) {
            scenario.accept(this, par);
        }
        return null;
    }

    @Override
    public Object visit(Scenario scenario, Object par) {
        TopFrame top = new TopFrame();
        top.file = scenario.getFile();
        top.key = ACTOR_TEST;
        top.target = new ArrayList();
        scenario.getBody().accept(this, top);
        scenario.getBody().setItems(top.target);
        return null;
    }

    @Override
    public Frame visit(Sentence sentence, Frame par) {
        return par.add(sentence);
    }

    @Override
    public Frame visit(SentenceList sentenceList, Frame par) {
        for (Sentence item : sentenceList.getItems()) {
            par = item.accept(this, par);
        }
        return par;
    }

    @Override
    public Frame visit(SectionSentence sectionSentence, Frame par) {
        return par.add(sectionSentence);
    }

    @Override
    public Frame visit(ThereSentence thereSentence, Frame par) {
        return par.add(null, ACTOR_TEST, thereSentence);
    }

    @Override
    public Frame visit(ExpectSentence expectSentence, Frame par) {
        return par.add(null, ACTOR_TEST, expectSentence);
    }

    @Override
    public Frame visit(DiagramSentence diagramSentence, Frame par) {
        return par.add(null, ACTOR_TEST, diagramSentence);
    }

    @Override
    public Frame visit(ActorSentence actorSentence, Frame par) {
        Name actor = actorSentence.getActor();
        return par.add(actor == null ? actorSentence.getPosition() : actor.getPosition(), Grouper.actorKey(actorSentence.getActor()), actorSentence);
    }

    @Override
    public Frame visit(CallSentence callSentence, Frame par) {
        CallExpr callExpr = callSentence.getCall();
        List<Sentence> sentences = callExpr.getBody().getItems();
        return this.visit((ActorSentence)callSentence, par).push(Grouper.actorKey(callExpr.getName()), sentences);
    }

    @Override
    public Frame visit(AnswerSentence answerSentence, Frame par) {
        return this.visit((ActorSentence)answerSentence, par).pop(answerSentence.getPosition(), Grouper.actorKey(answerSentence.getActor()));
    }

    static {
        ACTOR_TEST = "actor:<test>,";
    }
}

