/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tools;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeFragments {
    private LinkedHashMap<String, String> fragmentMap = new LinkedHashMap();
    private String phase = "read";

    public LinkedHashMap<String, String> getFragmentMap() {
        return this.fragmentMap;
    }

    public Map<String, String> updateCodeFragments(String ... folderList) {
        try {
            Path path;
            FileVisitor<Path> visitor = new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    CodeFragments.this.updateFile(file, attrs);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            };
            for (String folder : folderList) {
                path = Paths.get(folder, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) continue;
                Files.walkFileTree(path, (FileVisitor<? super Path>)visitor);
            }
            this.phase = "insert";
            for (String folder : folderList) {
                path = Paths.get(folder, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) continue;
                Files.walkFileTree(path, (FileVisitor<? super Path>)visitor);
            }
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.WARNING, "file walk problem", e);
        }
        return this.fragmentMap;
    }

    private void updateFile(Path file, BasicFileAttributes attrs) {
        if (this.phase.equals("read")) {
            this.fetchFromFile(file, attrs);
        } else {
            this.insertFragments(file, attrs);
        }
    }

    private void fetchFromFile(Path file, BasicFileAttributes attrs) {
        String fileName = file.toString();
        if (!(fileName.endsWith(".java") || fileName.endsWith(".md") || fileName.endsWith("build.gradle"))) {
            return;
        }
        try {
            byte[] bytes = Files.readAllBytes(file);
            String content = new String(bytes);
            Pattern startPattern = Pattern.compile("// start_code_fragment: ([\\w\\.]+)\\s*\n");
            Matcher startMatcher = startPattern.matcher(content);
            Pattern endPattern = Pattern.compile("\r?\n\\s*// end_code_fragment:");
            Matcher endMatcher = endPattern.matcher(content);
            while (startMatcher.find()) {
                int start = startMatcher.start();
                int end = startMatcher.end();
                String key = startMatcher.group(1);
                boolean found = endMatcher.find(end - 2);
                if (!found) {
                    throw new IllegalArgumentException("could not find <!-- end_code_fragment: in " + fileName);
                }
                int endOfFragment = endMatcher.start();
                String fragmentText = content.substring(end, endOfFragment);
                this.fragmentMap.put(key, fragmentText);
            }
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.WARNING, "file read problem", e);
        }
    }

    private void insertFragments(Path file, BasicFileAttributes attrs) {
        String fileName = file.toString();
        if (fileName.endsWith(".md")) {
            System.out.println();
        }
        if (!fileName.endsWith(".java") && !fileName.endsWith(".md")) {
            return;
        }
        try {
            byte[] bytes = Files.readAllBytes(file);
            String content = new String(bytes);
            StringBuilder newContent = new StringBuilder();
            Pattern startPattern = Pattern.compile("<!-- insert_code_fragment: ([\\w\\.]+)\\s*-->\\s*\n");
            Matcher startMatcher = startPattern.matcher(content);
            Pattern endPattern = Pattern.compile("\r?\n[\\s|\\*]*<!-- end_code_fragment:");
            Matcher endMatcher = endPattern.matcher(content);
            int lastEnd = 0;
            while (startMatcher.find()) {
                int start = startMatcher.start();
                int end = startMatcher.end();
                String key = startMatcher.group(1);
                boolean found = endMatcher.find(end - 2);
                if (!found) {
                    throw new IllegalArgumentException("could not find <!-- end_code_fragment: in " + fileName);
                }
                int endOfFragment = endMatcher.start();
                String fragmentText = this.fragmentMap.get(key);
                if (fragmentText == null) continue;
                newContent.append(content.substring(lastEnd, end)).append(fragmentText);
                lastEnd = endOfFragment;
            }
            if (lastEnd == 0) {
                return;
            }
            newContent.append(content.substring(lastEnd));
            Files.write(file, newContent.toString().getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.WARNING, "file read problem", e);
        }
    }
}

