/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;
import org.fulib.yaml.YamlObject;
import org.fulib.yaml.Yamler;

public class YamlIdMap {
    private static final String REMOVE = "remove";
    private static final String REMOVE_YOU = "removeYou";
    private ArrayList<String> packageNames;
    private String yaml;
    private String userId = null;
    private boolean decodingPropertyChange;
    private LinkedHashMap<String, Object> objIdMap = new LinkedHashMap();
    private LinkedHashMap<Object, String> idObjMap = new LinkedHashMap();
    private int maxUsedIdNum = 0;
    private Yamler yamler = new Yamler();
    private HashMap<String, String> attrTimeStamps = new HashMap();
    ReflectorMap reflectorMap;
    private String yamlChangeText = null;

    public LinkedHashMap<String, Object> getObjIdMap() {
        return this.objIdMap;
    }

    public LinkedHashMap<Object, String> getIdObjMap() {
        return this.idObjMap;
    }

    public HashMap<String, String> getAttrTimeStamps() {
        return this.attrTimeStamps;
    }

    private YamlIdMap() {
    }

    public YamlIdMap(String ... packageNames) {
        Objects.requireNonNull(packageNames);
        List<String> list = Arrays.asList(packageNames);
        this.packageNames = new ArrayList<String>(list);
        this.reflectorMap = new ReflectorMap(this.packageNames);
    }

    public Object decodeCSV(String fileName) {
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(fileName, new String[0]));
            String csvText = new String(bytes);
            String yamlText = this.convertCsv2Yaml(csvText);
            return this.decode(yamlText);
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private String convertCsv2Yaml(String csvText) {
        String[] split = csvText.split(";");
        for (int i = 0; i < split.length; ++i) {
            Pattern pattern;
            Matcher matcher;
            boolean found;
            String token = split[i];
            if (token.startsWith("\"") && token.endsWith("\"")) continue;
            if (token.startsWith("\"") && !token.endsWith("\"")) {
                String nextToken;
                int j = i;
                do {
                    nextToken = split[++j];
                    split[j] = "";
                    token = token + ";" + nextToken;
                } while (!nextToken.endsWith("\""));
                split[i] = token;
                i = j;
                continue;
            }
            if (token.trim().length() == 0 || !(found = (matcher = (pattern = Pattern.compile("\\s")).matcher(token.trim())).find())) continue;
            split[i] = token = Yamler.encapsulate(token);
        }
        StringBuilder buf = new StringBuilder();
        for (String str : split) {
            buf.append(str).append(" ");
        }
        return buf.toString();
    }

    public Object decode(String yaml, Object root) {
        this.getOrCreateKey(root);
        Object decodedRoot = this.decode(yaml);
        if (decodedRoot != root) {
            throw new RuntimeException("Object passed as root does not match the first object in the yaml string.\nEnsure that the type of the passed root and the first object in the yaml string match. \nEnsure that the key of the passed root and the key of the first object in tha yaml string match. \nYou get the key of the passed root object via 'String key = getOrCreateKey(root);'\n");
        }
        return root;
    }

    public Object decode(String yaml) {
        this.decodingPropertyChange = false;
        this.yamlChangeText = null;
        this.yaml = yaml;
        Object root = null;
        this.yamler = new Yamler(yaml);
        if (!this.yamler.getCurrentToken().equals("-")) {
            return this.yamler.decode(yaml);
        }
        root = this.parseObjectIds();
        this.yamler = new Yamler(yaml);
        this.parseObjectAttrs();
        this.setDecodingPropertyChange(false);
        this.yamlChangeText = null;
        return root;
    }

    private void parseObjectAttrs() {
        while (this.yamler.getCurrentToken() != null) {
            if (!"-".equals(this.yamler.getCurrentToken())) {
                this.yamler.printError("'-' expected");
                this.yamler.nextToken();
                continue;
            }
            String key = this.yamler.nextToken();
            if (key.endsWith(":")) {
                this.parseUsualObjectAttrs();
                continue;
            }
            this.parseObjectTableAttrs();
        }
    }

    private void parseObjectTableAttrs() {
        String className = this.yamler.getCurrentToken();
        Reflector creator = this.reflectorMap.getReflector(className);
        this.yamler.nextToken();
        ArrayList<String> colNameList = new ArrayList<String>();
        while (this.yamler.getCurrentToken() != null && this.yamler.getLookAheadToken() != null && this.yamler.getLookAheadToken().endsWith(":")) {
            String colName = this.yamler.stripColon(this.yamler.getCurrentToken());
            colNameList.add(colName);
            this.yamler.nextToken();
        }
        while (this.yamler.getCurrentToken() != null && !"-".equals(this.yamler.getCurrentToken())) {
            String objectId = this.yamler.stripColon(this.yamler.getCurrentToken());
            this.yamler.nextToken();
            Object obj = this.objIdMap.get(objectId);
            int colNum = 0;
            while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().endsWith(":") && !"-".equals(this.yamler.getCurrentToken())) {
                String attrName = (String)colNameList.get(colNum);
                if (this.yamler.getCurrentToken().startsWith("[")) {
                    String value = this.yamler.getCurrentToken().substring(1);
                    if (value.trim().equals("")) {
                        value = this.yamler.nextToken();
                    }
                    this.setValue(creator, obj, attrName, value);
                    while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().endsWith("]")) {
                        this.yamler.nextToken();
                        value = this.yamler.getCurrentToken();
                        if (this.yamler.getCurrentToken().endsWith("]")) {
                            value = this.yamler.getCurrentToken().substring(0, this.yamler.getCurrentToken().length() - 1);
                        }
                        if (value.trim().equals("")) continue;
                        this.setValue(creator, obj, attrName, value);
                    }
                } else {
                    this.setValue(creator, obj, attrName, this.yamler.getCurrentToken());
                }
                ++colNum;
                this.yamler.nextToken();
            }
        }
    }

    private void parseUsualObjectAttrs() {
        String objectId = this.yamler.stripColon(this.yamler.getCurrentToken());
        String className = this.yamler.nextToken();
        this.yamler.nextToken();
        if (className.endsWith(".remove")) {
            this.objIdMap.remove(objectId);
            while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().equals("-")) {
                this.yamler.nextToken();
            }
            return;
        }
        if (className.equals(".Map")) {
            YamlObject yamlObj = (YamlObject)this.objIdMap.get(objectId);
            LinkedHashMap<String, Object> map = yamlObj.getMap();
            while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().equals("-")) {
                String attrName = this.yamler.stripColon(this.yamler.getCurrentToken());
                this.yamler.nextToken();
                if (map == null) {
                    while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().endsWith(":") && !this.yamler.getCurrentToken().equals("-")) {
                        this.yamler.nextToken();
                    }
                    continue;
                }
                ArrayList<String> previousValue = null;
                while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().endsWith(":") && !this.yamler.getCurrentToken().equals("-")) {
                    String attrValue = this.yamler.getCurrentToken();
                    Object target = this.objIdMap.get(attrValue);
                    if (target != null) {
                        if (previousValue != null) {
                            previousValue.add((String)target);
                            map.put(attrName, previousValue);
                        } else {
                            map.put(attrName, target);
                            previousValue = new ArrayList<String>();
                            previousValue.add((String)target);
                        }
                    } else if (previousValue != null) {
                        previousValue.add(attrValue);
                        map.put(attrName, previousValue);
                    } else {
                        map.put(attrName, attrValue);
                        previousValue = new ArrayList();
                        previousValue.add(attrValue);
                    }
                    this.yamler.nextToken();
                }
            }
        } else {
            Reflector reflector = this.reflectorMap.getReflector(className);
            Object obj = this.objIdMap.get(objectId);
            while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().equals("-")) {
                String attrName = this.yamler.stripColon(this.yamler.getCurrentToken());
                this.yamler.nextToken();
                if (obj == null) {
                    while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().endsWith(":") && !this.yamler.getCurrentToken().equals("-")) {
                        this.yamler.nextToken();
                    }
                    continue;
                }
                while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().endsWith(":") && !this.yamler.getCurrentToken().equals("-")) {
                    String attrValue = this.yamler.getCurrentToken();
                    if (this.yamler.getLookAheadToken() != null && this.yamler.getLookAheadToken().endsWith(".time:")) {
                        String propWithTime = this.yamler.nextToken();
                        String newTimeStamp = this.yamler.nextToken();
                        String oldTimeStamp = this.attrTimeStamps.get(objectId + "." + attrName);
                        if (oldTimeStamp == null || oldTimeStamp.compareTo(newTimeStamp) <= 0) {
                            this.setDecodingPropertyChange(true);
                            if (this.yamlChangeText == null) {
                                this.yamlChangeText = this.yaml;
                            }
                            this.setValue(reflector, obj, attrName, attrValue);
                            this.attrTimeStamps.put(objectId + "." + attrName, newTimeStamp);
                        }
                    } else {
                        this.setValue(reflector, obj, attrName, attrValue);
                    }
                    this.yamler.nextToken();
                }
            }
        }
    }

    private void setValue(Reflector reflector, Object obj, String attrName, String attrValue) {
        block6: {
            String type = "new";
            if (attrName.endsWith(".remove")) {
                if (reflector.getValue(obj, attrName = attrName.substring(0, attrName.length() - ".remove".length())) instanceof Collection) {
                    type = REMOVE;
                } else {
                    attrValue = null;
                }
            }
            try {
                Object targetObj;
                Object setResult = reflector.setValue(obj, attrName, attrValue, type);
                if (setResult == null && (targetObj = this.objIdMap.get(attrValue)) != null) {
                    reflector.setValue(obj, attrName, targetObj, type);
                }
            }
            catch (Exception e) {
                Object targetObj = this.objIdMap.get(attrValue);
                if (targetObj == null) break block6;
                reflector.setValue(obj, attrName, targetObj, type);
            }
        }
    }

    private Object parseObjectIds() {
        Object root = null;
        while (this.yamler.getCurrentToken() != null) {
            Object now;
            if (!"-".equals(this.yamler.getCurrentToken())) {
                this.yamler.printError("'-' expected");
                this.yamler.nextToken();
                continue;
            }
            String key = this.yamler.nextToken();
            if (key.endsWith(":")) {
                now = this.parseUsualObjectId();
                if (root != null) continue;
                root = now;
                continue;
            }
            now = this.parseObjectTableIds();
            if (root != null) continue;
            root = now;
        }
        return root;
    }

    private Object parseUsualObjectId() {
        int dotIndex;
        String objectId = this.yamler.stripColon(this.yamler.getCurrentToken());
        int pos = objectId.lastIndexOf(46);
        String numPart = objectId.substring(pos + 2);
        int objectNum = 0;
        try {
            objectNum = Integer.parseInt(numPart);
        }
        catch (NumberFormatException e) {
            objectNum = this.objIdMap.size() + 1;
        }
        if (objectNum > this.maxUsedIdNum) {
            this.maxUsedIdNum = objectNum;
        }
        String className = this.yamler.nextToken();
        Object obj = this.objIdMap.get(objectId);
        String userId = null;
        while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().equals("-")) {
            String token = this.yamler.nextToken();
            if (token == null || !token.endsWith(".time:")) continue;
            token = this.yamler.nextToken();
            userId = token.substring(token.lastIndexOf(46) + 1);
        }
        boolean foreignChange = false;
        if (userId != null && (dotIndex = objectId.indexOf(46)) > 0) {
            String ownerId = objectId.substring(0, dotIndex);
            boolean bl = foreignChange = !userId.equals(ownerId);
        }
        if (obj == null && !className.endsWith(".remove") && !foreignChange) {
            if (className.equals(".Map")) {
                obj = new YamlObject();
                ((YamlObject)obj).getMap().put(".id", objectId);
            } else {
                Reflector reflector = this.reflectorMap.getReflector(className);
                obj = reflector.newInstance();
            }
            this.objIdMap.put(objectId, obj);
            this.idObjMap.put(obj, objectId);
        }
        return obj;
    }

    private Object parseObjectTableIds() {
        Object root = null;
        String className = this.yamler.getCurrentToken();
        Reflector reflector = this.reflectorMap.getReflector(className);
        while (!"".equals(this.yamler.getCurrentToken()) && this.yamler.getLookAheadToken().endsWith(":")) {
            this.yamler.nextToken();
        }
        while (!"".equals(this.yamler.getCurrentToken()) && !"-".equals(this.yamler.getCurrentToken())) {
            String objectId = this.yamler.stripColon(this.yamler.getCurrentToken());
            this.yamler.nextToken();
            Object obj = reflector.newInstance();
            this.objIdMap.put(objectId, obj);
            this.idObjMap.put(obj, objectId);
            if (root == null) {
                root = obj;
            }
            while (!("".equals(this.yamler.getCurrentToken()) || this.yamler.getCurrentToken().endsWith(":") || "-".equals(this.yamler.getCurrentToken()))) {
                this.yamler.nextToken();
            }
        }
        return root;
    }

    private Object parseObjList(String key, String second) {
        return null;
    }

    public Reflector getReflector(Object obj) {
        return this.reflectorMap.getReflector(obj);
    }

    public Object getObject(String objId) {
        return this.objIdMap.get(objId);
    }

    public String encode(Object ... rootObjList) {
        Objects.requireNonNull(rootObjList);
        StringBuilder buf = new StringBuilder();
        this.collectObjects(rootObjList);
        for (Map.Entry<String, Object> entry : this.objIdMap.entrySet()) {
            String key = entry.getKey();
            Object obj = entry.getValue();
            String className = obj.getClass().getSimpleName();
            buf.append("- ").append(key).append(": \t").append(className).append("\n");
            Reflector creator = this.getReflector(obj);
            for (String prop : creator.getProperties()) {
                String timeKey;
                String timeStamp;
                Object value = creator.getValue(obj, prop);
                if (value == null) continue;
                if (value instanceof Collection) {
                    if (((Collection)value).isEmpty()) continue;
                    buf.append("  ").append(prop).append(": \t");
                    for (Object valueObj : (Collection)value) {
                        String valueKey = this.idObjMap.get(valueObj);
                        buf.append(valueKey).append(" \t");
                    }
                    buf.append("\n");
                    continue;
                }
                if (value instanceof Map) continue;
                String valueKey = this.idObjMap.get(value);
                if (valueKey != null) {
                    buf.append("  ").append(prop).append(": \t").append(valueKey).append("\n");
                } else {
                    if (value instanceof String) {
                        value = Yamler.encapsulate((String)value);
                    }
                    buf.append("  ").append(prop).append(": \t").append(value).append("\n");
                }
                if (this.userId == null || (timeStamp = this.attrTimeStamps.get(timeKey = key + "." + prop)) == null) continue;
                buf.append("  ").append(prop).append(".time: \t").append(timeStamp).append("\n");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public YamlIdMap putNameObject(String name, Object object) {
        String oldKey = this.idObjMap.get(object);
        if (oldKey != null) {
            this.objIdMap.remove(oldKey);
            this.idObjMap.remove(object);
        }
        this.collectObjects(object);
        this.objIdMap.put(name, object);
        this.idObjMap.put(object, name);
        return this;
    }

    public LinkedHashSet<Object> collectObjects(Object ... rootObjList) {
        LinkedList<Object> simpleList = new LinkedList<Object>();
        LinkedHashSet<Object> collectedObjects = new LinkedHashSet<Object>();
        for (Object obj : rootObjList) {
            simpleList.add(obj);
        }
        while (!simpleList.isEmpty()) {
            Object obj = simpleList.get(0);
            simpleList.remove(0);
            collectedObjects.add(obj);
            String key = this.idObjMap.get(obj);
            if (key != null) continue;
            key = this.addToObjIdMap(obj);
            Reflector reflector = this.getReflector(obj);
            for (String prop : reflector.getProperties()) {
                Object value = reflector.getValue(obj, prop);
                if (value == null) continue;
                Class<?> valueClass = value.getClass();
                if (value instanceof Collection) {
                    Object valueObj;
                    Iterator iterator = ((Collection)value).iterator();
                    while (iterator.hasNext() && !(valueClass = (valueObj = iterator.next()).getClass()).getName().startsWith("java.lang")) {
                        simpleList.add(valueObj);
                    }
                    continue;
                }
                if (valueClass.getName().startsWith("java.util.") || valueClass.getName().startsWith("java.lang.")) continue;
                simpleList.add(value);
            }
        }
        return collectedObjects;
    }

    private void encodePropertyChange(StringBuilder buf, Object obj) {
        PropertyChangeEvent event = (PropertyChangeEvent)obj;
        obj = event.getSource();
        String propertyName = event.getPropertyName();
        Object value = event.getNewValue();
        String className = obj.getClass().getSimpleName();
        if (propertyName.equals(REMOVE_YOU)) {
            value = event.getOldValue();
            String valueKey = this.getOrCreateKey(value);
            buf.append("- ").append(valueKey).append(": \t").append(className).append(".remove\n");
            if (this.userId != null) {
                String now = "" + LocalDateTime.now() + "." + this.userId;
                buf.append("  ").append(className).append(".remove.time: \t").append(now).append("\n");
            }
            this.objIdMap.remove(valueKey);
            return;
        }
        if (value == null) {
            value = event.getOldValue();
            propertyName = propertyName + ".remove";
            if (value == null) {
                return;
            }
        }
        this.encodeAttrValue(buf, obj, propertyName, value);
    }

    public void encodeAttrValue(StringBuilder buf, Object obj, String propertyName, Object value) {
        String key = this.getOrCreateKey(obj);
        String className = obj.getClass().getSimpleName();
        buf.append("- ").append(key).append(": \t").append(className).append("\n");
        Class<?> valueClass = value.getClass();
        if (valueClass.getName().startsWith("java.lang.") || valueClass == String.class) {
            buf.append("  ").append(propertyName).append(": \t").append(Yamler.encapsulate(value.toString())).append("\n");
            if (this.userId != null) {
                String now = "" + LocalDateTime.now() + "." + this.userId;
                buf.append("  ").append(propertyName).append(".time: \t").append(now).append("\n");
                this.attrTimeStamps.put(key + "." + propertyName, now);
            }
        } else {
            String valueKey = this.getOrCreateKey(value);
            buf.append("  ").append(propertyName).append(": \t").append(valueKey).append("\n");
            if (this.userId != null) {
                Object fieldValue;
                Reflector reflector = this.reflectorMap.getReflector(obj);
                String fieldName = propertyName;
                if (propertyName.endsWith(".remove")) {
                    fieldName = propertyName.substring(0, propertyName.lastIndexOf(46));
                }
                if ((fieldValue = reflector.getValue(obj, fieldName)) == null || !(fieldValue instanceof Collection)) {
                    String now = "" + LocalDateTime.now() + "." + this.userId;
                    buf.append("  ").append(propertyName).append(".time: \t").append(now).append("\n");
                    this.attrTimeStamps.put(key + "." + propertyName, now);
                } else if (fieldValue != null && fieldValue instanceof Collection) {
                    String now = "" + LocalDateTime.now() + "." + this.userId;
                    buf.append("  ").append(propertyName).append('.').append(valueKey).append(".time: \t").append(now).append("\n");
                    this.attrTimeStamps.put(key + "." + propertyName + "." + valueKey, now);
                }
            }
            if (value != null && !propertyName.endsWith(".remove")) {
                buf.append("- ").append(valueKey).append(": \t").append(valueClass.getSimpleName()).append("\n");
            }
        }
    }

    public String getOrCreateKey(Object obj) {
        String key = this.idObjMap.get(obj);
        if (key == null) {
            key = this.addToObjIdMap(obj);
        }
        return key;
    }

    private String addToObjIdMap(Object obj) {
        String className = obj.getClass().getSimpleName();
        String key = null;
        if (obj instanceof YamlObject) {
            YamlObject yamlObj = (YamlObject)obj;
            Object mapId = yamlObj.getMap().get(".id");
            key = (String)mapId;
        }
        if (key == null) {
            key = className.substring(0, 1).toLowerCase();
            Class<?> clazz = obj.getClass();
            try {
                Method getId = clazz.getMethod("getId", new Class[0]);
                Object id = getId.invoke(obj, new Object[0]);
                if (id != null) {
                    key = id.toString().replaceAll("\\W+", "_");
                }
            }
            catch (Exception e) {
                try {
                    Method getId = clazz.getMethod("getName", new Class[0]);
                    Object id = getId.invoke(obj, new Object[0]);
                    if (id != null) {
                        key = id.toString().replaceAll("\\W+", "_");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            key = key.length() == 1 ? key.substring(0, 1).toLowerCase() : key.substring(0, 1).toLowerCase() + key.substring(1);
            ++this.maxUsedIdNum;
            key = key + this.maxUsedIdNum;
            if (this.maxUsedIdNum > 1 && this.userId != null) {
                key = this.userId + "." + key;
            }
        }
        this.objIdMap.put(key, obj);
        this.idObjMap.put(obj, key);
        return key;
    }

    public YamlIdMap withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public boolean isDecodingPropertyChange() {
        return this.decodingPropertyChange;
    }

    public void setDecodingPropertyChange(boolean decodingPropertyChange) {
        this.decodingPropertyChange = decodingPropertyChange;
    }

    public String getYamlChange() {
        String result = this.yamlChangeText;
        this.yamlChangeText = "";
        return result;
    }

    public String getLastTimeStamps() {
        LinkedHashMap<String, String> user2TimeStampMap = this.getLastTimeStampMap();
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> e : user2TimeStampMap.entrySet()) {
            buf.append(e.getValue()).append(" ");
        }
        return buf.toString();
    }

    public LinkedHashMap<String, String> getLastTimeStampMap(String lastTimeStamps) {
        String[] split;
        LinkedHashMap<String, String> user2TimeStampMap = new LinkedHashMap<String, String>();
        for (String s : split = lastTimeStamps.split("\\s+")) {
            int pos = s.lastIndexOf(46);
            String user = s.substring(pos + 1);
            user2TimeStampMap.put(user, s);
        }
        return user2TimeStampMap;
    }

    public LinkedHashMap<String, String> getLastTimeStampMap() {
        LinkedHashMap<String, String> user2TimeStampMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> e : this.attrTimeStamps.entrySet()) {
            int pos;
            String timeStamp = e.getValue();
            String userName = timeStamp.substring((pos = timeStamp.lastIndexOf(46)) + 1);
            String oldTimeStamp = user2TimeStampMap.get(userName);
            if (oldTimeStamp != null && oldTimeStamp.compareTo(timeStamp) >= 0) continue;
            user2TimeStampMap.put(userName, timeStamp);
        }
        return user2TimeStampMap;
    }
}

