/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.debug;

import java.beans.Introspector;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ASTDumper {
    private final Class<?>[] rootClasses;

    public ASTDumper(Class<?> ... rootClasses) {
        this.rootClasses = rootClasses;
    }

    public ASTDumper(Collection<? extends Class<?>> rootClasses) {
        this.rootClasses = rootClasses.toArray(new Class[0]);
    }

    private boolean isNode(Object object) {
        for (Class<?> rootClass : this.rootClasses) {
            if (!rootClass.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public void dump(Object object, PrintWriter out) {
        this.dump(object, "", out, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private void dump(Object object, String indent, PrintWriter out, Set<Object> dejaVu) {
        if (object == null) {
            out.println("null");
            return;
        }
        if (!this.isNode(object)) {
            out.println(object);
            return;
        }
        this.dumpNode(object, indent, out, dejaVu);
    }

    private void dumpNode(Object object, String indent, PrintWriter out, Set<Object> dejaVu) {
        Class<?> type = object.getClass();
        out.print(ASTDumper.getID(object));
        if (!dejaVu.add(object)) {
            out.println(" (s.a.)");
            return;
        }
        TreeMap<String, Object> attributes = new TreeMap<String, Object>();
        TreeMap<String, Object> children = new TreeMap<String, Object>();
        this.collectProperties(object, type, attributes, children);
        if (!attributes.isEmpty()) {
            this.printAttributes(out, attributes);
        }
        out.println();
        if (!children.isEmpty()) {
            this.printChildren(indent, out, dejaVu, children);
        }
    }

    private void collectProperties(Object object, Class<?> type, Map<String, Object> attributes, Map<String, Object> children) {
        for (Method method : type.getDeclaredMethods()) {
            if ((method.getModifiers() & 1) == 0 || !method.getName().startsWith("get") || method.getParameterCount() != 0) continue;
            this.collectProperty(object, method, attributes, children);
        }
    }

    private void collectProperty(Object object, Method method, Map<String, Object> attributes, Map<String, Object> children) {
        Object value;
        String key = Introspector.decapitalize(method.getName().substring(3));
        try {
            value = method.invoke(object, new Object[0]);
        }
        catch (Exception ignored) {
            value = "<error>";
        }
        this.collectProperty(key, value, attributes, children);
    }

    private void collectProperty(String key, Object value, Map<String, Object> attributes, Map<String, Object> children) {
        if (value instanceof Collection) {
            this.collectProperties(key, (Collection)value, attributes, children);
        } else if (value instanceof Map) {
            this.collectProperties(key, (Map)value, attributes, children);
        } else {
            (this.isNode(value) ? children : attributes).put(key, value);
        }
    }

    private void collectProperties(String key, Map<?, ?> value, Map<String, Object> attributes, Map<String, Object> children) {
        if (value.isEmpty()) {
            attributes.put(key, "{}");
            return;
        }
        int maxKeyLength = value.keySet().stream().map(Object::toString).mapToInt(String::length).max().getAsInt();
        String format = key + "[%" + maxKeyLength + "s]";
        TreeMap<String, String> rest = new TreeMap<String, String>();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            String entryKey = entry.getKey().toString();
            Object entryValue = entry.getValue();
            if (this.isNode(entryValue)) {
                children.put(String.format(format, entryKey), entryValue);
                rest.put(entryKey, ASTDumper.getID(entryValue));
                continue;
            }
            rest.put(entryKey, (String)entryValue);
        }
        attributes.put(key, ((Object)rest).toString());
    }

    private void collectProperties(String key, Collection<?> value, Map<String, Object> attributes, Map<String, Object> children) {
        if (value.isEmpty()) {
            attributes.put(key, "[]");
            return;
        }
        int size = value.size();
        String format = key + "[%" + ((int)Math.log10(size) + 1) + "d]";
        Object[] rest = new Object[size];
        int index = 0;
        for (Object item : value) {
            if (this.isNode(item)) {
                children.put(String.format(format, index), item);
                rest[index] = ASTDumper.getID(item);
            } else {
                rest[index] = item;
            }
            ++index;
        }
        attributes.put(key, Arrays.toString(rest));
    }

    private static String getID(Object item) {
        Class<?> itemClass = item.getClass();
        Class<?> enclosingClass = itemClass.getEnclosingClass();
        String simpleName = itemClass.getSimpleName();
        String idNum = Integer.toHexString(System.identityHashCode(item));
        return ("Impl".equals(simpleName) ? enclosingClass.getSimpleName() : simpleName) + "@" + idNum;
    }

    private void printAttributes(PrintWriter out, Map<String, Object> attributes) {
        out.print('(');
        Iterator<Map.Entry<String, Object>> iterator = attributes.entrySet().iterator();
        Map.Entry<String, Object> entry = iterator.next();
        out.print(entry.getKey());
        out.print(": ");
        out.print(entry.getValue());
        while (iterator.hasNext()) {
            entry = iterator.next();
            out.print(", ");
            out.print(entry.getKey());
            out.print(": ");
            out.print(entry.getValue());
        }
        out.print(')');
    }

    private void printChildren(String indent, PrintWriter out, Set<Object> dejaVu, Map<String, Object> children) {
        Iterator<Map.Entry<String, Object>> iterator = children.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String key = entry.getKey();
            out.print(indent + "+- ");
            out.print(key);
            out.print(": ");
            StringBuilder newIndent = new StringBuilder(indent.length() + key.length() + 2 + 3);
            newIndent.append(indent);
            newIndent.append(iterator.hasNext() ? "|  " : "   ");
            for (int i = 0; i < key.length(); ++i) {
                newIndent.append(' ');
            }
            newIndent.append("  ");
            this.dumpNode(entry.getValue(), newIndent.toString(), out, dejaVu);
        }
    }
}

