/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.tool;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.fulib.StrUtil;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.ast.type.UnresolvedType;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassModelVisitor
extends ClassVisitor {
    private final ClassDecl classDecl;
    private final Set<String> properties = new LinkedHashSet<String>();

    public ClassModelVisitor(ClassDecl classDecl) {
        super(458752);
        this.classDecl = classDecl;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int slashIndex = name.lastIndexOf(47);
        String simpleName = slashIndex < 0 ? name : name.substring(slashIndex + 1);
        this.classDecl.setName(simpleName);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        String attributeName;
        if (name.startsWith("PROPERTY_") && (attributeName = name.substring("PROPERTY_".length())).equals(value)) {
            this.properties.add(attributeName);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if ("<init>".equals(name) || "<clinit>".equals(name)) {
            return null;
        }
        if (name.startsWith("get") || name.startsWith("set") || name.startsWith("with") || name.startsWith("without")) {
            String attributeName = name.substring(3);
            if (this.properties.contains(attributeName)) {
                if (name.charAt(0) == 'g') {
                    this.tryCreateAttribute(attributeName, descriptor, signature);
                }
                return null;
            }
            String lowerAttributeName = StrUtil.downFirstChar(attributeName);
            if (this.properties.contains(lowerAttributeName)) {
                if (name.charAt(0) == 'g') {
                    this.tryCreateAttribute(lowerAttributeName, descriptor, signature);
                }
                return null;
            }
        }
        if ((access & 1) != 0 && (access & 8) == 0) {
            this.tryCreateMethod(name, descriptor);
        }
        return null;
    }

    private void tryCreateAttribute(String name, String descriptor, String signature) {
        try {
            this.createAttribute(name, descriptor, signature);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void createAttribute(String name, String descriptor, String signature) {
        int returnTypeIndex = descriptor.indexOf(41) + 1;
        if (descriptor.endsWith(")Ljava/util/List;") || descriptor.endsWith(")Ljava/util/ArrayList;")) {
            ListType listType = ListType.of(null);
            int elementTypeIndex = signature.indexOf(60, returnTypeIndex) + 1;
            ClassModelVisitor.parseType(signature, elementTypeIndex, listType::setElementType);
            AttributeDecl attribute = AttributeDecl.of(this.classDecl, name, listType);
            this.classDecl.getAttributes().put(name, attribute);
            return;
        }
        AttributeDecl attribute = AttributeDecl.of(this.classDecl, name, null);
        ClassModelVisitor.parseType(descriptor, returnTypeIndex, attribute::setType);
        this.classDecl.getAttributes().put(name, attribute);
    }

    private void tryCreateMethod(String name, String descriptor) {
        try {
            MethodDecl methodDecl = MethodDecl.of(this.classDecl, name, new ArrayList<ParameterDecl>(), null, null);
            ClassModelVisitor.parseType(descriptor, descriptor.lastIndexOf(41) + 1, methodDecl::setType);
            ParameterDecl thisParam = ParameterDecl.of(methodDecl, "this", this.classDecl.getType());
            methodDecl.getParameters().add(thisParam);
            int index = 1;
            while (descriptor.charAt(index) != ')') {
                ParameterDecl param = ParameterDecl.of(methodDecl, null, null);
                index = ClassModelVisitor.parseType(descriptor, index, param::setType);
                methodDecl.getParameters().add(param);
            }
            this.classDecl.getMethods().add(methodDecl);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static Type parseType(String descriptor, int index) {
        Type[] holder = new Type[1];
        ClassModelVisitor.parseType(descriptor, index, t -> {
            holder[0] = t;
        });
        return holder[0];
    }

    public static int parseType(String descriptor, int index, Consumer<? super Type> consumer) {
        char c = descriptor.charAt(index);
        switch (c) {
            case '[': {
                throw new UnsupportedOperationException("array types");
            }
            case 'T': {
                throw new UnsupportedOperationException("generic type variables");
            }
            case 'L': {
                int end = descriptor.indexOf(59, index + 1);
                int slash = descriptor.lastIndexOf(47, end);
                if (descriptor.charAt(end - 1) == '>') {
                    throw new UnsupportedOperationException("generic type arguments");
                }
                String packageDir = slash < index ? "" : descriptor.substring(index + 1, slash);
                String className = descriptor.substring(slash < index ? index + 1 : slash + 1, end);
                consumer.accept(ClassModelVisitor.resolveType(packageDir, className));
                return end + 1;
            }
        }
        consumer.accept(ClassModelVisitor.parsePrimitiveType(c));
        return index + 1;
    }

    private static Type resolveType(String packageDir, String className) {
        PrimitiveType primitive;
        if ("java/lang".equals(packageDir) && (primitive = PrimitiveType.javaNameMap.get(className)) != null) {
            return primitive;
        }
        UnresolvedType type = UnresolvedType.of(className);
        type.setPackageDir(packageDir);
        return type;
    }

    private static PrimitiveType parsePrimitiveType(char c) {
        switch (c) {
            case 'V': {
                return PrimitiveType.VOID;
            }
            case 'Z': {
                return PrimitiveType.BOOLEAN;
            }
            case 'B': {
                return PrimitiveType.BYTE;
            }
            case 'S': {
                return PrimitiveType.SHORT;
            }
            case 'C': {
                return PrimitiveType.CHAR;
            }
            case 'I': {
                return PrimitiveType.INT;
            }
            case 'J': {
                return PrimitiveType.LONG;
            }
            case 'F': {
                return PrimitiveType.FLOAT;
            }
            case 'D': {
                return PrimitiveType.DOUBLE;
            }
        }
        throw new UnsupportedOperationException("unknown type char " + c);
    }
}

