/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.fulib.scenarios.ast.CompilationContext;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.scope.DelegatingScope;
import org.fulib.scenarios.ast.scope.EmptyScope;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.parser.Identifiers;
import org.fulib.scenarios.visitor.ExtractClassDecl;
import org.fulib.scenarios.visitor.resolve.SentenceResolver;
import org.fulib.scenarios.visitor.resolve.TypeResolver;

public enum NameResolver implements CompilationContext.Visitor<Object, Object>,
ScenarioGroup.Visitor<Scope, Object>,
ScenarioFile.Visitor<Scope, Object>,
Scenario.Visitor<Scope, Object>,
Name.Visitor<Scope, Name>
{
    INSTANCE;

    protected static final String PREDICATE_RECEIVER = "<predicate-receiver>";
    protected static final String ANSWER_VAR = "<answer-var>";

    @Override
    public Object visit(CompilationContext compilationContext, Object par) {
        Map<String, ScenarioGroup> groups = compilationContext.getGroups();
        HashSet<ScenarioGroup> importedGroups = new HashSet<ScenarioGroup>();
        final HashMap<String, ClassDecl> importedClasses = new HashMap<String, ClassDecl>();
        for (String packageName : compilationContext.getConfig().getImports()) {
            String packageDir = packageName.replace('.', '/');
            ScenarioGroup group = groups.get(packageDir);
            if (group == null) continue;
            group.accept(this, EmptyScope.INSTANCE);
            importedGroups.add(group);
            importedClasses.putAll(group.getClasses());
        }
        Scope importedScope = new Scope(){

            @Override
            public Decl resolve(String name) {
                return (Decl)importedClasses.get(name);
            }

            @Override
            public void add(Decl decl) {
            }

            @Override
            public void report(Marker marker) {
            }
        };
        groups.values().parallelStream().filter(o -> !importedGroups.contains(o)).forEach(it -> it.accept(this, importedScope));
        return null;
    }

    @Override
    public Object visit(final ScenarioGroup scenarioGroup, Scope par) {
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                ClassDecl classDecl = scenarioGroup.getClasses().get(name);
                return classDecl != null ? classDecl : super.resolve(name);
            }

            @Override
            public void add(Decl decl) {
                ClassDecl classDecl = (ClassDecl)decl;
                classDecl.setGroup(scenarioGroup);
                scenarioGroup.getClasses().put(decl.getName(), classDecl);
            }
        };
        for (ClassDecl classDecl : scenarioGroup.getClasses().values()) {
            Iterator<AttributeDecl> iterator = classDecl.getAttributes().values().iterator();
            while (iterator.hasNext()) {
                AttributeDecl attribute = iterator.next();
                Type type = attribute.getType().accept(TypeResolver.INSTANCE, scope);
                ClassDecl otherClass = type.accept(ExtractClassDecl.INSTANCE, null);
                if (otherClass == null) {
                    attribute.setType(type);
                    continue;
                }
                int cardinality = type instanceof ListType ? 42 : 1;
                String name = attribute.getName();
                AssociationDecl assoc = AssociationDecl.of(classDecl, name, cardinality, otherClass, type, null);
                iterator.remove();
                classDecl.getAssociations().put(name, assoc);
            }
            for (MethodDecl methodDecl : classDecl.getMethods()) {
                methodDecl.setType(methodDecl.getType().accept(TypeResolver.INSTANCE, scope));
            }
            classDecl.setFrozen(true);
        }
        for (ScenarioFile file : scenarioGroup.getFiles().values()) {
            if (file.getExternal()) continue;
            file.accept(this, scope);
        }
        return null;
    }

    @Override
    public Object visit(final ScenarioFile scenarioFile, Scope par) {
        ScenarioGroup group = scenarioFile.getGroup();
        final String className = Identifiers.toUpperCamelCase(scenarioFile.getName()) + "Test";
        final ClassDecl classDecl = ClassDecl.of(group, className, null, new LinkedHashMap<String, AttributeDecl>(), new LinkedHashMap<String, AssociationDecl>(), new ArrayList<MethodDecl>());
        classDecl.setExternal(scenarioFile.getExternal());
        classDecl.setType(ClassType.of(classDecl));
        scenarioFile.setClassDecl(classDecl);
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                return className.equals(name) || "<enclosing:class>".equals(name) ? classDecl : super.resolve(name);
            }

            @Override
            public void report(Marker marker) {
                scenarioFile.getMarkers().add(marker);
            }
        };
        for (Scenario scenario : scenarioFile.getScenarios().values()) {
            scenario.accept(this, scope);
        }
        return null;
    }

    @Override
    public Object visit(Scenario scenario, Scope par) {
        ClassDecl classDecl = scenario.getFile().getClassDecl();
        final String methodName = Identifiers.toLowerCamelCase(scenario.getName());
        SentenceList body = scenario.getBody();
        final MethodDecl methodDecl = MethodDecl.of(classDecl, methodName, null, PrimitiveType.VOID, body);
        final ParameterDecl thisParam = ParameterDecl.of(methodDecl, "this", classDecl.getType());
        methodDecl.setParameters(Collections.singletonList(thisParam));
        classDecl.getMethods().add(methodDecl);
        scenario.setMethodDecl(methodDecl);
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                if ("this".equals(name)) {
                    return thisParam;
                }
                if (methodName.equals(name)) {
                    return methodDecl;
                }
                return super.resolve(name);
            }
        };
        body.accept(SentenceResolver.INSTANCE, scope);
        return null;
    }

    @Override
    public Name visit(Name name, Scope par) {
        return name;
    }

    @Override
    public Name visit(ResolvedName resolvedName, Scope par) {
        return resolvedName;
    }

    @Override
    public Name visit(UnresolvedName unresolvedName, Scope par) {
        Decl decl = par.resolve(unresolvedName.getValue());
        return decl == null ? unresolvedName : ResolvedName.of(decl);
    }
}

