/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.fulib.StrUtil;
import org.fulib.scenarios.ast.MultiDescriptor;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.call.CreationExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.scope.DelegatingScope;
import org.fulib.scenarios.ast.scope.HidingScope;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.sentence.AddSentence;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.AreSentence;
import org.fulib.scenarios.ast.sentence.AssignSentence;
import org.fulib.scenarios.ast.sentence.CallSentence;
import org.fulib.scenarios.ast.sentence.ConditionalSentence;
import org.fulib.scenarios.ast.sentence.CreateSentence;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.ExpectSentence;
import org.fulib.scenarios.ast.sentence.ExprSentence;
import org.fulib.scenarios.ast.sentence.FlattenSentenceList;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.RemoveSentence;
import org.fulib.scenarios.ast.sentence.SectionSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.TakeSentence;
import org.fulib.scenarios.ast.sentence.TemplateSentence;
import org.fulib.scenarios.ast.sentence.ThereSentence;
import org.fulib.scenarios.ast.sentence.WriteSentence;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.diagnostic.Position;
import org.fulib.scenarios.visitor.ExtractClassDecl;
import org.fulib.scenarios.visitor.ExtractDecl;
import org.fulib.scenarios.visitor.Namer;
import org.fulib.scenarios.visitor.Typer;
import org.fulib.scenarios.visitor.describe.TypeDescriber;
import org.fulib.scenarios.visitor.resolve.AddResolve;
import org.fulib.scenarios.visitor.resolve.AssignmentResolve;
import org.fulib.scenarios.visitor.resolve.DeclResolver;
import org.fulib.scenarios.visitor.resolve.ExprResolver;
import org.fulib.scenarios.visitor.resolve.NameResolver;
import org.fulib.scenarios.visitor.resolve.RemoveResolve;
import org.fulib.scenarios.visitor.resolve.SymbolCollector;

public enum SentenceResolver implements Sentence.Visitor<Scope, Sentence>
{
    INSTANCE;


    @Override
    public Sentence visit(SentenceList sentenceList, Scope par) {
        final HashMap decls = new HashMap();
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                Decl decl = (Decl)decls.get(name);
                return decl != null ? decl : super.resolve(name);
            }

            @Override
            public void add(Decl decl) {
                if (decl instanceof VarDecl) {
                    decls.put(decl.getName(), decl);
                    return;
                }
                super.add(decl);
            }
        };
        List<Sentence> oldItems = sentenceList.getItems();
        ArrayList<Sentence> newItems = new ArrayList<Sentence>(oldItems.size());
        for (Sentence item : oldItems) {
            Sentence resolved = item.accept(this, scope);
            resolved.accept(SymbolCollector.INSTANCE, decls);
            FlattenSentenceList.add(newItems, resolved);
        }
        sentenceList.setItems(newItems);
        return sentenceList;
    }

    @Override
    public Sentence visit(SectionSentence sectionSentence, Scope par) {
        String processedComment = sectionSentence.getLevel().format(sectionSentence.getText().trim());
        return TemplateSentence.of(processedComment, Collections.emptyList());
    }

    @Override
    public Sentence visit(ThereSentence thereSentence, Scope par) {
        return SentenceResolver.expand(thereSentence.getDescriptor(), par).accept(this, par);
    }

    @Override
    public Sentence visit(ExpectSentence expectSentence, Scope par) {
        expectSentence.getPredicates().replaceAll(it -> (ConditionalExpr)it.accept(ExprResolver.INSTANCE, par));
        return expectSentence;
    }

    @Override
    public Sentence visit(DiagramSentence diagramSentence, Scope par) {
        diagramSentence.setObject(diagramSentence.getObject().accept(ExprResolver.INSTANCE, par));
        return diagramSentence;
    }

    @Override
    public Sentence visit(HasSentence hasSentence, Scope par) {
        Expr receiver = hasSentence.getObject().accept(ExprResolver.INSTANCE, par);
        hasSentence.setObject(receiver);
        Type receiverType = receiver.accept(Typer.INSTANCE, null);
        ClassDecl receiverClass = receiverType.accept(ExtractClassDecl.INSTANCE, null);
        if (receiverClass == null) {
            par.report(Marker.error(receiver.getPosition(), "has.subject.primitive", receiverType.accept(TypeDescriber.INSTANCE, null)));
            return hasSentence;
        }
        String receiverName = receiver.accept(Namer.INSTANCE, null);
        Scope scope = receiverName != null ? new HidingScope(receiverName, par) : par;
        for (NamedExpr namedExpr : hasSentence.getClauses()) {
            SentenceResolver.resolveHasNamedExpr(namedExpr, receiverClass, scope);
        }
        return hasSentence;
    }

    @Override
    public Sentence visit(IsSentence isSentence, Scope par) {
        VarDecl varDecl = isSentence.getDescriptor();
        Expr expr = varDecl.getExpr().accept(ExprResolver.INSTANCE, par);
        Type exprType = expr.accept(Typer.INSTANCE, null);
        if (exprType == PrimitiveType.VOID) {
            return ExprSentence.of(expr);
        }
        String name = varDecl.getName();
        if (name == null) {
            name = expr.accept(Namer.INSTANCE, null);
        } else if (name.contains("++")) {
            name = SentenceResolver.findUnique(name, par);
        }
        Decl existing = par.resolve(name);
        if (existing != varDecl && existing instanceof VarDecl) {
            return AssignSentence.of((VarDecl)existing, expr);
        }
        varDecl.setName(name);
        varDecl.setExpr(expr);
        if (varDecl.getType() == null) {
            varDecl.setType(exprType);
        }
        return isSentence;
    }

    @Override
    public Sentence visit(AreSentence areSentence, Scope par) {
        return SentenceResolver.expand(areSentence.getDescriptor(), par).accept(this, par);
    }

    @Override
    public Sentence visit(CreateSentence createSentence, Scope par) {
        return SentenceResolver.expand(createSentence.getDescriptor(), par).accept(this, par);
    }

    @Override
    public Sentence visit(CallSentence callSentence, Scope par) {
        CallExpr call = callSentence.getCall();
        String name = call.accept(Namer.INSTANCE, null);
        if (name == null) {
            return ExprSentence.of(call).accept(this, par);
        }
        Name actor = callSentence.getActor();
        NameAccess target = NameAccess.of(UnresolvedName.of(name, null));
        WriteSentence writeSentence = WriteSentence.of(actor, call, target);
        return writeSentence.accept(this, par);
    }

    @Override
    public Sentence visit(AnswerSentence answerSentence, Scope par) {
        if (answerSentence.getActor() != null) {
            answerSentence.setActor(answerSentence.getActor().accept(NameResolver.INSTANCE, par));
        }
        answerSentence.setResult(answerSentence.getResult().accept(ExprResolver.INSTANCE, par));
        return answerSentence;
    }

    @Override
    public Sentence visit(WriteSentence writeSentence, Scope par) {
        Expr source = writeSentence.getSource();
        Expr target = writeSentence.getTarget();
        return SentenceResolver.resolveAssignment(writeSentence, par, source, target, AssignmentResolve.INSTANCE, "write.target.invalid");
    }

    @Override
    public Sentence visit(AddSentence addSentence, Scope par) {
        Expr source = addSentence.getSource().accept(ExprResolver.INSTANCE, par);
        Expr target = addSentence.getTarget();
        return SentenceResolver.resolveAssignment(addSentence, par, source, target, AddResolve.INSTANCE, "add.target.invalid");
    }

    @Override
    public Sentence visit(RemoveSentence removeSentence, Scope par) {
        Expr source = removeSentence.getSource().accept(ExprResolver.INSTANCE, par);
        Expr target = removeSentence.getTarget();
        return SentenceResolver.resolveAssignment(removeSentence, par, source, target, RemoveResolve.INSTANCE, "remove.target.invalid");
    }

    @Override
    public Sentence visit(TakeSentence takeSentence, Scope par) {
        Type type;
        String exampleName;
        Expr example = takeSentence.getExample();
        if (example != null) {
            example = example.accept(ExprResolver.INSTANCE, par);
            exampleName = example.accept(Namer.INSTANCE, null);
            takeSentence.setExample(example);
        } else {
            exampleName = null;
        }
        Expr collection = takeSentence.getCollection().accept(ExprResolver.INSTANCE, par);
        takeSentence.setCollection(collection);
        Type listType = collection.accept(Typer.INSTANCE, par);
        if (listType instanceof ListType) {
            type = ((ListType)listType).getElementType();
        } else {
            if (listType != PrimitiveType.ERROR) {
                par.report(Marker.error(collection.getPosition(), "take.source.type", listType.accept(TypeDescriber.INSTANCE, null)));
            }
            type = PrimitiveType.ERROR;
        }
        final VarDecl varDecl = SentenceResolver.resolveVar(takeSentence, par, exampleName, type);
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                return name.equals(varDecl.getName()) || name.equals(exampleName) ? varDecl : super.resolve(name);
            }
        };
        takeSentence.setBody(takeSentence.getBody().accept(this, scope));
        return takeSentence;
    }

    @Override
    public Sentence visit(ConditionalSentence conditionalSentence, Scope par) {
        conditionalSentence.setCondition((ConditionalExpr)conditionalSentence.getCondition().accept(ExprResolver.INSTANCE, par));
        conditionalSentence.setBody(conditionalSentence.getBody().accept(this, par));
        return conditionalSentence;
    }

    @Override
    public Sentence visit(AssignSentence assignSentence, Scope par) {
        assignSentence.setValue(assignSentence.getValue().accept(ExprResolver.INSTANCE, par));
        return assignSentence;
    }

    @Override
    public Sentence visit(ExprSentence exprSentence, Scope par) {
        exprSentence.setExpr(exprSentence.getExpr().accept(ExprResolver.INSTANCE, par));
        return exprSentence;
    }

    @Override
    public Sentence visit(TemplateSentence templateSentence, Scope par) {
        templateSentence.getExprs().replaceAll(it -> it.accept(ExprResolver.INSTANCE, par));
        return templateSentence;
    }

    private static String findUnique(String name, Scope par) {
        int index = name.indexOf("++");
        String prefix = name.substring(0, index);
        String suffix = name.substring(index + 2);
        int i = 1;
        String numbered;
        while (par.resolve(numbered = prefix + i + suffix) != null) {
            ++i;
        }
        return numbered;
    }

    private static Sentence expand(MultiDescriptor descriptor, Scope scope) {
        ArrayList<Sentence> result = new ArrayList<Sentence>();
        SentenceResolver.expand(descriptor, result, scope);
        return new FlattenSentenceList(result);
    }

    private static void expand(MultiDescriptor multiDesc, List<Sentence> result, Scope scope) {
        List<Name> names = SentenceResolver.getNames(multiDesc);
        ArrayList<VarDecl> varDecls = new ArrayList<VarDecl>(names.size());
        for (Name name : names) {
            CreationExpr expr = CreationExpr.of(multiDesc.getType(), Collections.emptyList());
            String nameValue = name.accept(Namer.INSTANCE, null);
            Decl existing = scope.resolve(nameValue);
            if (existing instanceof VarDecl) {
                scope.report(Marker.error(name.getPosition(), "variable.redeclaration", nameValue).note(Marker.note(existing.getPosition(), "variable.declaration.first", nameValue)));
                varDecls.add((VarDecl)existing);
                continue;
            }
            VarDecl varDecl = VarDecl.of(nameValue, null, expr);
            varDecl.setPosition(name.getPosition());
            varDecls.add(varDecl);
            IsSentence isSentence = IsSentence.of(varDecl);
            isSentence.setPosition(name.getPosition());
            result.add(isSentence);
        }
        for (NamedExpr attribute : multiDesc.getAttributes()) {
            List<Expr> elements;
            Name attributeName = attribute.getName();
            Expr attributeExpr = attribute.getExpr();
            if (names.size() == 1) {
                NameAccess object = NameAccess.of(ResolvedName.of((Decl)varDecls.get(0)));
                HasSentence hasSentence = HasSentence.of(object, Collections.singletonList(attribute));
                result.add(hasSentence);
                continue;
            }
            if (attributeExpr instanceof ListExpr && (elements = ((ListExpr)attributeExpr).getElements()).size() == names.size()) {
                for (int i = 0; i < names.size(); ++i) {
                    NameAccess object = NameAccess.of(ResolvedName.of((Decl)varDecls.get(i)));
                    NamedExpr partialAttribute = NamedExpr.of(attributeName, elements.get(i));
                    HasSentence hasSentence = HasSentence.of(object, Collections.singletonList(partialAttribute));
                    result.add(hasSentence);
                }
                continue;
            }
            VarDecl temp = VarDecl.of("temp++", null, attributeExpr);
            result.add(IsSentence.of(temp));
            for (int i = 0; i < names.size(); ++i) {
                NameAccess object = NameAccess.of(ResolvedName.of((Decl)varDecls.get(i)));
                NameAccess tempAccess = NameAccess.of(ResolvedName.of(temp));
                NamedExpr partialAttribute = NamedExpr.of(attributeName, tempAccess);
                HasSentence hasSentence = HasSentence.of(object, Collections.singletonList(partialAttribute));
                result.add(hasSentence);
            }
        }
    }

    private static List<Name> getNames(MultiDescriptor multiDesc) {
        List<Name> names = multiDesc.getNames();
        if (!names.isEmpty()) {
            return names;
        }
        block0: for (NamedExpr attribute : multiDesc.getAttributes()) {
            Expr expr = attribute.getExpr();
            if (expr instanceof ListExpr) {
                List<Expr> elements = ((ListExpr)expr).getElements();
                ArrayList<Name> result = new ArrayList<Name>(elements.size());
                for (Expr element : elements) {
                    String potentialName = element.accept(Namer.INSTANCE, null);
                    if (potentialName == null) continue block0;
                    result.add(SentenceResolver.unresolvedName(potentialName, element.getPosition()));
                }
                return result;
            }
            String potentialName = expr.accept(Namer.INSTANCE, null);
            if (potentialName == null) continue;
            Name name = SentenceResolver.unresolvedName(potentialName, expr.getPosition());
            return Collections.singletonList(name);
        }
        String className = multiDesc.getType().accept(Namer.INSTANCE, null);
        String objectName = StrUtil.downFirstChar(className);
        Name name = SentenceResolver.unresolvedName(objectName, multiDesc.getType().getPosition());
        return Collections.singletonList(name);
    }

    private static Name unresolvedName(String potentialName, Position position) {
        UnresolvedName name = UnresolvedName.of(potentialName, null);
        name.setPosition(position);
        return name;
    }

    private static void resolveHasNamedExpr(NamedExpr namedExpr, ClassDecl objectClass, Scope scope) {
        int otherCardinality;
        Name name = namedExpr.getName();
        Name otherName = namedExpr.getOtherName();
        Expr expr = namedExpr.getExpr().accept(ExprResolver.INSTANCE, scope);
        namedExpr.setExpr(expr);
        if (otherName == null) {
            namedExpr.setName(DeclResolver.resolveAttributeOrAssociation(scope, objectClass, name, expr));
            return;
        }
        String assocName = name.accept(Namer.INSTANCE, null);
        Type exprType = expr.accept(Typer.INSTANCE, scope);
        int cardinality = exprType instanceof ListType ? 42 : 1;
        ClassDecl otherClass = exprType.accept(ExtractClassDecl.INSTANCE, null);
        String otherAssocName = otherName.accept(Namer.INSTANCE, null);
        int n = otherCardinality = namedExpr.getOtherMany() ? 42 : 1;
        if (otherClass == null) {
            scope.report(Marker.error(otherName.getPosition(), "attribute.reverse.name", otherAssocName, objectClass.getName(), assocName));
            return;
        }
        AssociationDecl assoc = DeclResolver.resolveAssociation(scope, objectClass, assocName, cardinality, otherClass, otherAssocName, otherCardinality, name.getPosition(), otherName.getPosition());
        if (assoc != null) {
            AssociationDecl other = assoc.getOther();
            namedExpr.setName(ResolvedName.of(assoc));
            if (other != null) {
                namedExpr.setOtherName(ResolvedName.of(other));
            }
        }
    }

    private static Sentence resolveAssignment(Sentence original, Scope par, Expr source, Expr target, Expr.Visitor<Expr, Sentence> resolve, String code) {
        Sentence sentence = target.accept(resolve, source);
        if (sentence != null) {
            return sentence.accept(INSTANCE, par);
        }
        par.report(Marker.error(target.getPosition(), code, target.getClass().getEnclosingClass().getSimpleName()));
        return original;
    }

    private static VarDecl resolveVar(TakeSentence takeSentence, Scope par, String exampleName, Type type) {
        String varName;
        Name name = takeSentence.getVarName();
        if (name != null) {
            Decl decl = name.accept(ExtractDecl.INSTANCE, null);
            if (decl != null) {
                return (VarDecl)decl;
            }
            varName = name.accept(Namer.INSTANCE, null);
        } else {
            varName = exampleName != null ? exampleName : SentenceResolver.findUnique("i++", par);
        }
        VarDecl varDecl = VarDecl.of(varName, type, null);
        takeSentence.setVarName(ResolvedName.of(varDecl));
        return varDecl;
    }
}

