/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tools;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;
import org.fulib.yaml.YamlIdMap;
import org.stringtemplate.v4.ST;

public class ScenarioDiagrams {
    private int objCount = 0;

    public void dump(String fileName, Object root) {
        Objects.requireNonNull(root);
        try {
            String packageName = root.getClass().getPackage().getName();
            YamlIdMap idMap = new YamlIdMap(packageName);
            ReflectorMap reflectorMap = new ReflectorMap(packageName);
            LinkedHashSet<Object> diagramObjects = idMap.collectObjects(root);
            String dotString = "digraph H {\n<nodes> \n<messages> \n<edges> \n}\n";
            StringBuilder messages = new StringBuilder();
            StringBuilder edges = new StringBuilder();
            String nodesString = this.makeServices(root, idMap, reflectorMap, messages, edges);
            ST st = new ST(dotString);
            st.add("nodes", (Object)nodesString);
            st.add("messages", (Object)messages);
            st.add("edges", (Object)edges);
            dotString = st.render();
            Graphviz.fromString((String)dotString.toString()).render(Format.SVG).toFile(new File(fileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String makeServices(Object root, YamlIdMap idMap, ReflectorMap reflectorMap, StringBuilder messages, StringBuilder edges) {
        Reflector rootReflector = reflectorMap.getReflector(root);
        Collection services = this.toCollection(rootReflector.getValue(root, "services"));
        StringBuilder buf = new StringBuilder();
        for (Object service : services) {
            String oneService = "   subgraph cluster_<name> {\n      color=darkgrey;\n      label = \"<description>\";\n\n<states>\n   }\n\n";
            Reflector serviceReflector = reflectorMap.getReflector(service);
            String id = idMap.getIdObjMap().get(service);
            Object description = serviceReflector.getValue(service, "description");
            String states = this.makeStates(service, idMap, reflectorMap, messages, edges);
            ST st = new ST(oneService);
            st.add("name", (Object)id);
            st.add("description", description);
            st.add("states", (Object)states);
            oneService = st.render();
            buf.append(oneService);
        }
        return buf.toString();
    }

    private String makeStates(Object service, YamlIdMap idMap, ReflectorMap reflectorMap, StringBuilder messages, StringBuilder edges) {
        Reflector reflector = reflectorMap.getReflector(service);
        Collection states = this.toCollection(reflector.getValue(service, "states"));
        StringBuilder buf = new StringBuilder();
        for (Object state : states) {
            Reflector stateReflector = this.makeOneNode(idMap, reflectorMap, buf, state, "state");
            String stateId = idMap.getIdObjMap().get(state);
            Collection sendMessages = this.toCollection(stateReflector.getValue(state, "sendMessages"));
            for (Object message : sendMessages) {
                Reflector messageReflector = reflectorMap.getReflector(message);
                String messageId = idMap.getIdObjMap().get(message);
                this.makeOneNode(idMap, reflectorMap, messages, message, "message");
                edges.append(String.format("   %s -> %s;\n", stateId, messageId));
                Collection targets = this.toCollection(messageReflector.getValue(message, "targets"));
                for (Object target : targets) {
                    Reflector targetReflector = reflectorMap.getReflector(target);
                    String targetId = idMap.getIdObjMap().get(target);
                    edges.append(String.format("   %s -> %s;\n", messageId, targetId));
                }
            }
        }
        return buf.toString();
    }

    private Reflector makeOneNode(YamlIdMap idMap, ReflectorMap reflectorMap, StringBuilder buf, Object state, String kind) {
        String oneNode = "      <id> [\n           shape=plaintext\n           fontsize=\"10\"\n           label=\\<\n             \\<table border='1' cellborder='0' cellspacing='0'>\n<rows>             \\</table>\n          >];\n";
        if ("message".equals(kind)) {
            oneNode = "      <id> [\n           shape=note\n           fontsize=\"10\"\n           label=\\<\n             \\<table border='0' cellborder='0' cellspacing='0'>\n<rows>             \\</table>\n          >];\n";
        }
        Reflector stateReflector = reflectorMap.getReflector(state);
        String id = idMap.getIdObjMap().get(state);
        Object time = stateReflector.getValue(state, "time");
        if (time == null) {
            time = "00:00:00";
        }
        StringBuilder descriptionTable = new StringBuilder();
        descriptionTable.append(String.format("                <tr><td bgcolor='#F0F0F0'>%s</td></tr>\n", time));
        this.makeOneDescription(state, stateReflector, descriptionTable);
        Collection content = this.toCollection(stateReflector.getValue(state, "content"));
        for (Object c : content) {
            Reflector contentReflector = reflectorMap.getReflector(c);
            this.makeOneDescription(c, contentReflector, descriptionTable);
        }
        ST st = new ST(oneNode);
        st.add("id", (Object)id);
        st.add("rows", (Object)descriptionTable.toString());
        oneNode = st.render();
        buf.append(oneNode);
        return stateReflector;
    }

    private StringBuilder makeOneDescription(Object state, Reflector stateReflector, StringBuilder descriptionTable) {
        String[] split;
        String description = (String)stateReflector.getValue(state, "description");
        if (description == null) {
            description = "";
        }
        StringBuilder rows = new StringBuilder();
        for (String line : split = description.split("\n")) {
            String[] words;
            line = line.trim();
            StringBuilder cells = new StringBuilder();
            for (String word : words = line.split("\\|")) {
                if ((word = word.trim()).startsWith("input")) {
                    word = String.format("<u>%s</u>", word.substring("input ".length()));
                } else if (word.startsWith("button")) {
                    word = String.format("[%s]", word.substring("button ".length()));
                }
                cells.append(String.format("<td>%s</td>", word));
            }
            rows.append(String.format("                <tr>%s</tr>\n", cells.toString()));
        }
        descriptionTable.append(String.format("                <tr><td>\n                   <table border='0' cellborder='0' cellspacing='0'>\n%s                   </table>\n                </td></tr>\n", rows.toString()));
        return descriptionTable;
    }

    private Collection toCollection(Object contentObj) {
        Collection<Object> content = new ArrayList();
        if (contentObj instanceof Collection) {
            content = (Collection)contentObj;
        } else if (contentObj != null) {
            content.add(contentObj);
        }
        return content;
    }
}

