/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.builder;

import java.lang.reflect.TypeVariable;
import java.util.Collection;
import org.fulib.builder.ClassBuilder;
import org.fulib.classmodel.ClassModel;

public class ClassModelBuilder {
    public static final String STRING = "String";
    public static final String LONG = "long";
    public static final String INT = "int";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String BOOLEAN = "boolean";
    public static final int ONE = 1;
    public static final int MANY = 42;
    public static final String COLLECTION_ARRAY_LIST = "java.util.ArrayList<%s>";
    public static final String COLLECTION_LINKED_HASH_SET = "java.util.LinkedHashSet<%s>";
    public static final String POJO = "POJO";
    public static final String JAVA_FX = "JavaFX";
    private ClassModel classModel;

    public ClassModelBuilder(String packagename) {
        this(packagename, "src/main/java");
    }

    public ClassModelBuilder(String packagename, String sourceFolder) {
        ClassModelBuilder.checkValidJavaId(packagename);
        ClassModel classModel = new ClassModel().setPackageName(packagename).setMainJavaDir(sourceFolder).setDefaultPropertyStyle(POJO).setDefaultRoleType(COLLECTION_ARRAY_LIST);
        this.setClassModel(classModel);
    }

    static void checkValidJavaId(String myRoleName) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("" + myRoleName + " is not an valid java identifier");
        if (myRoleName == null) {
            throw illegalArgumentException;
        }
        if (myRoleName.endsWith(".") || myRoleName.startsWith(".")) {
            throw illegalArgumentException;
        }
        if (myRoleName.indexOf(46) >= 0) {
            for (String s : myRoleName.split("\\.")) {
                ClassModelBuilder.checkValidJavaId(s);
            }
            return;
        }
        if (!myRoleName.matches("[a-zA-Z_]\\w*")) {
            throw illegalArgumentException;
        }
        String javaKeyWords = " abstract assert boolean break byte case catch char class const continue default do double else enum extends final finally float for goto if implements import instanceof int interface long native new package private protected public return short static strictfp super switch synchronized this throw throws transient try void volatile while  true  false null ";
        if (javaKeyWords.indexOf(" " + myRoleName + " ") >= 0) {
            throw illegalArgumentException;
        }
    }

    private void setClassModel(ClassModel classModel) {
        this.classModel = classModel;
    }

    public ClassModel getClassModel() {
        return this.classModel;
    }

    public ClassModelBuilder setDefaultCollectionClass(Class collectionClass) {
        if (!Collection.class.isAssignableFrom(collectionClass)) {
            throw new IllegalArgumentException("class is no collection");
        }
        String defaultRoleType = collectionClass.getName();
        TypeVariable<Class<T>>[] typeParameters = collectionClass.getTypeParameters();
        if (typeParameters.length == 1) {
            defaultRoleType = defaultRoleType + "<%s>";
        }
        this.classModel.setDefaultRoleType(defaultRoleType);
        return this;
    }

    public ClassModelBuilder setJavaFXPropertyStyle() {
        this.classModel.setDefaultPropertyStyle(JAVA_FX);
        return this;
    }

    public ClassBuilder buildClass(String className) {
        ClassBuilder classBuilder = new ClassBuilder(this.classModel, className);
        return classBuilder;
    }
}

