/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.codegen;

import org.fulib.StrUtil;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.operator.BinaryOperator;
import org.fulib.scenarios.ast.sentence.AddSentence;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.AssignSentence;
import org.fulib.scenarios.ast.sentence.ConditionalSentence;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.ExpectSentence;
import org.fulib.scenarios.ast.sentence.ExprSentence;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.RemoveSentence;
import org.fulib.scenarios.ast.sentence.SectionSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.TakeSentence;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.visitor.codegen.AssertionGenerator;
import org.fulib.scenarios.visitor.codegen.CodeGenDTO;
import org.fulib.scenarios.visitor.codegen.DeclGenerator;
import org.fulib.scenarios.visitor.codegen.ExprGenerator;
import org.fulib.scenarios.visitor.codegen.TypeGenerator;

public enum SentenceGenerator implements Sentence.Visitor<CodeGenDTO, Object>
{
    INSTANCE;


    @Override
    public Object visit(Sentence sentence, CodeGenDTO par) {
        return null;
    }

    @Override
    public Object visit(SentenceList sentenceList, CodeGenDTO par) {
        for (Sentence item : sentenceList.getItems()) {
            item.accept(this, par);
        }
        return null;
    }

    @Override
    public Object visit(SectionSentence sectionSentence, CodeGenDTO par) {
        par.emitIndent();
        par.bodyBuilder.append(sectionSentence.getLevel().format(sectionSentence.getText().trim()));
        par.bodyBuilder.append('\n');
        return null;
    }

    @Override
    public Object visit(ExpectSentence expectSentence, CodeGenDTO par) {
        for (Expr expr : expectSentence.getPredicates()) {
            par.emitIndent();
            expr.accept(AssertionGenerator.INSTANCE, par);
            par.bodyBuilder.append(";\n");
        }
        return null;
    }

    @Override
    public Object visit(DiagramSentence diagramSentence, CodeGenDTO par) {
        String toolMethod;
        String toolClass;
        String extension;
        String sourceDir = par.group.getSourceDir();
        String packageDir = par.group.getPackageDir();
        String fileName = diagramSentence.getFileName();
        String target = (sourceDir + "/" + packageDir + "/" + fileName).replace('\\', '/');
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex < 0) {
            throw new IllegalStateException("invalid file name '" + fileName + "' - missing extension");
        }
        switch (extension = fileName.substring(dotIndex).toLowerCase()) {
            case ".svg": {
                toolClass = "org.fulib.FulibTools";
                toolMethod = "FulibTools.objectDiagrams().dumpSVG";
                break;
            }
            case ".png": {
                toolClass = "org.fulib.FulibTools";
                toolMethod = "FulibTools.objectDiagrams().dumpPng";
                break;
            }
            case ".yaml": {
                toolClass = "org.fulib.FulibTools";
                toolMethod = "FulibTools.objectDiagrams().dumpYaml";
                break;
            }
            case ".html": {
                toolClass = "org.fulib.scenarios.MockupTools";
                toolMethod = "MockupTools.htmlTool().dump";
                break;
            }
            case ".txt": {
                toolClass = "org.fulib.scenarios.MockupTools";
                toolMethod = "MockupTools.htmlTool().dumpToString";
                break;
            }
            default: {
                throw new IllegalStateException("invalid file name '" + fileName + "' - unsupported extension");
            }
        }
        par.addImport(toolClass);
        par.emitIndent();
        par.bodyBuilder.append(toolMethod).append('(');
        par.emitStringLiteral(target);
        par.bodyBuilder.append(", ");
        diagramSentence.getObject().accept(ExprGenerator.NO_LIST, par);
        par.bodyBuilder.append(");\n");
        return null;
    }

    @Override
    public Object visit(HasSentence hasSentence, CodeGenDTO par) {
        par.emitIndent();
        Expr receiver = hasSentence.getObject();
        Type receiverType = receiver.getType();
        receiver.accept(ExprGenerator.INSTANCE, par);
        if (receiverType instanceof ListType) {
            par.bodyBuilder.append(".forEach(it -> it");
        }
        for (NamedExpr attribute : hasSentence.getClauses()) {
            ExprGenerator.generateSetterCall(par, attribute);
        }
        if (receiverType instanceof ListType) {
            par.bodyBuilder.append(")");
        }
        par.bodyBuilder.append(";\n");
        return null;
    }

    @Override
    public Object visit(IsSentence isSentence, CodeGenDTO par) {
        isSentence.getDescriptor().accept(DeclGenerator.INSTANCE, par);
        return null;
    }

    @Override
    public Object visit(AnswerSentence answerSentence, CodeGenDTO par) {
        par.emitIndent();
        par.bodyBuilder.append("return ");
        answerSentence.getResult().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(";\n");
        return null;
    }

    @Override
    public Object visit(AddSentence addSentence, CodeGenDTO par) {
        par.emitIndent();
        Expr target = addSentence.getTarget();
        Expr source = addSentence.getSource();
        if (target instanceof AttributeAccess) {
            AttributeAccess attributeAccess = (AttributeAccess)target;
            attributeAccess.getReceiver().accept(ExprGenerator.INSTANCE, par);
            par.bodyBuilder.append(".with").append(StrUtil.cap(attributeAccess.getName().getValue())).append('(');
            source.accept(ExprGenerator.NO_LIST, par);
            par.bodyBuilder.append(");\n");
            return null;
        }
        target.accept(ExprGenerator.INSTANCE, par);
        if (source.getType() instanceof ListType) {
            par.bodyBuilder.append(".addAll(");
        } else {
            par.bodyBuilder.append(".add(");
        }
        source.accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(");\n");
        return null;
    }

    @Override
    public Object visit(RemoveSentence removeSentence, CodeGenDTO par) {
        par.emitIndent();
        Expr target = removeSentence.getTarget();
        Expr source = removeSentence.getSource();
        if (target instanceof AttributeAccess) {
            AttributeAccess attributeAccess = (AttributeAccess)target;
            attributeAccess.getReceiver().accept(ExprGenerator.INSTANCE, par);
            par.bodyBuilder.append(".without").append(StrUtil.cap(attributeAccess.getName().getValue())).append('(');
            source.accept(ExprGenerator.NO_LIST, par);
            par.bodyBuilder.append(");\n");
            return null;
        }
        target.accept(ExprGenerator.INSTANCE, par);
        if (source.getType() instanceof ListType) {
            par.bodyBuilder.append(".removeAll(");
            source.accept(ExprGenerator.INSTANCE, par);
            par.bodyBuilder.append(");\n");
            return null;
        }
        par.addImport("java.util.Collections");
        par.bodyBuilder.append(".removeAll(Collections.singletonList(");
        source.accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append("));\n");
        return null;
    }

    @Override
    public Object visit(TakeSentence takeSentence, CodeGenDTO par) {
        par.emitIndent();
        par.bodyBuilder.append("for (final ");
        Type elementType = takeSentence.getVarName().getDecl().getType();
        String varName = takeSentence.getVarName().getValue();
        par.bodyBuilder.append(elementType.accept(TypeGenerator.INSTANCE, par));
        par.bodyBuilder.append(' ');
        par.bodyBuilder.append(varName);
        par.bodyBuilder.append(" : ");
        takeSentence.getCollection().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(") {\n");
        ++par.indentLevel;
        takeSentence.getBody().accept(this, par);
        --par.indentLevel;
        par.emitIndent();
        par.bodyBuilder.append("}\n");
        return null;
    }

    @Override
    public Object visit(ConditionalSentence conditionalSentence, CodeGenDTO par) {
        par.emitIndent();
        par.bodyBuilder.append("if (");
        conditionalSentence.getCondition().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(") {\n");
        ++par.indentLevel;
        conditionalSentence.getBody().accept(this, par);
        --par.indentLevel;
        par.emitIndent();
        par.bodyBuilder.append("}\n");
        return null;
    }

    @Override
    public Object visit(AssignSentence assignSentence, CodeGenDTO par) {
        par.emitIndent();
        par.bodyBuilder.append(assignSentence.getTarget().getName());
        par.bodyBuilder.append(' ');
        BinaryOperator operator = assignSentence.getOperator();
        if (operator != null) {
            par.bodyBuilder.append(operator.getSymbol());
        }
        par.bodyBuilder.append("= ");
        assignSentence.getValue().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(";\n");
        return null;
    }

    @Override
    public Object visit(ExprSentence exprSentence, CodeGenDTO par) {
        par.emitIndent();
        exprSentence.getExpr().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(";\n");
        return null;
    }
}

