/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tools;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.apache.commons.text.StringEscapeUtils;
import org.fulib.classmodel.AssocRole;
import org.fulib.classmodel.Attribute;
import org.fulib.classmodel.ClassModel;
import org.fulib.classmodel.Clazz;
import org.stringtemplate.v4.ST;

public class ClassDiagrams {
    public String dumpPng(ClassModel model) {
        String diagramFileName = model.getPackageSrcFolder() + "/doc-files/classDiagram.png";
        return this.dumpPng(model, diagramFileName);
    }

    public String dumpPng(ClassModel model, String diagramFileName) {
        return this.dump(model, diagramFileName, Format.PNG);
    }

    public String dumpSVG(ClassModel model, String diagramFileName) {
        return this.dump(model, diagramFileName, Format.SVG);
    }

    public String dump(ClassModel model, String diagramFileName, Format format) {
        try {
            String dotString = "digraph H {\nrankdir=BT\n<nodes> \n<edges> \n}\n";
            String nodesString = this.makeNodes(model);
            String edgesString = this.makeEdges(model);
            ST st = new ST(dotString);
            st.add("nodes", (Object)nodesString);
            st.add("edges", (Object)edgesString);
            dotString = st.render();
            Graphviz.fromString((String)dotString.toString()).render(format).toFile(new File(diagramFileName));
            return diagramFileName;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String makeEdges(ClassModel model) {
        StringBuilder buf = new StringBuilder();
        LinkedHashSet<AssocRole> roles = new LinkedHashSet<AssocRole>();
        for (Clazz c : model.getClasses()) {
            roles.addAll(c.getRoles());
        }
        LinkedHashSet<AssocRole> done = new LinkedHashSet<AssocRole>();
        for (AssocRole assoc : roles) {
            String targetLabel;
            if (done.contains(assoc)) continue;
            done.add(assoc);
            if (assoc.getOther() != null) {
                done.add(assoc.getOther());
            }
            String sourceId = assoc.getClazz().getName();
            String targetId = assoc.getOther().getClazz().getName();
            String sourceLabel = assoc.getName();
            if (sourceLabel == null) {
                sourceLabel = "";
            }
            if (assoc.getCardinality() != 1) {
                sourceLabel = sourceLabel + " *";
            }
            if ((targetLabel = assoc.getOther().getName()) == null) {
                targetLabel = "";
            }
            if (assoc.getOther().getCardinality() != 1) {
                targetLabel = targetLabel + " *";
            }
            buf.append(targetId).append(" -> ").append(sourceId).append(" [arrowhead=none fontsize=\"10\" taillabel=\"" + sourceLabel + "\" headlabel=\"" + targetLabel + "\"];\n");
        }
        return buf.toString();
    }

    private String makeNodes(ClassModel model) {
        StringBuilder buf = new StringBuilder();
        for (Clazz clazz : model.getClasses()) {
            String objId = clazz.getName();
            buf.append(objId).append(" [\n   shape=plaintext\n   fontsize=\"10\"\n   label=<\n     <table border='0' cellborder='1' cellspacing='0'>\n       <tr><td>").append(objId).append("</td></tr>\n       <tr><td>");
            for (Attribute key : clazz.getAttributes()) {
                buf.append(key.getName()).append(" :").append(StringEscapeUtils.escapeHtml4((String)key.getType())).append("<br  align='left'/>");
            }
            buf.append("</td></tr>\n     </table>\n  >];\n");
        }
        return buf.toString();
    }
}

