/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.classmodel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.fulib.classmodel.Clazz;

public class FMethod {
    private LinkedHashMap<String, String> params;
    public static final String PROPERTY_methodBody = "methodBody";
    private String methodBody;
    protected PropertyChangeSupport listeners = null;
    private String name;
    private String returnType;
    public static final String PROPERTY_declaration = "declaration";
    public static final String PROPERTY_clazz = "clazz";
    private Clazz clazz = null;
    private String declaration;
    public static final String PROPERTY_modified = "modified";
    private boolean modified = false;
    public static final String PROPERTY_annotations = "annotations";
    private String annotations;

    public LinkedHashMap<String, String> readParams() {
        if (this.params == null) {
            this.params = new LinkedHashMap();
        }
        return this.params;
    }

    public String getMethodBody() {
        return this.methodBody;
    }

    public FMethod setMethodBody(String value) {
        if (value == null ? this.methodBody != null : !value.equals(this.methodBody)) {
            String oldValue = this.methodBody;
            this.methodBody = value;
            this.firePropertyChange(PROPERTY_methodBody, oldValue, value);
        }
        return this;
    }

    public boolean firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listeners != null) {
            this.listeners.firePropertyChange(propertyName, oldValue, newValue);
            return true;
        }
        return false;
    }

    public boolean addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(listener);
        return true;
    }

    public boolean addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyName, listener);
        return true;
    }

    public boolean removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(listener);
        }
        return true;
    }

    public boolean removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(propertyName, listener);
        }
        return true;
    }

    public void removeYou() {
        this.setClazz(null);
    }

    public String readName() {
        return this.name;
    }

    public FMethod writeName(String newName) {
        this.name = newName;
        return this;
    }

    public String readSignature() {
        this.readParams().remove("this");
        String paramTypes = String.join((CharSequence)",", this.readParams().values());
        String result = String.format("method:%s(%s)", this.readName(), paramTypes);
        return result;
    }

    public String readReturnType() {
        return this.returnType;
    }

    public FMethod writeReturnType(String value) {
        this.returnType = value;
        return this;
    }

    public FMethod setDeclaration(String value) {
        if (value == null) {
            if (this.getDeclaration() == null) {
                return this;
            }
            this.name = null;
            this.returnType = "void";
            this.readParams().clear();
        }
        if (!value.equals(this.getDeclaration())) {
            String newReturnType;
            String newName;
            String oldValue = this.getDeclaration();
            int pos = value.indexOf(40);
            String namePart = value.substring(0, pos);
            String params = value.substring(pos + 1, value.length() - 1);
            String[] split = namePart.split(" ");
            String modifier = split[0];
            if (modifier.startsWith("@")) {
                int publicPos = modifier.indexOf("public");
                String annos = modifier.substring(0, publicPos - 1);
                this.setAnnotations(annos);
            }
            this.name = newName = split[2];
            this.returnType = newReturnType = split[1];
            this.setParamsByString(params);
            this.firePropertyChange(PROPERTY_declaration, oldValue, value);
        }
        return this;
    }

    public String getDeclaration() {
        if (this.name == null) {
            return null;
        }
        String declaration = String.format("public %s %s(%s)", this.returnType, this.name, this.readFullParamsString());
        if (this.annotations != null) {
            declaration = this.annotations + "\n   " + declaration;
        }
        return declaration;
    }

    public String readFullParamsString() {
        ArrayList<String> paramList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.readParams().entrySet()) {
            String paramName = entry.getKey();
            String paramType = entry.getValue();
            paramList.add(paramType + " " + paramName);
        }
        String result = String.join((CharSequence)", ", paramList);
        return result;
    }

    public FMethod setParamsByString(String params) {
        String[] split = params.split(", ");
        this.readParams().clear();
        for (String s : split) {
            if (s.equals("")) break;
            String[] pair = s.split(" ");
            this.readParams().put(pair[1], pair[0]);
        }
        return this;
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public FMethod setClazz(Clazz value) {
        if (this.clazz != value) {
            Clazz oldValue = this.clazz;
            if (this.clazz != null) {
                this.clazz = null;
                oldValue.withoutMethods(this);
            }
            this.clazz = value;
            if (value != null) {
                value.withMethods(this);
            }
            this.firePropertyChange(PROPERTY_clazz, oldValue, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(this.getDeclaration());
        result.append(" ").append(this.getMethodBody());
        result.append(" ").append(this.getAnnotations());
        return result.substring(1);
    }

    public boolean getModified() {
        return this.modified;
    }

    public FMethod setModified(boolean value) {
        if (value != this.modified) {
            boolean oldValue = this.modified;
            this.modified = value;
            this.firePropertyChange(PROPERTY_modified, oldValue, value);
        }
        return this;
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public FMethod setAnnotations(String value) {
        if (value == null ? this.annotations != null : !value.equals(this.annotations)) {
            String oldValue = this.annotations;
            this.annotations = value;
            this.firePropertyChange(PROPERTY_annotations, oldValue, value);
        }
        return this;
    }
}

