/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.access.ExampleAccess;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.sentence.FlattenSentenceList;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.diagnostic.Position;

public enum AssignmentResolve implements Expr.Visitor<Expr, Sentence>
{
    INSTANCE;


    @Override
    public Sentence visit(Expr expr, Expr par) {
        return null;
    }

    @Override
    public Sentence visit(AttributeAccess attributeAccess, Expr par) {
        Expr receiver = attributeAccess.getReceiver();
        Name name = attributeAccess.getName();
        NamedExpr namedExpr = NamedExpr.of(name, par);
        HasSentence hasSentence = HasSentence.of(receiver, Collections.singletonList(namedExpr));
        hasSentence.setPosition(attributeAccess.getPosition());
        return hasSentence;
    }

    @Override
    public Sentence visit(ExampleAccess exampleAccess, Expr par) {
        return exampleAccess.getExpr().accept(this, par);
    }

    @Override
    public Sentence visit(ListExpr listExpr, Expr par) {
        List<Expr> sources;
        List<Expr> targets = listExpr.getElements();
        int numElements = targets.size();
        ArrayList<Sentence> result = new ArrayList<Sentence>(numElements);
        if (par instanceof ListExpr && (sources = ((ListExpr)par).getElements()).size() == numElements) {
            for (int i = 0; i < numElements; ++i) {
                Expr target = targets.get(i);
                Expr source = sources.get(i);
                Sentence part = target.accept(this, source);
                result.add(part);
            }
        } else {
            Position position = par.getPosition();
            VarDecl temp = VarDecl.of("temp++", null, par);
            temp.setPosition(position);
            IsSentence isSentence = IsSentence.of(temp);
            isSentence.setPosition(position);
            result.add(isSentence);
            for (Expr target : targets) {
                ResolvedName name = ResolvedName.of(temp);
                name.setPosition(position);
                NameAccess source = NameAccess.of(name);
                source.setPosition(position);
                Sentence part = target.accept(this, source);
                result.add(part);
            }
        }
        return new FlattenSentenceList(result);
    }

    @Override
    public Sentence visit(NameAccess nameAccess, Expr par) {
        String name = nameAccess.getName().getValue();
        VarDecl varDecl = VarDecl.of(name, null, par);
        varDecl.setPosition(nameAccess.getPosition());
        IsSentence isSentence = IsSentence.of(varDecl);
        isSentence.setPosition(varDecl.getPosition());
        return isSentence;
    }
}

